/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Optionality;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class BitwiseSqlAggregator
implements SqlAggregator {
    private static final SqlAggFunction XOR_FUNCTION = new BitwiseXorSqlAggFunction();
    private final Op op;

    public BitwiseSqlAggregator(Op op) {
        this.op = op;
    }

    @Override
    public SqlAggFunction calciteFunction() {
        return this.op.getCalciteFunction();
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        List arguments = aggregateCall.getArgList().stream().map(i -> Expressions.fromFieldAccess(rowSignature, project, i)).map(rexNode -> Expressions.toDruidExpression(plannerContext, rowSignature, rexNode)).collect(Collectors.toList());
        if (arguments.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        DruidExpression arg = (DruidExpression)arguments.get(0);
        ExprMacroTable macroTable = plannerContext.getExprMacroTable();
        String fieldName = arg.isDirectColumnAccess() ? arg.getDirectColumn() : virtualColumnRegistry.getOrCreateVirtualColumnForExpression(arg, ColumnType.LONG);
        return Aggregation.create((AggregatorFactory)new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory(name, (Set)ImmutableSet.of((Object)fieldName), null, "0", null, null, Boolean.valueOf(false), Boolean.valueOf(false), StringUtils.format((String)"%s(\"__acc\", \"%s\")", (Object[])new Object[]{this.op.getDruidFunction(), fieldName}), null, null, null, null, macroTable), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter(fieldName, null, null))));
    }

    private static class BitwiseXorSqlAggFunction
    extends SqlAggFunction {
        BitwiseXorSqlAggFunction() {
            super("BIT_XOR", null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.BIGINT), InferTypes.ANY_NULLABLE, (SqlOperandTypeChecker)OperandTypes.EXACT_NUMERIC, SqlFunctionCategory.NUMERIC, false, false, Optionality.IGNORED);
        }
    }

    public static enum Op {
        AND{

            @Override
            SqlAggFunction getCalciteFunction() {
                return SqlStdOperatorTable.BIT_AND;
            }

            @Override
            String getDruidFunction() {
                return "bitwiseAnd";
            }
        }
        ,
        OR{

            @Override
            SqlAggFunction getCalciteFunction() {
                return SqlStdOperatorTable.BIT_OR;
            }

            @Override
            String getDruidFunction() {
                return "bitwiseOr";
            }
        }
        ,
        XOR{

            @Override
            SqlAggFunction getCalciteFunction() {
                return XOR_FUNCTION;
            }

            @Override
            String getDruidFunction() {
                return "bitwiseXor";
            }
        };


        abstract SqlAggFunction getCalciteFunction();

        abstract String getDruidFunction();
    }
}

