/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.base.Preconditions;
import org.apache.calcite.avatica.Meta;
import org.apache.druid.query.QueryContext;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.avatica.AbstractDruidJdbcStatement;
import org.apache.druid.sql.avatica.DruidJdbcResultSet;

public class DruidJdbcStatement
extends AbstractDruidJdbcStatement {
    private final SqlStatementFactory lifecycleFactory;
    protected final QueryContext queryContext;

    public DruidJdbcStatement(String connectionId, int statementId, QueryContext queryContext, SqlStatementFactory lifecycleFactory) {
        super(connectionId, statementId);
        this.queryContext = queryContext;
        this.lifecycleFactory = (SqlStatementFactory)Preconditions.checkNotNull((Object)lifecycleFactory, (Object)"lifecycleFactory");
    }

    public synchronized void execute(SqlQueryPlus queryPlus, long maxRowCount) {
        this.closeResultSet();
        queryPlus = queryPlus.withContext(this.queryContext);
        DirectStatement stmt = this.lifecycleFactory.directStatement(queryPlus);
        this.resultSet = new DruidJdbcResultSet(this, stmt, Long.MAX_VALUE);
        try {
            this.resultSet.execute();
        }
        catch (Throwable t) {
            this.closeResultSet();
            throw t;
        }
    }

    @Override
    public Meta.Signature getSignature() {
        return this.requireResultSet().getSignature();
    }
}

