/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.calcite.avatica.Meta;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.avatica.AbstractDruidJdbcStatement;
import org.apache.druid.sql.avatica.DruidMeta;

public class DruidJdbcResultSet
implements Closeable {
    private final ExecutorService yielderOpenCloseExecutor;
    private final DirectStatement stmt;
    private final long maxRowCount;
    private State state = State.NEW;
    private Meta.Signature signature;
    private Yielder<Object[]> yielder;
    private int offset;

    public DruidJdbcResultSet(AbstractDruidJdbcStatement jdbcStatement, DirectStatement stmt, long maxRowCount) {
        this.stmt = stmt;
        this.maxRowCount = maxRowCount;
        this.yielderOpenCloseExecutor = Execs.singleThreaded((String)StringUtils.format((String)"JDBCYielderOpenCloseExecutor-connection-%s-statement-%d", (Object[])new Object[]{StringUtils.encodeForFormat((String)jdbcStatement.getConnectionId()), jdbcStatement.getStatementId()}));
    }

    public synchronized void execute() {
        this.ensure(State.NEW);
        try {
            this.state = State.RUNNING;
            Sequence baseSequence = this.yielderOpenCloseExecutor.submit(this.stmt::execute).get();
            Sequence retSequence = this.maxRowCount >= 0L && this.maxRowCount <= Integer.MAX_VALUE ? baseSequence.limit((long)((int)this.maxRowCount)) : baseSequence;
            this.yielder = Yielders.each((Sequence)retSequence);
            this.signature = AbstractDruidJdbcStatement.createSignature(this.stmt.prepareResult(), this.stmt.query().sql());
        }
        catch (ExecutionException e) {
            throw this.closeAndPropagateThrowable(e.getCause());
        }
        catch (Throwable t) {
            throw this.closeAndPropagateThrowable(t);
        }
    }

    public synchronized boolean isDone() {
        return this.state == State.DONE;
    }

    public synchronized Meta.Signature getSignature() {
        this.ensure(State.RUNNING, State.DONE);
        return this.signature;
    }

    public synchronized Meta.Frame nextFrame(long fetchOffset, int fetchMaxRowCount) {
        this.ensure(State.RUNNING, State.DONE);
        Preconditions.checkState((fetchOffset == (long)this.offset ? 1 : 0) != 0, (String)"fetchOffset [%,d] != offset [%,d]", (Object[])new Object[]{fetchOffset, this.offset});
        if (this.state == State.DONE) {
            return new Meta.Frame(fetchOffset, true, Collections.emptyList());
        }
        try {
            ArrayList<Object> rows = new ArrayList<Object>();
            while (!(this.yielder.isDone() || fetchMaxRowCount >= 0 && (long)this.offset >= fetchOffset + (long)fetchMaxRowCount)) {
                rows.add(this.yielder.get());
                this.yielder = this.yielder.next(null);
                ++this.offset;
            }
            if (this.yielder.isDone()) {
                this.state = State.DONE;
            }
            return new Meta.Frame(fetchOffset, this.state == State.DONE, rows);
        }
        catch (Throwable t) {
            throw this.closeAndPropagateThrowable(t);
        }
    }

    public synchronized long getCurrentOffset() {
        this.ensure(State.RUNNING, State.DONE);
        return this.offset;
    }

    @GuardedBy(value="this")
    private void ensure(State ... desiredStates) {
        for (State desiredState : desiredStates) {
            if (this.state != desiredState) continue;
            return;
        }
        throw new ISE("Invalid action for state [%s]", new Object[]{this.state});
    }

    private RuntimeException closeAndPropagateThrowable(Throwable t) {
        DruidMeta.logFailure(t);
        this.stmt.reporter().failed(t);
        try {
            this.close();
        }
        catch (Throwable t1) {
            t.addSuppressed(t1);
        }
        finally {
            this.state = State.FAILED;
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException(t);
    }

    @Override
    public synchronized void close() {
        if (this.state == State.NEW) {
            this.state = State.CLOSED;
        }
        if (this.state == State.CLOSED || this.state == State.FAILED) {
            return;
        }
        this.state = State.CLOSED;
        try {
            if (this.yielder != null) {
                Yielder<Object[]> theYielder = this.yielder;
                this.yielder = null;
                this.yielderOpenCloseExecutor.submit(() -> {
                    theYielder.close();
                    return null;
                }).get();
                this.yielderOpenCloseExecutor.shutdownNow();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            this.stmt.close();
        }
    }

    private static enum State {
        NEW,
        RUNNING,
        DONE,
        FAILED,
        CLOSED;

    }
}

