/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.List;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.PreparedStatement;
import org.apache.druid.sql.avatica.AbstractDruidJdbcStatement;
import org.apache.druid.sql.avatica.DruidJdbcResultSet;
import org.apache.druid.sql.calcite.planner.PrepareResult;

public class DruidJdbcPreparedStatement
extends AbstractDruidJdbcStatement {
    private final PreparedStatement sqlStatement;
    private final long maxRowCount;
    private Meta.Signature signature;
    private State state = State.NEW;

    public DruidJdbcPreparedStatement(String connectionId, int statementId, PreparedStatement stmt, long maxRowCount) {
        super(connectionId, statementId);
        this.sqlStatement = stmt;
        this.maxRowCount = maxRowCount;
    }

    public synchronized void prepare() {
        try {
            this.ensure(State.NEW);
            PrepareResult prepareResult = this.sqlStatement.prepare();
            this.signature = DruidJdbcPreparedStatement.createSignature(prepareResult, this.sqlStatement.query().sql());
            this.state = State.PREPARED;
        }
        catch (ForbiddenException e) {
            this.close();
            throw e;
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
        catch (Throwable t) {
            this.close();
            throw new RuntimeException(t);
        }
    }

    @Override
    public synchronized Meta.Signature getSignature() {
        this.ensure(State.PREPARED);
        return this.signature;
    }

    public synchronized void execute(List<TypedValue> parameters) {
        this.ensure(State.PREPARED);
        this.closeResultSet();
        try {
            DirectStatement directStmt = this.sqlStatement.execute(parameters);
            this.resultSet = new DruidJdbcResultSet(this, directStmt, this.maxRowCount);
            this.resultSet.execute();
        }
        catch (RuntimeException e) {
            this.resultSet = null;
            throw e;
        }
        catch (Throwable t) {
            this.resultSet = null;
            throw new RuntimeException(t);
        }
    }

    @GuardedBy(value="this")
    private void ensure(State ... desiredStates) {
        for (State desiredState : desiredStates) {
            if (this.state != desiredState) continue;
            return;
        }
        throw new ISE("Invalid action for state [%s]", new Object[]{this.state});
    }

    @Override
    public synchronized void close() {
        if (this.state != State.CLOSED) {
            super.close();
            this.sqlStatement.close();
        }
        this.state = State.CLOSED;
    }

    static enum State {
        NEW,
        PREPARED,
        CLOSED;

    }
}

