/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryContext;
import org.apache.druid.sql.PreparedStatement;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.avatica.AbstractDruidJdbcStatement;
import org.apache.druid.sql.avatica.DruidJdbcPreparedStatement;
import org.apache.druid.sql.avatica.DruidJdbcStatement;
import org.apache.druid.sql.avatica.DruidMeta;

public class DruidConnection {
    private static final Logger LOG = new Logger(DruidConnection.class);
    private final String connectionId;
    private final int maxStatements;
    private final ImmutableMap<String, Object> userSecret;
    private final QueryContext context;
    private final AtomicInteger statementCounter = new AtomicInteger();
    private final AtomicReference<Future<?>> timeoutFuture = new AtomicReference();
    @GuardedBy(value="connectionLock")
    private final ConcurrentMap<Integer, AbstractDruidJdbcStatement> statements = new ConcurrentHashMap<Integer, AbstractDruidJdbcStatement>();
    private final Object connectionLock = new Object();
    @GuardedBy(value="connectionLock")
    private boolean open = true;

    public DruidConnection(String connectionId, int maxStatements, Map<String, Object> userSecret, QueryContext context) {
        this.connectionId = (String)Preconditions.checkNotNull((Object)connectionId);
        this.maxStatements = maxStatements;
        this.userSecret = ImmutableMap.copyOf(userSecret);
        this.context = context;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidJdbcStatement createStatement(SqlStatementFactory sqlStatementFactory) {
        int statementId = this.statementCounter.incrementAndGet();
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.statements.containsKey(statementId)) {
                throw DruidMeta.logFailure(new ISE("Uh oh, too many statements", new Object[0]));
            }
            if (this.statements.size() >= this.maxStatements) {
                throw DruidMeta.logFailure(new ISE("Too many open statements, limit is [%,d]", new Object[]{this.maxStatements}));
            }
            DruidJdbcStatement statement = new DruidJdbcStatement(this.connectionId, statementId, this.context, sqlStatementFactory);
            this.statements.put(statementId, statement);
            LOG.debug("Connection [%s] opened statement [%s].", new Object[]{this.connectionId, statementId});
            return statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidJdbcPreparedStatement createPreparedStatement(SqlStatementFactory sqlStatementFactory, SqlQueryPlus sqlRequest, long maxRowCount) {
        int statementId = this.statementCounter.incrementAndGet();
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.statements.containsKey(statementId)) {
                throw DruidMeta.logFailure(new ISE("Uh oh, too many statements", new Object[0]));
            }
            if (this.statements.size() >= this.maxStatements) {
                throw DruidMeta.logFailure(new ISE("Too many open statements, limit is [%,d]", new Object[]{this.maxStatements}));
            }
            PreparedStatement statement = sqlStatementFactory.preparedStatement(sqlRequest.withContext(this.context));
            DruidJdbcPreparedStatement jdbcStmt = new DruidJdbcPreparedStatement(this.connectionId, statementId, statement, maxRowCount);
            this.statements.put(statementId, jdbcStmt);
            LOG.debug("Connection [%s] opened prepared statement [%s].", new Object[]{this.connectionId, statementId});
            return jdbcStmt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractDruidJdbcStatement getStatement(int statementId) {
        Object object = this.connectionLock;
        synchronized (object) {
            return (AbstractDruidJdbcStatement)this.statements.get(statementId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatement(int statementId) {
        AbstractDruidJdbcStatement stmt;
        Object object = this.connectionLock;
        synchronized (object) {
            stmt = (AbstractDruidJdbcStatement)this.statements.remove(statementId);
        }
        if (stmt != null) {
            stmt.close();
            LOG.debug("Connection [%s] closed statement [%s].", new Object[]{this.connectionId, statementId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeIfEmpty() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.statements.isEmpty()) {
                this.close();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.connectionLock;
        synchronized (object) {
            for (AbstractDruidJdbcStatement statement : ImmutableList.copyOf(this.statements.values())) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    LOG.warn("Connection [%s] failed to close statement [%s]!", new Object[]{this.connectionId, statement.getStatementId()});
                }
            }
            LOG.debug("Connection [%s] closed.", new Object[]{this.connectionId});
            this.open = false;
        }
    }

    public DruidConnection sync(Future<?> newTimeoutFuture) {
        Future<?> oldFuture = this.timeoutFuture.getAndSet(newTimeoutFuture);
        if (oldFuture != null) {
            oldFuture.cancel(false);
        }
        return this;
    }

    public Map<String, Object> userSecret() {
        return this.userSecret;
    }
}

