/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.sql.Array;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.sql.avatica.DruidJdbcResultSet;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PrepareResult;

public abstract class AbstractDruidJdbcStatement
implements Closeable {
    public static final long START_OFFSET = 0L;
    protected final String connectionId;
    protected final int statementId;
    protected Throwable throwable;
    protected DruidJdbcResultSet resultSet;

    public AbstractDruidJdbcStatement(String connectionId, int statementId) {
        this.connectionId = (String)Preconditions.checkNotNull((Object)connectionId, (Object)"connectionId");
        this.statementId = statementId;
    }

    protected static Meta.Signature createSignature(PrepareResult prepareResult, String sql) {
        ArrayList<AvaticaParameter> params = new ArrayList<AvaticaParameter>();
        RelDataType parameterRowType = prepareResult.getParameterRowType();
        for (RelDataTypeField field : parameterRowType.getFieldList()) {
            RelDataType type = field.getType();
            params.add(AbstractDruidJdbcStatement.createParameter(field, type));
        }
        return Meta.Signature.create(AbstractDruidJdbcStatement.createColumnMetaData(prepareResult.getReturnedRowType()), (String)sql, params, (Meta.CursorFactory)Meta.CursorFactory.ARRAY, (Meta.StatementType)Meta.StatementType.SELECT);
    }

    private static AvaticaParameter createParameter(RelDataTypeField field, RelDataType type) {
        return new AvaticaParameter(false, type.getPrecision(), type.getScale(), type.getSqlTypeName().getJdbcOrdinal(), type.getSqlTypeName().getName(), Calcites.sqlTypeNameJdbcToJavaClass(type.getSqlTypeName()).getName(), field.getName());
    }

    public static List<ColumnMetaData> createColumnMetaData(RelDataType rowType) {
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        List fieldList = rowType.getFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            ColumnMetaData.ScalarType columnType;
            RelDataTypeField field = (RelDataTypeField)fieldList.get(i);
            if (field.getType().getSqlTypeName() == SqlTypeName.ARRAY) {
                ColumnMetaData.Rep elementRep = AbstractDruidJdbcStatement.rep(field.getType().getComponentType().getSqlTypeName());
                ColumnMetaData.ScalarType elementType = ColumnMetaData.scalar((int)field.getType().getComponentType().getSqlTypeName().getJdbcOrdinal(), (String)field.getType().getComponentType().getSqlTypeName().getName(), (ColumnMetaData.Rep)elementRep);
                ColumnMetaData.Rep arrayRep = AbstractDruidJdbcStatement.rep(field.getType().getSqlTypeName());
                columnType = ColumnMetaData.array((ColumnMetaData.AvaticaType)elementType, (String)field.getType().getSqlTypeName().getName(), (ColumnMetaData.Rep)arrayRep);
            } else {
                ColumnMetaData.Rep rep = AbstractDruidJdbcStatement.rep(field.getType().getSqlTypeName());
                columnType = ColumnMetaData.scalar((int)field.getType().getSqlTypeName().getJdbcOrdinal(), (String)field.getType().getSqlTypeName().getName(), (ColumnMetaData.Rep)rep);
            }
            columns.add(new ColumnMetaData(i, false, true, false, false, field.getType().isNullable() ? 1 : 0, true, field.getType().getPrecision(), field.getName(), null, null, field.getType().getPrecision(), field.getType().getScale(), null, null, (ColumnMetaData.AvaticaType)columnType, true, false, false, columnType.columnClassName()));
        }
        return columns;
    }

    private static ColumnMetaData.Rep rep(SqlTypeName sqlType) {
        if (SqlTypeName.CHAR_TYPES.contains(sqlType)) {
            return ColumnMetaData.Rep.of(String.class);
        }
        if (sqlType == SqlTypeName.TIMESTAMP) {
            return ColumnMetaData.Rep.of(Long.class);
        }
        if (sqlType == SqlTypeName.DATE) {
            return ColumnMetaData.Rep.of(Integer.class);
        }
        if (sqlType == SqlTypeName.INTEGER) {
            return ColumnMetaData.Rep.of(Number.class);
        }
        if (sqlType == SqlTypeName.BIGINT) {
            return ColumnMetaData.Rep.of(Number.class);
        }
        if (sqlType == SqlTypeName.FLOAT) {
            return ColumnMetaData.Rep.of(Float.class);
        }
        if (sqlType == SqlTypeName.DOUBLE || sqlType == SqlTypeName.DECIMAL) {
            return ColumnMetaData.Rep.of(Double.class);
        }
        if (sqlType == SqlTypeName.BOOLEAN) {
            return ColumnMetaData.Rep.of(Boolean.class);
        }
        if (sqlType == SqlTypeName.OTHER) {
            return ColumnMetaData.Rep.of(Object.class);
        }
        if (sqlType == SqlTypeName.ARRAY) {
            return ColumnMetaData.Rep.of(Array.class);
        }
        throw new ISE("No rep for SQL type [%s]", new Object[]{sqlType});
    }

    public Meta.Frame nextFrame(long fetchOffset, int fetchMaxRowCount) {
        Meta.Frame frame = this.requireResultSet().nextFrame(fetchOffset, fetchMaxRowCount);
        if (frame.done) {
            this.closeResultSet();
        }
        return frame;
    }

    public abstract Meta.Signature getSignature();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeResultSet() {
        DruidJdbcResultSet currentResultSet;
        AbstractDruidJdbcStatement abstractDruidJdbcStatement = this;
        synchronized (abstractDruidJdbcStatement) {
            currentResultSet = this.resultSet;
            this.resultSet = null;
        }
        if (currentResultSet != null) {
            currentResultSet.close();
        }
    }

    protected synchronized DruidJdbcResultSet requireResultSet() {
        if (this.resultSet == null) {
            throw new ISE("No result set open for statement [%d]", new Object[]{this.statementId});
        }
        return this.resultSet;
    }

    public long getCurrentOffset() {
        return this.requireResultSet().getCurrentOffset();
    }

    public synchronized boolean isDone() {
        return this.resultSet == null ? true : this.resultSet.isDone();
    }

    @Override
    public synchronized void close() {
        this.closeResultSet();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public int getStatementId() {
        return this.statementId;
    }
}

