/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.common.base.Supplier;
import com.google.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.HttpStatement;
import org.apache.druid.sql.PreparedStatement;
import org.apache.druid.sql.SqlLifecycleManager;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.http.SqlQuery;

@LazySingleton
public class SqlStatementFactoryFactory {
    protected final SqlToolbox lifecycleToolbox;

    @Inject
    public SqlStatementFactoryFactory(PlannerFactory plannerFactory, ServiceEmitter emitter, RequestLogger requestLogger, QueryScheduler queryScheduler, AuthConfig authConfig, Supplier<DefaultQueryConfig> defaultQueryConfig, SqlLifecycleManager sqlLifecycleManager) {
        this.lifecycleToolbox = new SqlToolbox(null, plannerFactory, emitter, requestLogger, queryScheduler, authConfig, (DefaultQueryConfig)defaultQueryConfig.get(), sqlLifecycleManager);
    }

    public SqlStatementFactory factorize(SqlEngine engine) {
        return new FactoryImpl(this.lifecycleToolbox.withEngine(engine));
    }

    private static class FactoryImpl
    implements SqlStatementFactory {
        private final SqlToolbox lifecycleToolbox;

        public FactoryImpl(SqlToolbox lifecycleToolbox) {
            this.lifecycleToolbox = lifecycleToolbox;
        }

        @Override
        public HttpStatement httpStatement(SqlQuery sqlQuery, HttpServletRequest req) {
            return new HttpStatement(this.lifecycleToolbox, sqlQuery, req);
        }

        @Override
        public DirectStatement directStatement(SqlQueryPlus sqlRequest) {
            return new DirectStatement(this.lifecycleToolbox, sqlRequest);
        }

        @Override
        public PreparedStatement preparedStatement(SqlQueryPlus sqlRequest) {
            return new PreparedStatement(this.lifecycleToolbox, sqlRequest);
        }
    }
}

