/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import java.io.Closeable;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.SqlExecutionReporter;
import org.apache.druid.sql.SqlPlanningException;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public abstract class AbstractStatement
implements Closeable {
    private static final Logger log = new Logger(AbstractStatement.class);
    protected final SqlToolbox sqlToolbox;
    protected final SqlQueryPlus queryPlus;
    protected final SqlExecutionReporter reporter;
    protected PlannerContext plannerContext;
    protected Set<ResourceAction> cancellationResourceActions;
    protected Set<ResourceAction> fullResourceActions;

    public AbstractStatement(SqlToolbox sqlToolbox, SqlQueryPlus queryPlus, String remoteAddress) {
        this.sqlToolbox = sqlToolbox;
        this.queryPlus = queryPlus;
        this.reporter = new SqlExecutionReporter(this, remoteAddress);
        AbstractStatement.contextWithSqlId(queryPlus.context()).addDefaultParams(sqlToolbox.defaultQueryConfig.getContext());
    }

    private static QueryContext contextWithSqlId(QueryContext queryContext) {
        if (queryContext.removeUserParam("bySegment") != null) {
            log.warn("'bySegment' results are not supported for SQL queries, ignoring query context parameter", new Object[0]);
        }
        queryContext.addDefaultParam("sqlQueryId", (Object)UUID.randomUUID().toString());
        return queryContext;
    }

    public String sqlQueryId() {
        return this.queryPlus.context().getAsString("sqlQueryId");
    }

    protected void validate(DruidPlanner planner) {
        this.plannerContext = planner.getPlannerContext();
        this.plannerContext.setAuthenticationResult(this.queryPlus.authResult());
        this.plannerContext.setParameters(this.queryPlus.parameters());
        try {
            planner.validate();
        }
        catch (SqlParseException e) {
            throw new SqlPlanningException(e);
        }
        catch (ValidationException e) {
            throw new SqlPlanningException(e);
        }
    }

    protected void authorize(DruidPlanner planner, Function<Set<ResourceAction>, Access> authorizer) {
        boolean authorizeContextParams = this.sqlToolbox.authConfig.authorizeQueryContextParams();
        Access authorizationResult = planner.authorize(authorizer, authorizeContextParams);
        if (!authorizationResult.isAllowed()) {
            throw new ForbiddenException(authorizationResult.toMessage());
        }
        this.cancellationResourceActions = planner.resourceActions(false);
        this.fullResourceActions = planner.resourceActions(authorizeContextParams);
    }

    protected Function<Set<ResourceAction>, Access> authorizer() {
        return resourceActions -> AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)this.queryPlus.authResult(), (Iterable)resourceActions, (AuthorizerMapper)this.sqlToolbox.plannerFactory.getAuthorizerMapper());
    }

    public Set<ResourceAction> resources() {
        return this.cancellationResourceActions;
    }

    public Set<ResourceAction> allResources() {
        return this.fullResourceActions;
    }

    public SqlQueryPlus query() {
        return this.queryPlus;
    }

    public SqlExecutionReporter reporter() {
        return this.reporter;
    }

    @Override
    public void close() {
        try {
            this.closeQuietly();
        }
        catch (Exception e) {
            this.reporter.failed(e);
        }
        this.reporter.emit();
    }

    public void closeQuietly() {
    }

    public void closeWithError(Throwable e) {
        this.reporter.failed(e);
        this.close();
    }
}

