/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.io.CountingOutputStream;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.druid.common.exception.SanitizableException;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.SqlLifecycle;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.SqlLifecycleManager;
import org.apache.druid.sql.SqlPlanningException;
import org.apache.druid.sql.SqlRowTransformer;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlQuery;

@Path(value="/druid/v2/sql/")
public class SqlResource {
    public static final String SQL_QUERY_ID_RESPONSE_HEADER = "X-Druid-SQL-Query-Id";
    public static final String SQL_HEADER_RESPONSE_HEADER = "X-Druid-SQL-Header-Included";
    public static final String SQL_HEADER_VALUE = "yes";
    private static final Logger log = new Logger(SqlResource.class);
    private final ObjectMapper jsonMapper;
    private final AuthorizerMapper authorizerMapper;
    private final SqlLifecycleFactory sqlLifecycleFactory;
    private final SqlLifecycleManager sqlLifecycleManager;
    private final ServerConfig serverConfig;

    @Inject
    public SqlResource(@Json ObjectMapper jsonMapper, AuthorizerMapper authorizerMapper, SqlLifecycleFactory sqlLifecycleFactory, SqlLifecycleManager sqlLifecycleManager, ServerConfig serverConfig) {
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"jsonMapper");
        this.authorizerMapper = (AuthorizerMapper)Preconditions.checkNotNull((Object)authorizerMapper, (Object)"authorizerMapper");
        this.sqlLifecycleFactory = (SqlLifecycleFactory)Preconditions.checkNotNull((Object)sqlLifecycleFactory, (Object)"sqlLifecycleFactory");
        this.sqlLifecycleManager = (SqlLifecycleManager)Preconditions.checkNotNull((Object)sqlLifecycleManager, (Object)"sqlLifecycleManager");
        this.serverConfig = serverConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response doPost(SqlQuery sqlQuery, @Context HttpServletRequest req) throws IOException {
        SqlLifecycle lifecycle = this.sqlLifecycleFactory.factorize();
        String sqlQueryId = lifecycle.initialize(sqlQuery.getQuery(), new QueryContext(sqlQuery.getContext()));
        String remoteAddr = req.getRemoteAddr();
        String currThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(StringUtils.format((String)"sql[%s]", (Object[])new Object[]{sqlQueryId}));
            lifecycle.setParameters(sqlQuery.getParameterList());
            lifecycle.validateAndAuthorize(req);
            this.sqlLifecycleManager.add(sqlQueryId, lifecycle);
            lifecycle.plan();
            SqlRowTransformer rowTransformer = lifecycle.createRowTransformer();
            Sequence<Object[]> sequence = lifecycle.execute();
            Yielder yielder0 = Yielders.each(sequence);
            try {
                Response.ResponseBuilder responseBuilder = Response.ok(outputStream -> {
                    Exception e = null;
                    CountingOutputStream os = new CountingOutputStream(outputStream);
                    Yielder yielder = yielder0;
                    try (ResultFormat.Writer writer = sqlQuery.getResultFormat().createFormatter((OutputStream)os, this.jsonMapper);){
                        writer.writeResponseStart();
                        if (sqlQuery.includeHeader()) {
                            writer.writeHeader(rowTransformer.getRowType(), sqlQuery.includeTypesHeader(), sqlQuery.includeSqlTypesHeader());
                        }
                        while (!yielder.isDone()) {
                            Object[] row = (Object[])yielder.get();
                            writer.writeRowStart();
                            for (int i = 0; i < rowTransformer.getFieldList().size(); ++i) {
                                Object value = rowTransformer.transform(row, i);
                                writer.writeRowField(rowTransformer.getFieldList().get(i), value);
                            }
                            writer.writeRowEnd();
                            yielder = yielder.next(null);
                        }
                        writer.writeResponseEnd();
                    }
                    catch (Exception ex) {
                        e = ex;
                        log.error((Throwable)ex, "Unable to send SQL response [%s]", new Object[]{sqlQueryId});
                        throw new RuntimeException(ex);
                    }
                    finally {
                        yielder.close();
                        this.endLifecycle(sqlQueryId, lifecycle, e, remoteAddr, os.getCount());
                    }
                }).header(SQL_QUERY_ID_RESPONSE_HEADER, (Object)sqlQueryId);
                if (sqlQuery.includeHeader()) {
                    responseBuilder.header(SQL_HEADER_RESPONSE_HEADER, (Object)SQL_HEADER_VALUE);
                }
                Response response = responseBuilder.build();
                return response;
            }
            catch (Throwable e) {
                try {
                    yielder0.close();
                    throw new RuntimeException(e);
                }
                catch (QueryCapacityExceededException cap) {
                    this.endLifecycle(sqlQueryId, lifecycle, cap, remoteAddr, -1L);
                    sequence = this.buildNonOkResponse(429, (SanitizableException)cap, sqlQueryId);
                    return sequence;
                }
                catch (QueryUnsupportedException unsupported) {
                    this.endLifecycle(sqlQueryId, lifecycle, unsupported, remoteAddr, -1L);
                    sequence = this.buildNonOkResponse(501, (SanitizableException)unsupported, sqlQueryId);
                    return sequence;
                }
                catch (QueryTimeoutException timeout) {
                    this.endLifecycle(sqlQueryId, lifecycle, timeout, remoteAddr, -1L);
                    sequence = this.buildNonOkResponse(504, (SanitizableException)timeout, sqlQueryId);
                    return sequence;
                }
                catch (ResourceLimitExceededException | SqlPlanningException e2) {
                    this.endLifecycle(sqlQueryId, lifecycle, (Throwable)e2, remoteAddr, -1L);
                    sequence = this.buildNonOkResponse(400, (SanitizableException)e2, sqlQueryId);
                    return sequence;
                }
                catch (ForbiddenException e3) {
                    this.endLifecycleWithoutEmittingMetrics(sqlQueryId, lifecycle);
                    throw (ForbiddenException)((Object)this.serverConfig.getErrorResponseTransformStrategy().transformIfNeeded((SanitizableException)e3));
                }
                catch (RelOptPlanner.CannotPlanException e4) {
                    this.endLifecycle(sqlQueryId, lifecycle, e4, remoteAddr, -1L);
                    SqlPlanningException spe = new SqlPlanningException(SqlPlanningException.PlanningError.UNSUPPORTED_SQL_ERROR, e4.getMessage());
                    Response response = this.buildNonOkResponse(400, (SanitizableException)spe, sqlQueryId);
                    return response;
                }
                catch (Throwable e5) {
                    log.warn(e5, "Failed to handle query: %s", new Object[]{sqlQuery});
                    this.endLifecycle(sqlQueryId, lifecycle, e5, remoteAddr, -1L);
                    Response response = this.buildNonOkResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (SanitizableException)QueryInterruptedException.wrapIfNeeded((Throwable)e5), sqlQueryId);
                    return response;
                }
            }
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    private void endLifecycleWithoutEmittingMetrics(String sqlQueryId, SqlLifecycle lifecycle) {
        this.sqlLifecycleManager.remove(sqlQueryId, lifecycle);
    }

    private void endLifecycle(String sqlQueryId, SqlLifecycle lifecycle, @Nullable Throwable e, @Nullable String remoteAddress, long bytesWritten) {
        lifecycle.finalizeStateAndEmitLogsAndMetrics(e, remoteAddress, bytesWritten);
        this.sqlLifecycleManager.remove(sqlQueryId, lifecycle);
    }

    private Response buildNonOkResponse(int status, SanitizableException e, String sqlQueryId) throws JsonProcessingException {
        return Response.status((int)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.jsonMapper.writeValueAsBytes((Object)this.serverConfig.getErrorResponseTransformStrategy().transformIfNeeded(e))).header(SQL_QUERY_ID_RESPONSE_HEADER, (Object)sqlQueryId).build();
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="id") String sqlQueryId, @Context HttpServletRequest req) {
        log.debug("Received cancel request for query [%s]", new Object[]{sqlQueryId});
        List<SqlLifecycle> lifecycles = this.sqlLifecycleManager.getAll(sqlQueryId);
        if (lifecycles.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Set resources = lifecycles.stream().flatMap(lifecycle -> lifecycle.getRequiredResourceActions().stream()).collect(Collectors.toSet());
        Access access = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)req, resources, (AuthorizerMapper)this.authorizerMapper);
        if (access.isAllowed()) {
            this.sqlLifecycleManager.removeAll(sqlQueryId, lifecycles);
            lifecycles.forEach(SqlLifecycle::cancel);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

