/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.sql.http.ResultFormat;

public class ObjectWriter
implements ResultFormat.Writer {
    static final String TYPE_HEADER_NAME = "type";
    static final String SQL_TYPE_HEADER_NAME = "sqlType";
    private final JsonGenerator jsonGenerator;
    private final OutputStream outputStream;

    public ObjectWriter(OutputStream outputStream, ObjectMapper jsonMapper) throws IOException {
        this.jsonGenerator = jsonMapper.getFactory().createGenerator(outputStream);
        this.outputStream = outputStream;
        this.jsonGenerator.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
    }

    @Override
    public void writeResponseStart() throws IOException {
        this.jsonGenerator.writeStartArray();
    }

    @Override
    public void writeResponseEnd() throws IOException {
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.flush();
        this.outputStream.write(10);
    }

    @Override
    public void writeHeader(RelDataType rowType, boolean includeTypes, boolean includeSqlTypes) throws IOException {
        ObjectWriter.writeHeader(this.jsonGenerator, rowType, includeTypes, includeSqlTypes);
    }

    @Override
    public void writeRowStart() throws IOException {
        this.jsonGenerator.writeStartObject();
    }

    @Override
    public void writeRowField(String name, @Nullable Object value) throws IOException {
        this.jsonGenerator.writeFieldName(name);
        this.jsonGenerator.writeObject(value);
    }

    @Override
    public void writeRowEnd() throws IOException {
        this.jsonGenerator.writeEndObject();
    }

    @Override
    public void close() throws IOException {
        this.jsonGenerator.close();
    }

    static void writeHeader(JsonGenerator jsonGenerator, RelDataType rowType, boolean includeTypes, boolean includeSqlTypes) throws IOException {
        RowSignature signature = RowSignatures.fromRelDataType(rowType.getFieldNames(), rowType);
        jsonGenerator.writeStartObject();
        for (int i = 0; i < signature.size(); ++i) {
            jsonGenerator.writeFieldName(signature.getColumnName(i));
            if (!includeTypes && !includeSqlTypes) {
                jsonGenerator.writeNull();
                continue;
            }
            jsonGenerator.writeStartObject();
            if (includeTypes) {
                jsonGenerator.writeStringField(TYPE_HEADER_NAME, (String)signature.getColumnType(i).map(TypeSignature::asTypeString).orElse(null));
            }
            if (includeSqlTypes) {
                jsonGenerator.writeStringField(SQL_TYPE_HEADER_NAME, ((RelDataTypeField)rowType.getFieldList().get(i)).getType().getSqlTypeName().getName());
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndObject();
    }
}

