/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.table;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.expression.SimpleExtraction;
import org.apache.druid.sql.calcite.planner.Calcites;

public class RowSignatures {
    private RowSignatures() {
    }

    public static RowSignature fromRelDataType(List<String> rowOrder, RelDataType rowType) {
        if (rowOrder.size() != rowType.getFieldCount()) {
            throw new IAE("Field count %d != %d", new Object[]{rowOrder.size(), rowType.getFieldCount()});
        }
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        for (int i = 0; i < rowOrder.size(); ++i) {
            RelDataType dataType = ((RelDataTypeField)rowType.getFieldList().get(i)).getType();
            ColumnType valueType = Calcites.getColumnTypeForRelDataType(dataType);
            rowSignatureBuilder.add(rowOrder.get(i), valueType);
        }
        return rowSignatureBuilder.build();
    }

    @Nonnull
    public static StringComparator getNaturalStringComparator(RowSignature rowSignature, SimpleExtraction simpleExtraction) {
        Preconditions.checkNotNull((Object)simpleExtraction, (Object)"simpleExtraction");
        if (simpleExtraction.getExtractionFn() != null || rowSignature.getColumnType(simpleExtraction.getColumn()).map(type -> type.is((TypeDescriptor)ValueType.STRING)).orElse(false).booleanValue()) {
            return StringComparators.LEXICOGRAPHIC;
        }
        return StringComparators.NUMERIC;
    }

    public static RelDataType toRelDataType(RowSignature rowSignature, RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        boolean nullNumeric = !NullHandling.replaceWithDefault();
        for (String columnName : rowSignature.getColumnNames()) {
            RelDataType type;
            if ("__time".equals(columnName)) {
                type = Calcites.createSqlType(typeFactory, SqlTypeName.TIMESTAMP);
            } else {
                ColumnType columnType = (ColumnType)rowSignature.getColumnType(columnName).orElseThrow(() -> new ISE("Encountered null type for column[%s]", new Object[]{columnName}));
                block0 : switch ((ValueType)columnType.getType()) {
                    case STRING: {
                        type = Calcites.createSqlTypeWithNullability(typeFactory, SqlTypeName.VARCHAR, true);
                        break;
                    }
                    case LONG: {
                        type = Calcites.createSqlTypeWithNullability(typeFactory, SqlTypeName.BIGINT, nullNumeric);
                        break;
                    }
                    case FLOAT: {
                        type = Calcites.createSqlTypeWithNullability(typeFactory, SqlTypeName.FLOAT, nullNumeric);
                        break;
                    }
                    case DOUBLE: {
                        type = Calcites.createSqlTypeWithNullability(typeFactory, SqlTypeName.DOUBLE, nullNumeric);
                        break;
                    }
                    case ARRAY: {
                        switch ((ValueType)columnType.getElementType().getType()) {
                            case STRING: {
                                type = Calcites.createSqlArrayTypeWithNullability(typeFactory, SqlTypeName.VARCHAR, true);
                                break block0;
                            }
                            case LONG: {
                                type = Calcites.createSqlArrayTypeWithNullability(typeFactory, SqlTypeName.BIGINT, nullNumeric);
                                break block0;
                            }
                            case DOUBLE: {
                                type = Calcites.createSqlArrayTypeWithNullability(typeFactory, SqlTypeName.DOUBLE, nullNumeric);
                                break block0;
                            }
                        }
                        throw new ISE("valueType[%s] not translatable", new Object[]{columnType});
                    }
                    case COMPLEX: {
                        type = typeFactory.createTypeWithNullability((RelDataType)new ComplexSqlType(SqlTypeName.OTHER, columnType, true), true);
                        break;
                    }
                    default: {
                        throw new ISE("valueType[%s] not translatable", new Object[]{columnType});
                    }
                }
            }
            builder.add(columnName, type);
        }
        return builder.build();
    }

    public static final class ComplexSqlType
    extends AbstractSqlType {
        private final ColumnType columnType;

        public ComplexSqlType(SqlTypeName typeName, ColumnType columnType, boolean isNullable) {
            super(typeName, isNullable, null);
            this.columnType = columnType;
            this.computeDigest();
        }

        public RelDataTypeComparability getComparability() {
            return RelDataTypeComparability.UNORDERED;
        }

        protected void generateTypeString(StringBuilder sb, boolean withDetail) {
            sb.append(this.columnType.asTypeString());
        }

        public String getComplexTypeName() {
            return this.columnType.getComplexTypeName();
        }

        public String asTypeString() {
            return this.columnType.asTypeString();
        }
    }
}

