/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.druid.query.DataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.external.ExternalDataSource;
import org.apache.druid.sql.calcite.external.ExternalTableScan;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class DruidTable
implements TranslatableTable {
    private final DataSource dataSource;
    private final RowSignature rowSignature;
    @Nullable
    private final ObjectMapper objectMapper;
    private final boolean joinable;
    private final boolean broadcast;

    public DruidTable(DataSource dataSource, RowSignature rowSignature, @Nullable ObjectMapper objectMapper, boolean isJoinable, boolean isBroadcast) {
        this.dataSource = (DataSource)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.rowSignature = (RowSignature)Preconditions.checkNotNull((Object)rowSignature, (Object)"rowSignature");
        this.objectMapper = objectMapper;
        this.joinable = isJoinable;
        this.broadcast = isBroadcast;
        if (dataSource instanceof ExternalDataSource && objectMapper == null) {
            throw new NullPointerException("ObjectMapper is required for external datasources");
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public RowSignature getRowSignature() {
        return this.rowSignature;
    }

    public boolean isJoinable() {
        return this.joinable;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TABLE;
    }

    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return RowSignatures.toRelDataType(this.rowSignature, typeFactory);
    }

    public boolean isRolledUp(String column) {
        return false;
    }

    public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
        return true;
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable table) {
        if (this.dataSource instanceof ExternalDataSource) {
            return new ExternalTableScan(context.getCluster(), this.objectMapper, this);
        }
        return LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)table);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidTable that = (DruidTable)o;
        if (!Objects.equals(this.dataSource, that.dataSource)) {
            return false;
        }
        return Objects.equals(this.rowSignature, that.rowSignature);
    }

    public int hashCode() {
        int result = this.dataSource != null ? this.dataSource.hashCode() : 0;
        result = 31 * result + (this.rowSignature != null ? this.rowSignature.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DruidTable{dataSource=" + this.dataSource + ", rowSignature=" + this.rowSignature + '}';
    }
}

