/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Futures;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.DefaultEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.FilteredServerInventoryView;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.JsonParserIterator;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStatus;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamFullResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamFullResponseHolder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.schema.AvailableSegmentMetadata;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.MetadataSegmentView;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentWithOvershadowedStatus;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class SystemSchema
extends AbstractSchema {
    private static final String SEGMENTS_TABLE = "segments";
    private static final String SERVERS_TABLE = "servers";
    private static final String SERVER_SEGMENTS_TABLE = "server_segments";
    private static final String TASKS_TABLE = "tasks";
    private static final String SUPERVISOR_TABLE = "supervisors";
    private static final Function<SegmentWithOvershadowedStatus, Iterable<ResourceAction>> SEGMENT_WITH_OVERSHADOWED_STATUS_RA_GENERATOR = segment -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getDataSegment().getDataSource()));
    private static final Function<DataSegment, Iterable<ResourceAction>> SEGMENT_RA_GENERATOR = segment -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getDataSource()));
    private static final long IS_PUBLISHED_FALSE = 0L;
    private static final long IS_PUBLISHED_TRUE = 1L;
    private static final long IS_AVAILABLE_TRUE = 1L;
    private static final long IS_OVERSHADOWED_FALSE = 0L;
    private static final long IS_OVERSHADOWED_TRUE = 1L;
    static final RowSignature SEGMENTS_SIGNATURE = RowSignature.builder().add("segment_id", ColumnType.STRING).add("datasource", ColumnType.STRING).add("start", ColumnType.STRING).add("end", ColumnType.STRING).add("size", ColumnType.LONG).add("version", ColumnType.STRING).add("partition_num", ColumnType.LONG).add("num_replicas", ColumnType.LONG).add("num_rows", ColumnType.LONG).add("is_published", ColumnType.LONG).add("is_available", ColumnType.LONG).add("is_realtime", ColumnType.LONG).add("is_overshadowed", ColumnType.LONG).add("shard_spec", ColumnType.STRING).add("dimensions", ColumnType.STRING).add("metrics", ColumnType.STRING).add("last_compaction_state", ColumnType.STRING).build();
    static final RowSignature SERVERS_SIGNATURE = RowSignature.builder().add("server", ColumnType.STRING).add("host", ColumnType.STRING).add("plaintext_port", ColumnType.LONG).add("tls_port", ColumnType.LONG).add("server_type", ColumnType.STRING).add("tier", ColumnType.STRING).add("curr_size", ColumnType.LONG).add("max_size", ColumnType.LONG).add("is_leader", ColumnType.LONG).build();
    static final RowSignature SERVER_SEGMENTS_SIGNATURE = RowSignature.builder().add("server", ColumnType.STRING).add("segment_id", ColumnType.STRING).build();
    static final RowSignature TASKS_SIGNATURE = RowSignature.builder().add("task_id", ColumnType.STRING).add("group_id", ColumnType.STRING).add("type", ColumnType.STRING).add("datasource", ColumnType.STRING).add("created_time", ColumnType.STRING).add("queue_insertion_time", ColumnType.STRING).add("status", ColumnType.STRING).add("runner_status", ColumnType.STRING).add("duration", ColumnType.LONG).add("location", ColumnType.STRING).add("host", ColumnType.STRING).add("plaintext_port", ColumnType.LONG).add("tls_port", ColumnType.LONG).add("error_msg", ColumnType.STRING).build();
    static final RowSignature SUPERVISOR_SIGNATURE = RowSignature.builder().add("supervisor_id", ColumnType.STRING).add("state", ColumnType.STRING).add("detailed_state", ColumnType.STRING).add("healthy", ColumnType.LONG).add("type", ColumnType.STRING).add("source", ColumnType.STRING).add("suspended", ColumnType.LONG).add("spec", ColumnType.STRING).build();
    private final Map<String, Table> tableMap;

    @Inject
    public SystemSchema(DruidSchema druidSchema, MetadataSegmentView metadataView, TimelineServerView serverView, FilteredServerInventoryView serverInventoryView, AuthorizerMapper authorizerMapper, @Coordinator DruidLeaderClient coordinatorDruidLeaderClient, @IndexingService DruidLeaderClient overlordDruidLeaderClient, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, ObjectMapper jsonMapper) {
        Preconditions.checkNotNull((Object)serverView, (Object)"serverView");
        this.tableMap = ImmutableMap.of((Object)SEGMENTS_TABLE, (Object)((Object)new SegmentsTable(druidSchema, metadataView, jsonMapper, authorizerMapper)), (Object)SERVERS_TABLE, (Object)((Object)new ServersTable(druidNodeDiscoveryProvider, serverInventoryView, authorizerMapper, overlordDruidLeaderClient, coordinatorDruidLeaderClient)), (Object)SERVER_SEGMENTS_TABLE, (Object)((Object)new ServerSegmentsTable(serverView, authorizerMapper)), (Object)TASKS_TABLE, (Object)((Object)new TasksTable(overlordDruidLeaderClient, jsonMapper, authorizerMapper)), (Object)SUPERVISOR_TABLE, (Object)((Object)new SupervisorsTable(overlordDruidLeaderClient, jsonMapper, authorizerMapper)));
    }

    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    private static JsonParserIterator<TaskStatusPlus> getTasks(DruidLeaderClient indexingServiceClient, ObjectMapper jsonMapper) {
        return SystemSchema.getThingsFromLeaderNode("/druid/indexer/v1/tasks", new TypeReference<TaskStatusPlus>(){}, indexingServiceClient, jsonMapper);
    }

    private static JsonParserIterator<SupervisorStatus> getSupervisors(DruidLeaderClient indexingServiceClient, ObjectMapper jsonMapper) {
        return SystemSchema.getThingsFromLeaderNode("/druid/indexer/v1/supervisor?system", new TypeReference<SupervisorStatus>(){}, indexingServiceClient, jsonMapper);
    }

    public static <T> JsonParserIterator<T> getThingsFromLeaderNode(String query, TypeReference<T> typeRef, DruidLeaderClient leaderClient, ObjectMapper jsonMapper) {
        InputStreamFullResponseHolder responseHolder;
        Request request;
        try {
            request = leaderClient.makeRequest(HttpMethod.GET, query);
            responseHolder = (InputStreamFullResponseHolder)leaderClient.go(request, (HttpResponseHandler)new InputStreamFullResponseHandler());
            if (responseHolder.getStatus().getCode() != 200) {
                throw new RE("Failed to talk to leader node at [%s]. Error code[%d], description[%s].", new Object[]{query, responseHolder.getStatus().getCode(), responseHolder.getStatus().getReasonPhrase()});
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        JavaType javaType = jsonMapper.getTypeFactory().constructType(typeRef);
        return new JsonParserIterator(javaType, (Future)Futures.immediateFuture((Object)responseHolder.getContent()), request.getUrl().toString(), null, request.getUrl().getHost(), jsonMapper);
    }

    private static <T> CloseableIterator<T> wrap(final Iterator<T> iterator, final JsonParserIterator<T> it) {
        return new CloseableIterator<T>(){

            public boolean hasNext() {
                boolean hasNext = iterator.hasNext();
                if (!hasNext) {
                    try {
                        it.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return hasNext;
            }

            public T next() {
                return iterator.next();
            }

            public void close() throws IOException {
                it.close();
            }
        };
    }

    @Nullable
    private static String toStringOrNull(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    private static void checkStateReadAccessForServers(AuthenticationResult authenticationResult, AuthorizerMapper authorizerMapper) {
        Access stateAccess = AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)authenticationResult, Collections.singletonList(new ResourceAction(Resource.STATE_RESOURCE, Action.READ)), (AuthorizerMapper)authorizerMapper);
        if (!stateAccess.isAllowed()) {
            throw new ForbiddenException("Insufficient permission to view servers : " + stateAccess);
        }
    }

    static class SupervisorsTable
    extends AbstractTable
    implements ScannableTable {
        private final DruidLeaderClient druidLeaderClient;
        private final ObjectMapper jsonMapper;
        private final AuthorizerMapper authorizerMapper;

        public SupervisorsTable(DruidLeaderClient druidLeaderClient, ObjectMapper jsonMapper, AuthorizerMapper authorizerMapper) {
            this.druidLeaderClient = druidLeaderClient;
            this.jsonMapper = jsonMapper;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return RowSignatures.toRelDataType(SUPERVISOR_SIGNATURE, typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(final DataContext root) {
            class SupervisorsEnumerable
            extends DefaultEnumerable<Object[]> {
                private final CloseableIterator<SupervisorStatus> it;

                public SupervisorsEnumerable(JsonParserIterator<SupervisorStatus> tasks) {
                    this.it = ((SupervisorsTable)this$0).getAuthorizedSupervisors((JsonParserIterator<SupervisorStatus>)tasks, root);
                }

                public Iterator<Object[]> iterator() {
                    throw new UnsupportedOperationException("Do not use iterator(), it cannot be closed.");
                }

                public Enumerator<Object[]> enumerator() {
                    return new Enumerator<Object[]>(){

                        public Object[] current() {
                            SupervisorStatus supervisor = (SupervisorStatus)it.next();
                            return new Object[]{supervisor.getId(), supervisor.getState(), supervisor.getDetailedState(), supervisor.isHealthy() ? 1L : 0L, supervisor.getType(), supervisor.getSource(), supervisor.isSuspended() ? 1L : 0L, supervisor.getSpecString()};
                        }

                        public boolean moveNext() {
                            return it.hasNext();
                        }

                        public void reset() {
                        }

                        public void close() {
                            try {
                                it.close();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
            }
            return new SupervisorsEnumerable(SystemSchema.getSupervisors(this.druidLeaderClient, this.jsonMapper));
        }

        private CloseableIterator<SupervisorStatus> getAuthorizedSupervisors(JsonParserIterator<SupervisorStatus> it, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)root.get("authenticationResult"), (Object)"authenticationResult in dataContext");
            Function raGenerator = supervisor -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)supervisor.getSource()));
            Iterable authorizedSupervisors = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> it, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper);
            return SystemSchema.wrap(authorizedSupervisors.iterator(), it);
        }
    }

    static class TasksTable
    extends AbstractTable
    implements ScannableTable {
        private final DruidLeaderClient druidLeaderClient;
        private final ObjectMapper jsonMapper;
        private final AuthorizerMapper authorizerMapper;

        public TasksTable(DruidLeaderClient druidLeaderClient, ObjectMapper jsonMapper, AuthorizerMapper authorizerMapper) {
            this.druidLeaderClient = druidLeaderClient;
            this.jsonMapper = jsonMapper;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return RowSignatures.toRelDataType(TASKS_SIGNATURE, typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(final DataContext root) {
            class TasksEnumerable
            extends DefaultEnumerable<Object[]> {
                private final CloseableIterator<TaskStatusPlus> it;

                public TasksEnumerable(JsonParserIterator<TaskStatusPlus> tasks) {
                    this.it = ((TasksTable)this$0).getAuthorizedTasks((JsonParserIterator<TaskStatusPlus>)tasks, root);
                }

                public Iterator<Object[]> iterator() {
                    throw new UnsupportedOperationException("Do not use iterator(), it cannot be closed.");
                }

                public Enumerator<Object[]> enumerator() {
                    return new Enumerator<Object[]>(){

                        public Object[] current() {
                            String hostAndPort;
                            TaskStatusPlus task = (TaskStatusPlus)it.next();
                            String host = task.getLocation().getHost();
                            if (host == null) {
                                hostAndPort = null;
                            } else {
                                int port = task.getLocation().getTlsPort() >= 0 ? task.getLocation().getTlsPort() : task.getLocation().getPort();
                                hostAndPort = HostAndPort.fromParts((String)host, (int)port).toString();
                            }
                            return new Object[]{task.getId(), task.getGroupId(), task.getType(), task.getDataSource(), SystemSchema.toStringOrNull(task.getCreatedTime()), SystemSchema.toStringOrNull(task.getQueueInsertionTime()), SystemSchema.toStringOrNull(task.getStatusCode()), SystemSchema.toStringOrNull(task.getRunnerStatusCode()), task.getDuration() == null ? 0L : task.getDuration(), hostAndPort, host, (long)task.getLocation().getPort(), (long)task.getLocation().getTlsPort(), task.getErrorMsg()};
                        }

                        public boolean moveNext() {
                            return it.hasNext();
                        }

                        public void reset() {
                        }

                        public void close() {
                            try {
                                it.close();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
            }
            return new TasksEnumerable(SystemSchema.getTasks(this.druidLeaderClient, this.jsonMapper));
        }

        private CloseableIterator<TaskStatusPlus> getAuthorizedTasks(JsonParserIterator<TaskStatusPlus> it, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)root.get("authenticationResult"), (Object)"authenticationResult in dataContext");
            Function raGenerator = task -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)task.getDataSource()));
            Iterable authorizedTasks = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> it, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper);
            return SystemSchema.wrap(authorizedTasks.iterator(), it);
        }
    }

    static class ServerSegmentsTable
    extends AbstractTable
    implements ScannableTable {
        private final TimelineServerView serverView;
        final AuthorizerMapper authorizerMapper;

        public ServerSegmentsTable(TimelineServerView serverView, AuthorizerMapper authorizerMapper) {
            this.serverView = serverView;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return RowSignatures.toRelDataType(SERVER_SEGMENTS_SIGNATURE, typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)root.get("authenticationResult"), (Object)"authenticationResult in dataContext");
            SystemSchema.checkStateReadAccessForServers(authenticationResult, this.authorizerMapper);
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            List druidServers = this.serverView.getDruidServers();
            int serverSegmentsTableSize = SERVER_SEGMENTS_SIGNATURE.size();
            for (ImmutableDruidServer druidServer : druidServers) {
                Iterable authorizedServerSegments = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, (Iterable)druidServer.iterateAllSegments(), (Function)SEGMENT_RA_GENERATOR, (AuthorizerMapper)this.authorizerMapper);
                for (DataSegment segment : authorizedServerSegments) {
                    Object[] row = new Object[serverSegmentsTableSize];
                    row[0] = druidServer.getHost();
                    row[1] = segment.getId();
                    rows.add(row);
                }
            }
            return Linq4j.asEnumerable(rows);
        }
    }

    static class ServersTable
    extends AbstractTable
    implements ScannableTable {
        private static final long UNKNOWN_SIZE = 0L;
        private final AuthorizerMapper authorizerMapper;
        private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
        private final FilteredServerInventoryView serverInventoryView;
        private final DruidLeaderClient overlordLeaderClient;
        private final DruidLeaderClient coordinatorLeaderClient;

        public ServersTable(DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, FilteredServerInventoryView serverInventoryView, AuthorizerMapper authorizerMapper, DruidLeaderClient overlordLeaderClient, DruidLeaderClient coordinatorLeaderClient) {
            this.authorizerMapper = authorizerMapper;
            this.druidNodeDiscoveryProvider = druidNodeDiscoveryProvider;
            this.serverInventoryView = serverInventoryView;
            this.overlordLeaderClient = overlordLeaderClient;
            this.coordinatorLeaderClient = coordinatorLeaderClient;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return RowSignatures.toRelDataType(SERVERS_SIGNATURE, typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            Iterator<DiscoveryDruidNode> druidServers = ServersTable.getDruidServers(this.druidNodeDiscoveryProvider);
            AuthenticationResult authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)root.get("authenticationResult"), (Object)"authenticationResult in dataContext");
            SystemSchema.checkStateReadAccessForServers(authenticationResult, this.authorizerMapper);
            String tmpCoordinatorLeader = "";
            String tmpOverlordLeader = "";
            try {
                tmpCoordinatorLeader = this.coordinatorLeaderClient.findCurrentLeader();
                tmpOverlordLeader = this.overlordLeaderClient.findCurrentLeader();
            }
            catch (ISE iSE) {
                // empty catch block
            }
            String coordinatorLeader = tmpCoordinatorLeader;
            String overlordLeader = tmpOverlordLeader;
            FluentIterable results = FluentIterable.from(() -> druidServers).transform(discoveryDruidNode -> {
                boolean isDiscoverableDataServer = ServersTable.isDiscoverableDataServer(discoveryDruidNode);
                NodeRole serverRole = discoveryDruidNode.getNodeRole();
                if (isDiscoverableDataServer) {
                    DruidServer druidServer = this.serverInventoryView.getInventoryValue(discoveryDruidNode.getDruidNode().getHostAndPortToUse());
                    if (druidServer != null || NodeRole.HISTORICAL.equals((Object)serverRole)) {
                        return ServersTable.buildRowForDiscoverableDataServer(discoveryDruidNode, druidServer);
                    }
                    return ServersTable.buildRowForNonDataServer(discoveryDruidNode);
                }
                if (NodeRole.COORDINATOR.equals((Object)serverRole)) {
                    return ServersTable.buildRowForNonDataServerWithLeadership(discoveryDruidNode, coordinatorLeader.contains(discoveryDruidNode.getDruidNode().getHostAndPortToUse()));
                }
                if (NodeRole.OVERLORD.equals((Object)serverRole)) {
                    return ServersTable.buildRowForNonDataServerWithLeadership(discoveryDruidNode, overlordLeader.contains(discoveryDruidNode.getDruidNode().getHostAndPortToUse()));
                }
                return ServersTable.buildRowForNonDataServer(discoveryDruidNode);
            });
            return Linq4j.asEnumerable((Iterable)results);
        }

        private static Object[] buildRowForNonDataServer(DiscoveryDruidNode discoveryDruidNode) {
            DruidNode node = discoveryDruidNode.getDruidNode();
            return new Object[]{node.getHostAndPortToUse(), node.getHost(), (long)node.getPlaintextPort(), (long)node.getTlsPort(), StringUtils.toLowerCase((String)discoveryDruidNode.getNodeRole().toString()), null, 0L, 0L, NullHandling.defaultLongValue()};
        }

        private static Object[] buildRowForNonDataServerWithLeadership(DiscoveryDruidNode discoveryDruidNode, boolean isLeader) {
            DruidNode node = discoveryDruidNode.getDruidNode();
            return new Object[]{node.getHostAndPortToUse(), node.getHost(), (long)node.getPlaintextPort(), (long)node.getTlsPort(), StringUtils.toLowerCase((String)discoveryDruidNode.getNodeRole().toString()), null, 0L, 0L, isLeader ? 1L : 0L};
        }

        private static Object[] buildRowForDiscoverableDataServer(DiscoveryDruidNode discoveryDruidNode, @Nullable DruidServer serverFromInventoryView) {
            DruidNode node = discoveryDruidNode.getDruidNode();
            DruidServer druidServerToUse = serverFromInventoryView == null ? ServersTable.toDruidServer(discoveryDruidNode) : serverFromInventoryView;
            long currentSize = serverFromInventoryView == null ? 0L : serverFromInventoryView.getCurrSize();
            return new Object[]{node.getHostAndPortToUse(), node.getHost(), (long)node.getPlaintextPort(), (long)node.getTlsPort(), StringUtils.toLowerCase((String)discoveryDruidNode.getNodeRole().toString()), druidServerToUse.getTier(), currentSize, druidServerToUse.getMaxSize(), NullHandling.defaultLongValue()};
        }

        private static boolean isDiscoverableDataServer(DiscoveryDruidNode druidNode) {
            DruidService druidService = (DruidService)druidNode.getServices().get("dataNodeService");
            if (druidService == null) {
                return false;
            }
            DataNodeService dataNodeService = (DataNodeService)druidService;
            return dataNodeService.isDiscoverable();
        }

        private static DruidServer toDruidServer(DiscoveryDruidNode discoveryDruidNode) {
            if (ServersTable.isDiscoverableDataServer(discoveryDruidNode)) {
                DruidNode druidNode = discoveryDruidNode.getDruidNode();
                DataNodeService dataNodeService = (DataNodeService)discoveryDruidNode.getServices().get("dataNodeService");
                return new DruidServer(druidNode.getHostAndPortToUse(), druidNode.getHostAndPort(), druidNode.getHostAndTlsPort(), dataNodeService.getMaxSize(), dataNodeService.getServerType(), dataNodeService.getTier(), dataNodeService.getPriority());
            }
            throw new ISE("[%s] is not a discoverable data server", new Object[]{discoveryDruidNode});
        }

        private static Iterator<DiscoveryDruidNode> getDruidServers(DruidNodeDiscoveryProvider druidNodeDiscoveryProvider) {
            return Arrays.stream(NodeRole.values()).flatMap(nodeRole -> druidNodeDiscoveryProvider.getForNodeRole(nodeRole).getAllNodes().stream()).collect(Collectors.toList()).iterator();
        }
    }

    static class SegmentsTable
    extends AbstractTable
    implements ScannableTable {
        private final DruidSchema druidSchema;
        private final ObjectMapper jsonMapper;
        private final AuthorizerMapper authorizerMapper;
        private final MetadataSegmentView metadataView;

        public SegmentsTable(DruidSchema druidSchemna, MetadataSegmentView metadataView, ObjectMapper jsonMapper, AuthorizerMapper authorizerMapper) {
            this.druidSchema = druidSchemna;
            this.metadataView = metadataView;
            this.jsonMapper = jsonMapper;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return RowSignatures.toRelDataType(SEGMENTS_SIGNATURE, typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            Map<SegmentId, AvailableSegmentMetadata> availableSegmentMetadata = this.druidSchema.getSegmentMetadataSnapshot();
            Iterator<Map.Entry<SegmentId, AvailableSegmentMetadata>> availableSegmentEntries = availableSegmentMetadata.entrySet().iterator();
            HashMap partialSegmentDataMap = Maps.newHashMapWithExpectedSize((int)this.druidSchema.getTotalSegments());
            for (AvailableSegmentMetadata h : availableSegmentMetadata.values()) {
                PartialSegmentData partialSegmentData = new PartialSegmentData(1L, h.isRealtime(), h.getNumReplicas(), h.getNumRows());
                partialSegmentDataMap.put(h.getSegment().getId(), partialSegmentData);
            }
            Iterator<SegmentWithOvershadowedStatus> metadataStoreSegments = this.metadataView.getPublishedSegments();
            HashSet segmentsAlreadySeen = Sets.newHashSetWithExpectedSize((int)this.druidSchema.getTotalSegments());
            FluentIterable publishedSegments = FluentIterable.from(() -> this.getAuthorizedPublishedSegments(metadataStoreSegments, root)).transform(val -> {
                DataSegment segment = val.getDataSegment();
                segmentsAlreadySeen.add(segment.getId());
                PartialSegmentData partialSegmentData = (PartialSegmentData)partialSegmentDataMap.get(segment.getId());
                long numReplicas = 0L;
                long numRows = 0L;
                long isRealtime = 0L;
                long isAvailable = 0L;
                if (partialSegmentData != null) {
                    numReplicas = partialSegmentData.getNumReplicas();
                    numRows = partialSegmentData.getNumRows();
                    isAvailable = partialSegmentData.isAvailable();
                    isRealtime = partialSegmentData.isRealtime();
                }
                try {
                    return new Object[]{segment.getId(), segment.getDataSource(), segment.getInterval().getStart().toString(), segment.getInterval().getEnd().toString(), segment.getSize(), segment.getVersion(), (long)segment.getShardSpec().getPartitionNum(), numReplicas, numRows, 1L, isAvailable, isRealtime, val.isOvershadowed() ? 1L : 0L, segment.getShardSpec() == null ? null : this.jsonMapper.writeValueAsString((Object)segment.getShardSpec()), segment.getDimensions() == null ? null : this.jsonMapper.writeValueAsString((Object)segment.getDimensions()), segment.getMetrics() == null ? null : this.jsonMapper.writeValueAsString((Object)segment.getMetrics()), segment.getLastCompactionState() == null ? null : this.jsonMapper.writeValueAsString((Object)segment.getLastCompactionState())};
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            });
            FluentIterable availableSegments = FluentIterable.from(() -> this.getAuthorizedAvailableSegments(availableSegmentEntries, root)).transform(val -> {
                if (segmentsAlreadySeen.contains(val.getKey())) {
                    return null;
                }
                PartialSegmentData partialSegmentData = (PartialSegmentData)partialSegmentDataMap.get(val.getKey());
                long numReplicas = partialSegmentData == null ? 0L : partialSegmentData.getNumReplicas();
                try {
                    return new Object[]{val.getKey(), ((SegmentId)val.getKey()).getDataSource(), ((SegmentId)val.getKey()).getInterval().getStart().toString(), ((SegmentId)val.getKey()).getInterval().getEnd().toString(), ((AvailableSegmentMetadata)val.getValue()).getSegment().getSize(), ((SegmentId)val.getKey()).getVersion(), (long)((AvailableSegmentMetadata)val.getValue()).getSegment().getShardSpec().getPartitionNum(), numReplicas, ((AvailableSegmentMetadata)val.getValue()).getNumRows(), 0L, 1L, ((AvailableSegmentMetadata)val.getValue()).isRealtime(), 0L, ((AvailableSegmentMetadata)val.getValue()).getSegment().getShardSpec() == null ? null : this.jsonMapper.writeValueAsString((Object)((AvailableSegmentMetadata)val.getValue()).getSegment().getShardSpec()), ((AvailableSegmentMetadata)val.getValue()).getSegment().getDimensions() == null ? null : this.jsonMapper.writeValueAsString((Object)((AvailableSegmentMetadata)val.getValue()).getSegment().getDimensions()), ((AvailableSegmentMetadata)val.getValue()).getSegment().getMetrics() == null ? null : this.jsonMapper.writeValueAsString((Object)((AvailableSegmentMetadata)val.getValue()).getSegment().getMetrics()), null};
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            });
            Iterable allSegments = Iterables.unmodifiableIterable((Iterable)Iterables.concat((Iterable)publishedSegments, (Iterable)availableSegments));
            return Linq4j.asEnumerable((Iterable)allSegments).where(Objects::nonNull);
        }

        private Iterator<SegmentWithOvershadowedStatus> getAuthorizedPublishedSegments(Iterator<SegmentWithOvershadowedStatus> it, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)root.get("authenticationResult"), (Object)"authenticationResult in dataContext");
            Iterable authorizedSegments = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> it, (Function)SEGMENT_WITH_OVERSHADOWED_STATUS_RA_GENERATOR, (AuthorizerMapper)this.authorizerMapper);
            return authorizedSegments.iterator();
        }

        private Iterator<Map.Entry<SegmentId, AvailableSegmentMetadata>> getAuthorizedAvailableSegments(Iterator<Map.Entry<SegmentId, AvailableSegmentMetadata>> availableSegmentEntries, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)root.get("authenticationResult"), (Object)"authenticationResult in dataContext");
            Function raGenerator = segment -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)((SegmentId)segment.getKey()).getDataSource()));
            Iterable authorizedSegments = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> availableSegmentEntries, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper);
            return authorizedSegments.iterator();
        }

        private static class PartialSegmentData {
            private final long isAvailable;
            private final long isRealtime;
            private final long numReplicas;
            private final long numRows;

            public PartialSegmentData(long isAvailable, long isRealtime, long numReplicas, long numRows) {
                this.isAvailable = isAvailable;
                this.isRealtime = isRealtime;
                this.numReplicas = numReplicas;
                this.numRows = numRows;
            }

            public long isAvailable() {
                return this.isAvailable;
            }

            public long isRealtime() {
                return this.isRealtime;
            }

            public long getNumReplicas() {
                return this.numReplicas;
            }

            public long getNumRows() {
                return this.numRows;
            }
        }
    }
}

