/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.table.DruidTable;

public class LookupSchema
extends AbstractSchema {
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("k", ColumnType.STRING).add("v", ColumnType.STRING).build();
    private final LookupExtractorFactoryContainerProvider lookupProvider;

    @Inject
    public LookupSchema(LookupExtractorFactoryContainerProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
    }

    protected Map<String, Table> getTableMap() {
        ImmutableMap.Builder tableMapBuilder = ImmutableMap.builder();
        for (String lookupName : this.lookupProvider.getAllLookupNames()) {
            tableMapBuilder.put((Object)lookupName, (Object)new DruidTable((DataSource)new LookupDataSource(lookupName), ROW_SIGNATURE, null, true, true));
        }
        return tableMapBuilder.build();
    }
}

