/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.druid.client.BrokerInternalQueryConfig;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.metadata.metadata.AllColumnIncluderator;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.schema.AvailableSegmentMetadata;
import org.apache.druid.sql.calcite.schema.DruidSchemaManager;
import org.apache.druid.sql.calcite.schema.NoopDruidSchemaManager;
import org.apache.druid.sql.calcite.table.DruidTable;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.ReadablePeriod;

@ManageLifecycle
public class DruidSchema
extends AbstractSchema {
    private static final Comparator<SegmentId> SEGMENT_ORDER = Comparator.comparing(segmentId -> segmentId.getInterval().getStart()).reversed().thenComparing(Function.identity());
    private static final EmittingLogger log = new EmittingLogger(DruidSchema.class);
    private static final int MAX_SEGMENTS_PER_QUERY = 15000;
    private static final long DEFAULT_NUM_ROWS = 0L;
    private final QueryLifecycleFactory queryLifecycleFactory;
    private final PlannerConfig config;
    private final Escalator escalator;
    private final SegmentManager segmentManager;
    private final JoinableFactory joinableFactory;
    private final ExecutorService cacheExec;
    private final ExecutorService callbackExec;
    private final DruidSchemaManager druidSchemaManager;
    private final ConcurrentMap<String, DruidTable> tables = new ConcurrentHashMap<String, DruidTable>();
    private static final Interner<RowSignature> ROW_SIGNATURE_INTERNER = Interners.newWeakInterner();
    private final ConcurrentHashMap<String, ConcurrentSkipListMap<SegmentId, AvailableSegmentMetadata>> segmentMetadataInfo = new ConcurrentHashMap();
    private final CountDownLatch initialized = new CountDownLatch(1);
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final TreeSet<SegmentId> mutableSegments = new TreeSet<SegmentId>(SEGMENT_ORDER);
    @GuardedBy(value="lock")
    private final Set<String> dataSourcesNeedingRebuild = new HashSet<String>();
    @GuardedBy(value="lock")
    private final TreeSet<SegmentId> segmentsNeedingRefresh = new TreeSet<SegmentId>(SEGMENT_ORDER);
    private final BrokerInternalQueryConfig brokerInternalQueryConfig;
    @GuardedBy(value="lock")
    private boolean refreshImmediately = false;
    @GuardedBy(value="lock")
    private boolean isServerViewInitialized = false;
    private int totalSegments = 0;

    @Inject
    public DruidSchema(QueryLifecycleFactory queryLifecycleFactory, TimelineServerView serverView, SegmentManager segmentManager, JoinableFactory joinableFactory, PlannerConfig config, Escalator escalator, BrokerInternalQueryConfig brokerInternalQueryConfig, DruidSchemaManager druidSchemaManager) {
        this.queryLifecycleFactory = (QueryLifecycleFactory)Preconditions.checkNotNull((Object)queryLifecycleFactory, (Object)"queryLifecycleFactory");
        Preconditions.checkNotNull((Object)serverView, (Object)"serverView");
        this.segmentManager = segmentManager;
        this.joinableFactory = joinableFactory;
        this.config = (PlannerConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.cacheExec = Execs.singleThreaded((String)"DruidSchema-Cache-%d");
        this.callbackExec = Execs.singleThreaded((String)"DruidSchema-Callback-%d");
        this.escalator = escalator;
        this.brokerInternalQueryConfig = brokerInternalQueryConfig;
        this.druidSchemaManager = druidSchemaManager;
        this.initServerViewTimelineCallback(serverView);
    }

    private void initServerViewTimelineCallback(TimelineServerView serverView) {
        serverView.registerTimelineCallback((Executor)this.callbackExec, new TimelineServerView.TimelineCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ServerView.CallbackAction timelineInitialized() {
                Object object = DruidSchema.this.lock;
                synchronized (object) {
                    DruidSchema.this.isServerViewInitialized = true;
                    DruidSchema.this.lock.notifyAll();
                }
                return ServerView.CallbackAction.CONTINUE;
            }

            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                DruidSchema.this.addSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            public ServerView.CallbackAction segmentRemoved(DataSegment segment) {
                DruidSchema.this.removeSegment(segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            public ServerView.CallbackAction serverSegmentRemoved(DruidServerMetadata server, DataSegment segment) {
                DruidSchema.this.removeServerSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    private void startCacheExec() {
        this.cacheExec.submit(() -> {
            block19: {
                long lastRefresh = 0L;
                long lastFailure = 0L;
                while (true) {
                    try {
                        if (Thread.currentThread().isInterrupted()) break block19;
                        TreeSet<SegmentId> segmentsToRefresh = new TreeSet<SegmentId>();
                        TreeSet<String> dataSourcesToRebuild = new TreeSet<String>();
                        try {
                            Object object = this.lock;
                            synchronized (object) {
                                long nextRefreshNoFuzz = DateTimes.utc((long)lastRefresh).plus((ReadablePeriod)this.config.getMetadataRefreshPeriod()).getMillis();
                                long nextRefresh = nextRefreshNoFuzz + (long)((double)(nextRefreshNoFuzz - lastRefresh) * 0.1);
                                while (true) {
                                    boolean wasRecentFailure = DateTimes.utc((long)lastFailure).plus((ReadablePeriod)this.config.getMetadataRefreshPeriod()).isAfterNow();
                                    if (this.isServerViewInitialized && !wasRecentFailure && (!this.segmentsNeedingRefresh.isEmpty() || !this.dataSourcesNeedingRebuild.isEmpty()) && (this.refreshImmediately || nextRefresh < System.currentTimeMillis())) break;
                                    if (this.isServerViewInitialized && lastFailure == 0L) {
                                        this.initialized.countDown();
                                    }
                                    this.lock.wait(Math.max(1L, nextRefresh - System.currentTimeMillis()));
                                }
                                segmentsToRefresh.addAll(this.segmentsNeedingRefresh);
                                this.segmentsNeedingRefresh.clear();
                                this.segmentsNeedingRefresh.addAll(this.mutableSegments);
                                lastFailure = 0L;
                                lastRefresh = System.currentTimeMillis();
                                this.refreshImmediately = false;
                            }
                            this.refresh(segmentsToRefresh, dataSourcesToRebuild);
                            this.initialized.countDown();
                        }
                        catch (InterruptedException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            log.warn((Throwable)e, "Metadata refresh failed, trying again soon.", new Object[0]);
                            Object object = this.lock;
                            synchronized (object) {
                                this.segmentsNeedingRefresh.addAll(segmentsToRefresh);
                                this.dataSourcesNeedingRebuild.addAll(dataSourcesToRebuild);
                                lastFailure = System.currentTimeMillis();
                            }
                        }
                    }
                    catch (InterruptedException segmentsToRefresh) {
                        break block19;
                    }
                    catch (Throwable e) {
                        log.makeAlert(e, "Metadata refresh failed permanently", new Object[0]).emit();
                        throw e;
                    }
                }
                finally {
                    log.info("Metadata refresh stopped.", new Object[0]);
                }
            }
        });
    }

    @LifecycleStart
    public void start() throws InterruptedException {
        this.startCacheExec();
        if (this.config.isAwaitInitializationOnStart()) {
            long startNanos = System.nanoTime();
            log.debug("%s waiting for initialization.", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
            this.awaitInitialization();
            log.info("%s initialized in [%,d] ms.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), (System.nanoTime() - startNanos) / 1000000L});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void refresh(Set<SegmentId> segmentsToRefresh, Set<String> dataSourcesToRebuild) throws IOException {
        Set<SegmentId> refreshed = this.refreshSegments(segmentsToRefresh);
        Iterator<String> iterator = this.lock;
        synchronized (iterator) {
            this.segmentsNeedingRefresh.addAll((Collection<SegmentId>)Sets.difference(segmentsToRefresh, refreshed));
            dataSourcesToRebuild.addAll(this.dataSourcesNeedingRebuild);
            refreshed.forEach(segment -> dataSourcesToRebuild.add(segment.getDataSource()));
            this.dataSourcesNeedingRebuild.clear();
        }
        for (String dataSource : dataSourcesToRebuild) {
            String description;
            DruidTable druidTable = this.buildDruidTable(dataSource);
            DruidTable oldTable = this.tables.put(dataSource, druidTable);
            String string = description = druidTable.getDataSource().isGlobal() ? "global dataSource" : "dataSource";
            if (oldTable == null || !oldTable.getRowSignature().equals((Object)druidTable.getRowSignature())) {
                log.info("%s [%s] has new signature: %s.", new Object[]{description, dataSource, druidTable.getRowSignature()});
                continue;
            }
            log.debug("%s [%s] signature is unchanged.", new Object[]{description, dataSource});
        }
    }

    @LifecycleStop
    public void stop() {
        this.cacheExec.shutdownNow();
        this.callbackExec.shutdownNow();
    }

    public void awaitInitialization() throws InterruptedException {
        this.initialized.await();
    }

    protected Map<String, Table> getTableMap() {
        if (this.druidSchemaManager != null && !(this.druidSchemaManager instanceof NoopDruidSchemaManager)) {
            return ImmutableMap.copyOf(this.druidSchemaManager.getTables());
        }
        return ImmutableMap.copyOf(this.tables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void addSegment(DruidServerMetadata server, DataSegment segment) {
        Object object = this.lock;
        synchronized (object) {
            if (server.getType().equals((Object)ServerType.BROKER)) {
                this.markDataSourceAsNeedRebuild(segment.getDataSource());
            } else {
                this.segmentMetadataInfo.compute(segment.getDataSource(), (datasource, segmentsMap) -> {
                    if (segmentsMap == null) {
                        segmentsMap = new ConcurrentSkipListMap<SegmentId, AvailableSegmentMetadata>(SEGMENT_ORDER);
                    }
                    segmentsMap.compute(segment.getId(), (segmentId, segmentMetadata) -> {
                        if (segmentMetadata == null) {
                            ++this.totalSegments;
                            long isRealtime = server.isSegmentReplicationTarget() ? 0L : 1L;
                            segmentMetadata = AvailableSegmentMetadata.builder(segment, isRealtime, (Set<DruidServerMetadata>)ImmutableSet.of((Object)server), null, 0L).build();
                            this.markSegmentAsNeedRefresh(segment.getId());
                            if (!server.isSegmentReplicationTarget()) {
                                log.debug("Added new mutable segment[%s].", new Object[]{segment.getId()});
                                this.markSegmentAsMutable(segment.getId());
                            } else {
                                log.debug("Added new immutable segment[%s].", new Object[]{segment.getId()});
                            }
                        } else {
                            Set<DruidServerMetadata> segmentServers = segmentMetadata.getReplicas();
                            ImmutableSet servers = new ImmutableSet.Builder().addAll(segmentServers).add((Object)server).build();
                            segmentMetadata = AvailableSegmentMetadata.from(segmentMetadata).withReplicas((Set<DruidServerMetadata>)servers).withRealtime(this.recomputeIsRealtime((ImmutableSet<DruidServerMetadata>)servers)).build();
                            if (server.isSegmentReplicationTarget()) {
                                this.unmarkSegmentAsMutable(segment.getId());
                                log.debug("Segment[%s] has become immutable.", new Object[]{segment.getId()});
                            }
                        }
                        assert (segmentMetadata != null);
                        return segmentMetadata;
                    });
                    return segmentsMap;
                });
            }
            if (!this.tables.containsKey(segment.getDataSource())) {
                this.refreshImmediately = true;
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void removeSegment(DataSegment segment) {
        Object object = this.lock;
        synchronized (object) {
            log.debug("Segment[%s] is gone.", new Object[]{segment.getId()});
            this.segmentsNeedingRefresh.remove(segment.getId());
            this.unmarkSegmentAsMutable(segment.getId());
            this.segmentMetadataInfo.compute(segment.getDataSource(), (dataSource, segmentsMap) -> {
                if (segmentsMap == null) {
                    log.warn("Unknown segment[%s] was removed from the cluster. Ignoring this event.", new Object[]{segment.getId()});
                    return null;
                }
                if (segmentsMap.remove(segment.getId()) == null) {
                    log.warn("Unknown segment[%s] was removed from the cluster. Ignoring this event.", new Object[]{segment.getId()});
                } else {
                    --this.totalSegments;
                }
                if (segmentsMap.isEmpty()) {
                    this.tables.remove(segment.getDataSource());
                    log.info("dataSource[%s] no longer exists, all metadata removed.", new Object[]{segment.getDataSource()});
                    return null;
                }
                this.markDataSourceAsNeedRebuild(segment.getDataSource());
                return segmentsMap;
            });
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void removeServerSegment(DruidServerMetadata server, DataSegment segment) {
        Object object = this.lock;
        synchronized (object) {
            log.debug("Segment[%s] is gone from server[%s]", new Object[]{segment.getId(), server.getName()});
            this.segmentMetadataInfo.compute(segment.getDataSource(), (datasource, knownSegments) -> {
                if (knownSegments == null) {
                    log.warn("Unknown segment[%s] is removed from server[%s]. Ignoring this event", new Object[]{segment.getId(), server.getHost()});
                    return null;
                }
                if (server.getType().equals((Object)ServerType.BROKER)) {
                    if (!knownSegments.isEmpty()) {
                        this.markDataSourceAsNeedRebuild(segment.getDataSource());
                    }
                } else {
                    knownSegments.compute(segment.getId(), (segmentId, segmentMetadata) -> {
                        if (segmentMetadata == null) {
                            log.warn("Unknown segment[%s] is removed from server[%s]. Ignoring this event", new Object[]{segment.getId(), server.getHost()});
                            return null;
                        }
                        Set<DruidServerMetadata> segmentServers = segmentMetadata.getReplicas();
                        ImmutableSet servers = FluentIterable.from(segmentServers).filter(Predicates.not((Predicate)Predicates.equalTo((Object)server))).toSet();
                        return AvailableSegmentMetadata.from(segmentMetadata).withReplicas((Set<DruidServerMetadata>)servers).withRealtime(this.recomputeIsRealtime((ImmutableSet<DruidServerMetadata>)servers)).build();
                    });
                }
                if (knownSegments.isEmpty()) {
                    return null;
                }
                return knownSegments;
            });
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markSegmentAsNeedRefresh(SegmentId segmentId) {
        Object object = this.lock;
        synchronized (object) {
            this.segmentsNeedingRefresh.add(segmentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markSegmentAsMutable(SegmentId segmentId) {
        Object object = this.lock;
        synchronized (object) {
            this.mutableSegments.add(segmentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmarkSegmentAsMutable(SegmentId segmentId) {
        Object object = this.lock;
        synchronized (object) {
            this.mutableSegments.remove(segmentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void markDataSourceAsNeedRebuild(String datasource) {
        Object object = this.lock;
        synchronized (object) {
            this.dataSourcesNeedingRebuild.add(datasource);
        }
    }

    @VisibleForTesting
    protected Set<SegmentId> refreshSegments(Set<SegmentId> segments) throws IOException {
        HashSet<SegmentId> retVal = new HashSet<SegmentId>();
        TreeMap<String, TreeSet> segmentMap = new TreeMap<String, TreeSet>();
        for (SegmentId segmentId : segments) {
            segmentMap.computeIfAbsent(segmentId.getDataSource(), x -> new TreeSet<SegmentId>(SEGMENT_ORDER)).add(segmentId);
        }
        for (Map.Entry entry : segmentMap.entrySet()) {
            String dataSource = (String)entry.getKey();
            retVal.addAll(this.refreshSegmentsForDataSource(dataSource, (Set)entry.getValue()));
        }
        return retVal;
    }

    private long recomputeIsRealtime(ImmutableSet<DruidServerMetadata> servers) {
        if (servers.isEmpty()) {
            return 0L;
        }
        Optional<DruidServerMetadata> historicalServer = servers.stream().filter(metadata -> metadata.getType().equals((Object)ServerType.HISTORICAL)).findAny();
        return historicalServer.isPresent() ? 0L : 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<SegmentId> refreshSegmentsForDataSource(String dataSource, Set<SegmentId> segments) throws IOException {
        if (!segments.stream().allMatch(segmentId -> segmentId.getDataSource().equals(dataSource))) {
            throw new ISE("'segments' must all match 'dataSource'!", new Object[0]);
        }
        log.debug("Refreshing metadata for dataSource[%s].", new Object[]{dataSource});
        long startTime = System.currentTimeMillis();
        ImmutableMap segmentIdMap = Maps.uniqueIndex(segments, SegmentId::toString);
        HashSet<SegmentId> retVal = new HashSet<SegmentId>();
        Sequence<SegmentAnalysis> sequence = this.runSegmentMetadataQuery(Iterables.limit(segments, (int)15000));
        try (Yielder yielder = Yielders.each(sequence);){
            while (!yielder.isDone()) {
                SegmentAnalysis analysis = (SegmentAnalysis)yielder.get();
                SegmentId segmentId2 = (SegmentId)segmentIdMap.get(analysis.getId());
                if (segmentId2 == null) {
                    log.warn("Got analysis for segment[%s] we didn't ask for, ignoring.", new Object[]{analysis.getId()});
                } else {
                    RowSignature rowSignature = DruidSchema.analysisToRowSignature(analysis);
                    log.debug("Segment[%s] has signature[%s].", new Object[]{segmentId2, rowSignature});
                    this.segmentMetadataInfo.compute(dataSource, (datasourceKey, dataSourceSegments) -> {
                        if (dataSourceSegments == null) {
                            log.warn("No segment map found with datasource[%s], skipping refresh of segment[%s]", new Object[]{datasourceKey, segmentId2});
                            return null;
                        }
                        dataSourceSegments.compute(segmentId2, (segmentIdKey, segmentMetadata) -> {
                            if (segmentMetadata == null) {
                                log.warn("No segment[%s] found, skipping refresh", new Object[]{segmentId2});
                                return null;
                            }
                            AvailableSegmentMetadata updatedSegmentMetadata = AvailableSegmentMetadata.from(segmentMetadata).withRowSignature(rowSignature).withNumRows(analysis.getNumRows()).build();
                            retVal.add(segmentId2);
                            return updatedSegmentMetadata;
                        });
                        if (dataSourceSegments.isEmpty()) {
                            return null;
                        }
                        return dataSourceSegments;
                    });
                }
                yielder = yielder.next(null);
            }
        }
        log.debug("Refreshed metadata for dataSource[%s] in %,d ms (%d segments queried, %d segments left).", new Object[]{dataSource, System.currentTimeMillis() - startTime, retVal.size(), segments.size() - retVal.size()});
        return retVal;
    }

    @VisibleForTesting
    DruidTable buildDruidTable(String dataSource) {
        ConcurrentSkipListMap<SegmentId, AvailableSegmentMetadata> segmentsMap = this.segmentMetadataInfo.get(dataSource);
        TreeMap<String, ColumnType> columnTypes = new TreeMap<String, ColumnType>();
        if (segmentsMap != null) {
            for (AvailableSegmentMetadata availableSegmentMetadata : segmentsMap.values()) {
                RowSignature rowSignature = availableSegmentMetadata.getRowSignature();
                if (rowSignature == null) continue;
                for (String column : rowSignature.getColumnNames()) {
                    ColumnType columnType = (ColumnType)rowSignature.getColumnType(column).orElseThrow(() -> new ISE("Encountered null type for column[%s]", new Object[]{column}));
                    columnTypes.putIfAbsent(column, columnType);
                }
            }
        }
        RowSignature.Builder builder = RowSignature.builder();
        columnTypes.forEach((arg_0, arg_1) -> ((RowSignature.Builder)builder).add(arg_0, arg_1));
        GlobalTableDataSource maybeGlobal = new GlobalTableDataSource(dataSource);
        boolean isJoinable = this.joinableFactory.isDirectlyJoinable((DataSource)maybeGlobal);
        boolean isBroadcast = this.segmentManager.getDataSourceNames().contains(dataSource);
        Object tableDataSource = isBroadcast && isJoinable ? maybeGlobal : new TableDataSource(dataSource);
        return new DruidTable((DataSource)tableDataSource, builder.build(), null, isJoinable, isBroadcast);
    }

    @VisibleForTesting
    Map<SegmentId, AvailableSegmentMetadata> getSegmentMetadataSnapshot() {
        HashMap segmentMetadata = Maps.newHashMapWithExpectedSize((int)this.totalSegments);
        for (ConcurrentSkipListMap<SegmentId, AvailableSegmentMetadata> val : this.segmentMetadataInfo.values()) {
            segmentMetadata.putAll(val);
        }
        return segmentMetadata;
    }

    int getTotalSegments() {
        return this.totalSegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    TreeSet<SegmentId> getSegmentsNeedingRefresh() {
        Object object = this.lock;
        synchronized (object) {
            return this.segmentsNeedingRefresh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    TreeSet<SegmentId> getMutableSegments() {
        Object object = this.lock;
        synchronized (object) {
            return this.mutableSegments;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Set<String> getDataSourcesNeedingRebuild() {
        Object object = this.lock;
        synchronized (object) {
            return this.dataSourcesNeedingRebuild;
        }
    }

    @VisibleForTesting
    protected Sequence<SegmentAnalysis> runSegmentMetadataQuery(Iterable<SegmentId> segments) {
        String dataSource = (String)Iterables.getOnlyElement((Iterable)StreamSupport.stream(segments.spliterator(), false).map(SegmentId::getDataSource).collect(Collectors.toSet()));
        MultipleSpecificSegmentSpec querySegmentSpec = new MultipleSpecificSegmentSpec(StreamSupport.stream(segments.spliterator(), false).map(SegmentId::toDescriptor).collect(Collectors.toList()));
        SegmentMetadataQuery segmentMetadataQuery = new SegmentMetadataQuery((DataSource)new TableDataSource(dataSource), (QuerySegmentSpec)querySegmentSpec, (ColumnIncluderator)new AllColumnIncluderator(), Boolean.valueOf(false), this.brokerInternalQueryConfig.getContext(), EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class), Boolean.valueOf(false), Boolean.valueOf(false));
        return this.queryLifecycleFactory.factorize().runSimple((Query)segmentMetadataQuery, this.escalator.createEscalatedAuthenticationResult(), Access.OK);
    }

    @VisibleForTesting
    static RowSignature analysisToRowSignature(SegmentAnalysis analysis) {
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        for (Map.Entry entry : analysis.getColumns().entrySet()) {
            if (((ColumnAnalysis)entry.getValue()).isError()) continue;
            ColumnType valueType = ((ColumnAnalysis)entry.getValue()).getTypeSignature();
            if (valueType == null) {
                try {
                    valueType = ColumnType.fromString((String)((ColumnAnalysis)entry.getValue()).getType());
                }
                catch (IllegalArgumentException ignored) {
                    valueType = ColumnType.UNKNOWN_COMPLEX;
                }
            }
            rowSignatureBuilder.add((String)entry.getKey(), valueType);
        }
        return (RowSignature)ROW_SIGNATURE_INTERNER.intern((Object)rowSignatureBuilder.build());
    }

    @VisibleForTesting
    void setAvailableSegmentMetadata(SegmentId segmentId, AvailableSegmentMetadata availableSegmentMetadata) {
        ConcurrentSkipListMap dataSourceSegments = this.segmentMetadataInfo.computeIfAbsent(segmentId.getDataSource(), k -> new ConcurrentSkipListMap(SEGMENT_ORDER));
        if (dataSourceSegments.put(segmentId, availableSegmentMetadata) == null) {
            ++this.totalSegments;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void doInLock(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            runnable.run();
        }
    }
}

