/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.run;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.List;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.run.NativeQueryMaker;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.QueryMakerFactory;

@LazySingleton
public class NativeQueryMakerFactory
implements QueryMakerFactory {
    public static final String TYPE = "native";
    private final QueryLifecycleFactory queryLifecycleFactory;
    private final ObjectMapper jsonMapper;

    @Inject
    public NativeQueryMakerFactory(QueryLifecycleFactory queryLifecycleFactory, ObjectMapper jsonMapper) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public QueryMaker buildForSelect(RelRoot relRoot, PlannerContext plannerContext) {
        return new NativeQueryMaker(this.queryLifecycleFactory, plannerContext, this.jsonMapper, (List<Pair<Integer, String>>)relRoot.fields, relRoot.validatedRowType);
    }

    @Override
    public QueryMaker buildForInsert(String targetDataSource, RelRoot relRoot, PlannerContext plannerContext) throws ValidationException {
        throw new ValidationException("Cannot execute INSERT queries.");
    }
}

