/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.run;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.data.ComparableList;
import org.apache.druid.segment.data.ComparableStringArray;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.sql.calcite.aggregation.DimensionExpression;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.run.QueryFeature;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class NativeQueryMaker
implements QueryMaker {
    private final QueryLifecycleFactory queryLifecycleFactory;
    private final PlannerContext plannerContext;
    private final ObjectMapper jsonMapper;
    private final List<Pair<Integer, String>> fieldMapping;
    private final RelDataType resultType;

    public NativeQueryMaker(QueryLifecycleFactory queryLifecycleFactory, PlannerContext plannerContext, ObjectMapper jsonMapper, List<Pair<Integer, String>> fieldMapping, RelDataType resultType) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.plannerContext = plannerContext;
        this.jsonMapper = jsonMapper;
        this.fieldMapping = fieldMapping;
        this.resultType = resultType;
    }

    @Override
    public RelDataType getResultType() {
        return this.resultType;
    }

    @Override
    public boolean feature(QueryFeature feature) {
        switch (feature) {
            case CAN_RUN_TIMESERIES: 
            case CAN_RUN_TOPN: {
                return true;
            }
            case CAN_READ_EXTERNAL_DATA: 
            case SCAN_CAN_ORDER_BY_NON_TIME: {
                return false;
            }
        }
        throw new IAE("Unrecognized feature: %s", new Object[]{feature});
    }

    @Override
    public Sequence<Object[]> runQuery(DruidQuery druidQuery) {
        List rowOrder;
        Query query = druidQuery.getQuery();
        if (this.plannerContext.getPlannerConfig().isRequireTimeCondition() && !(druidQuery.getDataSource() instanceof InlineDataSource) && Intervals.ONLY_ETERNITY.equals(this.findBaseDataSourceIntervals(query))) {
            throw new CannotBuildQueryException("requireTimeCondition is enabled, all queries must include a filter condition on the __time column");
        }
        int numFilters = this.plannerContext.getPlannerConfig().getMaxNumericInFilters();
        if (numFilters != -1 && query.getFilter() instanceof OrDimFilter) {
            OrDimFilter orDimFilter = (OrDimFilter)query.getFilter();
            int numBoundFilters = 0;
            for (DimFilter filter : orDimFilter.getFields()) {
                numBoundFilters += filter instanceof BoundDimFilter ? 1 : 0;
            }
            if (numBoundFilters > numFilters) {
                String dimension = ((BoundDimFilter)orDimFilter.getFields().get(0)).getDimension();
                throw new UOE(StringUtils.format((String)"The number of values in the IN clause for [%s] in query exceeds configured maxNumericFilter limit of [%s] for INs. Cast [%s] values of IN clause to String", (Object[])new Object[]{dimension, numFilters, orDimFilter.getFields().size()}), new Object[0]);
            }
        }
        if (query instanceof TimeseriesQuery && !druidQuery.getGrouping().getDimensions().isEmpty()) {
            String timeDimension = ((DimensionExpression)Iterables.getOnlyElement(druidQuery.getGrouping().getDimensions())).getOutputName();
            rowOrder = druidQuery.getOutputRowSignature().getColumnNames().stream().map(f -> timeDimension.equals(f) ? "__time" : f).collect(Collectors.toList());
        } else {
            rowOrder = druidQuery.getOutputRowSignature().getColumnNames();
        }
        List columnTypes = druidQuery.getOutputRowType().getFieldList().stream().map(f -> f.getType().getSqlTypeName()).collect(Collectors.toList());
        return this.execute(query, NativeQueryMaker.mapColumnList(rowOrder, this.fieldMapping), NativeQueryMaker.mapColumnList(columnTypes, this.fieldMapping));
    }

    private List<Interval> findBaseDataSourceIntervals(Query<?> query) {
        return DataSourceAnalysis.forDataSource((DataSource)query.getDataSource()).getBaseQuerySegmentSpec().map(QuerySegmentSpec::getIntervals).orElseGet(() -> query.getIntervals());
    }

    private <T> Sequence<Object[]> execute(Query<T> query, List<String> newFields, List<SqlTypeName> newTypes) {
        Hook.QUERY_PLAN.run(query);
        if (query.getId() == null) {
            String queryId = UUID.randomUUID().toString();
            this.plannerContext.addNativeQueryId(queryId);
            query = query.withId(queryId);
        }
        query = query.withSqlQueryId(this.plannerContext.getSqlQueryId());
        AuthenticationResult authenticationResult = this.plannerContext.getAuthenticationResult();
        Access authorizationResult = this.plannerContext.getAuthorizationResult();
        QueryLifecycle queryLifecycle = this.queryLifecycleFactory.factorize();
        Sequence results = queryLifecycle.runSimple(query, authenticationResult, authorizationResult);
        QueryToolChest toolChest = queryLifecycle.getToolChest();
        List resultArrayFields = toolChest.resultArraySignature(query).getColumnNames();
        Sequence resultArrays = toolChest.resultsAsArrays(query, results);
        return this.mapResultSequence((Sequence<Object[]>)resultArrays, resultArrayFields, newFields, newTypes);
    }

    private Sequence<Object[]> mapResultSequence(Sequence<Object[]> sequence, List<String> originalFields, List<String> newFields, List<SqlTypeName> newTypes) {
        Object2IntOpenHashMap originalFieldsLookup = new Object2IntOpenHashMap();
        originalFieldsLookup.defaultReturnValue(-1);
        for (int i = 0; i < originalFields.size(); ++i) {
            originalFieldsLookup.put((Object)originalFields.get(i), i);
        }
        int[] mapping = new int[newFields.size()];
        for (int i = 0; i < newFields.size(); ++i) {
            String newField = newFields.get(i);
            int idx = originalFieldsLookup.getInt((Object)newField);
            if (idx < 0) {
                throw new ISE("newField[%s] not contained in originalFields[%s]", new Object[]{newField, String.join((CharSequence)", ", originalFields)});
            }
            mapping[i] = idx;
        }
        return Sequences.map(sequence, array -> {
            Object[] newArray = new Object[mapping.length];
            for (int i = 0; i < mapping.length; ++i) {
                newArray[i] = this.coerce(array[mapping[i]], (SqlTypeName)newTypes.get(i));
            }
            return newArray;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object coerce(Object value, SqlTypeName sqlType) {
        if (SqlTypeName.CHAR_TYPES.contains(sqlType)) {
            if (value == null) return NullHandling.nullToEmptyIfNeeded((String)((String)value));
            if (value instanceof String) {
                return NullHandling.nullToEmptyIfNeeded((String)((String)value));
            }
            if (value instanceof NlsString) {
                return ((NlsString)value).getValue();
            }
            if (value instanceof Number) {
                return String.valueOf(value);
            }
            if (!(value instanceof Collection)) throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            List valueStrings = ((Collection)value).stream().map(v -> (String)this.coerce(v, sqlType)).collect(Collectors.toList());
            try {
                return this.jsonMapper.writeValueAsString(valueStrings);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (value == null) {
            return null;
        }
        if (sqlType == SqlTypeName.DATE) {
            return Calcites.jodaToCalciteDate(NativeQueryMaker.coerceDateTime(value, sqlType), this.plannerContext.getTimeZone());
        }
        if (sqlType == SqlTypeName.TIMESTAMP) {
            return Calcites.jodaToCalciteTimestamp(NativeQueryMaker.coerceDateTime(value, sqlType), this.plannerContext.getTimeZone());
        }
        if (sqlType == SqlTypeName.BOOLEAN) {
            if (value instanceof String) {
                return Evals.asBoolean((String)((String)value));
            }
            if (!(value instanceof Number)) throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            return Evals.asBoolean((long)((Number)value).longValue());
        }
        if (sqlType == SqlTypeName.INTEGER) {
            if (value instanceof String) {
                return Ints.tryParse((String)((String)value));
            }
            if (!(value instanceof Number)) throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            return ((Number)value).intValue();
        }
        if (sqlType == SqlTypeName.BIGINT) {
            try {
                return DimensionHandlerUtils.convertObjectToLong((Object)value);
            }
            catch (Exception e) {
                throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            }
        }
        if (sqlType == SqlTypeName.FLOAT) {
            try {
                return DimensionHandlerUtils.convertObjectToFloat((Object)value);
            }
            catch (Exception e) {
                throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            }
        }
        if (SqlTypeName.FRACTIONAL_TYPES.contains(sqlType)) {
            try {
                return DimensionHandlerUtils.convertObjectToDouble((Object)value);
            }
            catch (Exception e) {
                throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            }
        }
        if (sqlType == SqlTypeName.OTHER) {
            if (!this.plannerContext.getPlannerConfig().shouldSerializeComplexValues()) return value.getClass().getName();
            try {
                return this.jsonMapper.writeValueAsString(value);
            }
            catch (JsonProcessingException jex) {
                throw new ISE((Throwable)jex, "Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            }
        }
        if (sqlType != SqlTypeName.ARRAY) throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
        if (this.plannerContext.isStringifyArrays()) {
            if (value instanceof String) {
                return NullHandling.nullToEmptyIfNeeded((String)((String)value));
            }
            if (value instanceof NlsString) {
                return ((NlsString)value).getValue();
            }
            try {
                return this.jsonMapper.writeValueAsString(value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Object coercedValue = NativeQueryMaker.maybeCoerceArrayToList(value, true);
        if (coercedValue != null) return coercedValue;
        throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
    }

    private static Object maybeCoerceArrayToList(Object value, boolean mustCoerce) {
        if (value instanceof List) {
            return value;
        }
        if (value instanceof String[]) {
            return Arrays.asList((String[])value);
        }
        if (value instanceof Long[]) {
            return Arrays.asList((Long[])value);
        }
        if (value instanceof Double[]) {
            return Arrays.asList((Double[])value);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            ArrayList<Object> lst = new ArrayList<Object>(array.length);
            for (Object o : array) {
                lst.add(NativeQueryMaker.maybeCoerceArrayToList(o, false));
            }
            return lst;
        }
        if (value instanceof ComparableStringArray) {
            return Arrays.asList(((ComparableStringArray)value).getDelegate());
        }
        if (value instanceof ComparableList) {
            return ((ComparableList)value).getDelegate();
        }
        if (mustCoerce) {
            return null;
        }
        return value;
    }

    private static DateTime coerceDateTime(Object value, SqlTypeName sqlType) {
        DateTime dateTime;
        if (value instanceof Number) {
            dateTime = DateTimes.utc((long)((Number)value).longValue());
        } else if (value instanceof String) {
            dateTime = DateTimes.utc((long)Long.parseLong((String)value));
        } else if (value instanceof DateTime) {
            dateTime = (DateTime)value;
        } else {
            throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
        }
        return dateTime;
    }

    private static <T> List<T> mapColumnList(List<T> in, List<Pair<Integer, String>> fieldMapping) {
        ArrayList<T> out = new ArrayList<T>(fieldMapping.size());
        for (Pair<Integer, String> entry : fieldMapping) {
            out.add(in.get((Integer)entry.getKey()));
        }
        return out;
    }
}

