/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidOuterQueryRel;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.rule.DruidJoinRule;
import org.apache.druid.sql.calcite.rule.DruidSortUnionRule;
import org.apache.druid.sql.calcite.rule.DruidUnionDataSourceRule;
import org.apache.druid.sql.calcite.rule.DruidUnionRule;

public class DruidRules {
    public static final Predicate<DruidRel> CAN_BUILD_ON = druidRel -> druidRel.getPartialDruidQuery() != null;

    private DruidRules() {
    }

    public static List<RelOptRule> rules(PlannerContext plannerContext) {
        return ImmutableList.of(new DruidQueryRule<Filter>(Filter.class, PartialDruidQuery.Stage.WHERE_FILTER, PartialDruidQuery::withWhereFilter), new DruidQueryRule<Project>(Project.class, PartialDruidQuery.Stage.SELECT_PROJECT, PartialDruidQuery::withSelectProject), new DruidQueryRule<Aggregate>(Aggregate.class, PartialDruidQuery.Stage.AGGREGATE, PartialDruidQuery::withAggregate), new DruidQueryRule<Project>(Project.class, PartialDruidQuery.Stage.AGGREGATE_PROJECT, PartialDruidQuery::withAggregateProject), new DruidQueryRule<Filter>(Filter.class, PartialDruidQuery.Stage.HAVING_FILTER, PartialDruidQuery::withHavingFilter), new DruidQueryRule<Sort>(Sort.class, PartialDruidQuery.Stage.SORT, PartialDruidQuery::withSort), new DruidQueryRule<Project>(Project.class, PartialDruidQuery.Stage.SORT_PROJECT, PartialDruidQuery::withSortProject), (Object)DruidOuterQueryRule.AGGREGATE, (Object)DruidOuterQueryRule.WHERE_FILTER, (Object)DruidOuterQueryRule.SELECT_PROJECT, (Object)DruidOuterQueryRule.SORT, (Object)((Object)new DruidUnionRule(plannerContext)), (Object[])new RelOptRule[]{new DruidUnionDataSourceRule(plannerContext), DruidSortUnionRule.instance(), DruidJoinRule.instance(plannerContext)});
    }

    public static abstract class DruidOuterQueryRule
    extends RelOptRule {
        public static final RelOptRule AGGREGATE = new DruidOuterQueryRule(DruidOuterQueryRule.operand(Aggregate.class, (RelOptRuleOperand)DruidOuterQueryRule.operandJ(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "AGGREGATE"){

            public void onMatch(RelOptRuleCall call) {
                Aggregate aggregate = (Aggregate)call.rel(0);
                DruidRel druidRel = (DruidRel)call.rel(1);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.create(druidRel.getPartialDruidQuery().leafRel()).withAggregate(aggregate));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };
        public static final RelOptRule WHERE_FILTER = new DruidOuterQueryRule(DruidOuterQueryRule.operand(Filter.class, (RelOptRuleOperand)DruidOuterQueryRule.operandJ(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "WHERE_FILTER"){

            public void onMatch(RelOptRuleCall call) {
                Filter filter = (Filter)call.rel(0);
                DruidRel druidRel = (DruidRel)call.rel(1);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.create(druidRel.getPartialDruidQuery().leafRel()).withWhereFilter(filter));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };
        public static final RelOptRule SELECT_PROJECT = new DruidOuterQueryRule(DruidOuterQueryRule.operand(Project.class, (RelOptRuleOperand)DruidOuterQueryRule.operandJ(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "SELECT_PROJECT"){

            public void onMatch(RelOptRuleCall call) {
                Project filter = (Project)call.rel(0);
                DruidRel druidRel = (DruidRel)call.rel(1);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.create(druidRel.getPartialDruidQuery().leafRel()).withSelectProject(filter));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };
        public static final RelOptRule SORT = new DruidOuterQueryRule(DruidOuterQueryRule.operand(Sort.class, (RelOptRuleOperand)DruidOuterQueryRule.operandJ(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "SORT"){

            public void onMatch(RelOptRuleCall call) {
                Sort sort = (Sort)call.rel(0);
                DruidRel druidRel = (DruidRel)call.rel(1);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.create(druidRel.getPartialDruidQuery().leafRel()).withSort(sort));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };

        public DruidOuterQueryRule(RelOptRuleOperand op, String description) {
            super(op, StringUtils.format((String)"%s(%s)", (Object[])new Object[]{DruidOuterQueryRel.class.getSimpleName(), description}));
        }

        public boolean matches(RelOptRuleCall call) {
            DruidRel druidRel = (DruidRel)call.rel(call.getRelList().size() - 1);
            return druidRel.getPartialDruidQuery().stage().compareTo(PartialDruidQuery.Stage.AGGREGATE) >= 0;
        }
    }

    public static class DruidQueryRule<RelType extends RelNode>
    extends RelOptRule {
        private final PartialDruidQuery.Stage stage;
        private final BiFunction<PartialDruidQuery, RelType, PartialDruidQuery> f;

        public DruidQueryRule(Class<RelType> relClass, PartialDruidQuery.Stage stage, BiFunction<PartialDruidQuery, RelType, PartialDruidQuery> f) {
            super(DruidQueryRule.operand(relClass, (RelOptRuleOperand)DruidQueryRule.operandJ(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), StringUtils.format((String)"%s(%s)", (Object[])new Object[]{DruidQueryRule.class.getSimpleName(), stage}));
            this.stage = stage;
            this.f = f;
        }

        public boolean matches(RelOptRuleCall call) {
            DruidRel druidRel = (DruidRel)call.rel(1);
            return druidRel.getPartialDruidQuery().canAccept(this.stage);
        }

        public void onMatch(RelOptRuleCall call) {
            PartialDruidQuery newPartialDruidQuery;
            RelNode otherRel = call.rel(0);
            DruidRel druidRel = (DruidRel)call.rel(1);
            Object newDruidRel = druidRel.withPartialQuery(newPartialDruidQuery = this.f.apply(druidRel.getPartialDruidQuery(), otherRel));
            if (((DruidRel)((Object)newDruidRel)).isValidDruidQuery()) {
                call.transformTo(newDruidRel);
            }
        }
    }
}

