/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class VirtualColumnRegistry {
    private final ExprMacroTable macroTable;
    private final RowSignature baseRowSignature;
    private final Map<ExpressionAndTypeHint, String> virtualColumnsByExpression;
    private final Map<String, ExpressionAndTypeHint> virtualColumnsByName;
    private final String virtualColumnPrefix;
    private int virtualColumnCounter;

    private VirtualColumnRegistry(RowSignature baseRowSignature, ExprMacroTable macroTable, String virtualColumnPrefix, Map<ExpressionAndTypeHint, String> virtualColumnsByExpression, Map<String, ExpressionAndTypeHint> virtualColumnsByName) {
        this.macroTable = macroTable;
        this.baseRowSignature = baseRowSignature;
        this.virtualColumnPrefix = virtualColumnPrefix;
        this.virtualColumnsByExpression = virtualColumnsByExpression;
        this.virtualColumnsByName = virtualColumnsByName;
    }

    public static VirtualColumnRegistry create(RowSignature rowSignature, ExprMacroTable macroTable) {
        return new VirtualColumnRegistry(rowSignature, macroTable, Calcites.findUnusedPrefixForDigits("v", rowSignature.getColumnNames()), new HashMap<ExpressionAndTypeHint, String>(), new HashMap<String, ExpressionAndTypeHint>());
    }

    public boolean isVirtualColumnDefined(String virtualColumnName) {
        return this.virtualColumnsByName.containsKey(virtualColumnName);
    }

    public String getOrCreateVirtualColumnForExpression(DruidExpression expression, ColumnType typeHint) {
        ExpressionAndTypeHint candidate = VirtualColumnRegistry.wrap(expression, typeHint);
        if (!this.virtualColumnsByExpression.containsKey(candidate)) {
            String virtualColumnName = this.virtualColumnPrefix + this.virtualColumnCounter++;
            this.virtualColumnsByExpression.put(candidate, virtualColumnName);
            this.virtualColumnsByName.put(virtualColumnName, candidate);
        }
        return this.virtualColumnsByExpression.get(candidate);
    }

    public String getOrCreateVirtualColumnForExpression(DruidExpression expression, RelDataType typeHint) {
        return this.getOrCreateVirtualColumnForExpression(expression, Calcites.getColumnTypeForRelDataType(typeHint));
    }

    @Nullable
    public VirtualColumn getVirtualColumn(String virtualColumnName) {
        return Optional.ofNullable(this.virtualColumnsByName.get(virtualColumnName)).map(v -> v.getExpression().toVirtualColumn(virtualColumnName, v.getTypeHint(), this.macroTable)).orElse(null);
    }

    @Nullable
    public String getVirtualColumnByExpression(DruidExpression expression, RelDataType typeHint) {
        return this.virtualColumnsByExpression.get(VirtualColumnRegistry.wrap(expression, Calcites.getColumnTypeForRelDataType(typeHint)));
    }

    public RowSignature getFullRowSignature() {
        RowSignature.Builder builder = RowSignature.builder().addAll(this.baseRowSignature);
        RowSignature baseSignature = builder.build();
        for (Map.Entry<String, ExpressionAndTypeHint> virtualColumn : this.virtualColumnsByName.entrySet()) {
            String columnName = virtualColumn.getKey();
            builder.add(columnName, virtualColumn.getValue().getExpression().toVirtualColumn(columnName, virtualColumn.getValue().getTypeHint(), this.macroTable).capabilities((ColumnInspector)baseSignature, columnName).toColumnType());
        }
        return builder.build();
    }

    public List<DruidExpression> findVirtualColumnExpressions(List<String> allColumns) {
        return allColumns.stream().filter(this::isVirtualColumnDefined).map(name -> this.virtualColumnsByName.get(name).getExpression()).collect(Collectors.toList());
    }

    public void visitAllSubExpressions(DruidExpression.DruidExpressionShuttle shuttle) {
        for (Map.Entry<String, ExpressionAndTypeHint> entry : this.virtualColumnsByName.entrySet()) {
            String key = entry.getKey();
            ExpressionAndTypeHint wrapped = entry.getValue();
            this.virtualColumnsByExpression.remove(wrapped);
            List<DruidExpression> newArgs = shuttle.visitAll(wrapped.getExpression().getArguments());
            ExpressionAndTypeHint newWrapped = VirtualColumnRegistry.wrap(wrapped.getExpression().withArguments(newArgs), wrapped.getTypeHint());
            this.virtualColumnsByName.put(key, newWrapped);
            this.virtualColumnsByExpression.put(newWrapped, key);
        }
    }

    public Collection<? extends VirtualColumn> getAllVirtualColumns(List<String> requiredColumns) {
        return requiredColumns.stream().filter(this::isVirtualColumnDefined).map(this::getVirtualColumn).collect(Collectors.toList());
    }

    @Deprecated
    public List<VirtualColumn> findVirtualColumns(List<String> allColumns) {
        return allColumns.stream().filter(this::isVirtualColumnDefined).map(this::getVirtualColumn).collect(Collectors.toList());
    }

    @Deprecated
    public VirtualColumn getOrCreateVirtualColumnForExpression(PlannerContext plannerContext, DruidExpression expression, ColumnType valueType) {
        String name = this.getOrCreateVirtualColumnForExpression(expression, valueType);
        return this.virtualColumnsByName.get(name).expression.toVirtualColumn(name, valueType, this.macroTable);
    }

    @Deprecated
    public VirtualColumn getOrCreateVirtualColumnForExpression(PlannerContext plannerContext, DruidExpression expression, RelDataType dataType) {
        return this.getOrCreateVirtualColumnForExpression(plannerContext, expression, Calcites.getColumnTypeForRelDataType(dataType));
    }

    @Deprecated
    @Nullable
    public VirtualColumn getVirtualColumnByExpression(String expression, RelDataType type) {
        ColumnType columnType = Calcites.getColumnTypeForRelDataType(type);
        ExpressionAndTypeHint wrapped = VirtualColumnRegistry.wrap(DruidExpression.fromExpression(expression), columnType);
        return Optional.ofNullable(this.virtualColumnsByExpression.get(wrapped)).map(this::getVirtualColumn).orElse(null);
    }

    private static ExpressionAndTypeHint wrap(DruidExpression expression, ColumnType typeHint) {
        return new ExpressionAndTypeHint(expression, typeHint);
    }

    private static class ExpressionAndTypeHint {
        private final DruidExpression expression;
        private final ColumnType typeHint;

        public ExpressionAndTypeHint(DruidExpression expression, ColumnType valueType) {
            this.expression = expression;
            this.typeHint = valueType;
        }

        public DruidExpression getExpression() {
            return this.expression;
        }

        public ColumnType getTypeHint() {
            return this.typeHint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpressionAndTypeHint expressionAndTypeHint = (ExpressionAndTypeHint)o;
            return Objects.equals(this.typeHint, expressionAndTypeHint.typeHint) && Objects.equals(this.expression, expressionAndTypeHint.expression);
        }

        public int hashCode() {
            return Objects.hash(this.expression, this.typeHint);
        }
    }
}

