/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import java.util.Optional;
import org.apache.druid.sql.calcite.rel.DruidJoinQueryRel;
import org.apache.druid.sql.calcite.rel.DruidQueryRel;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.DruidUnionDataSourceRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.table.DruidTable;

public class DruidRels {
    public static Optional<DruidTable> druidTableIfLeafRel(DruidRel<?> druidRel) {
        if (druidRel instanceof DruidQueryRel) {
            return Optional.of(((DruidQueryRel)druidRel).getDruidTable());
        }
        return Optional.empty();
    }

    public static boolean isScanOrMapping(DruidRel<?> druidRel, boolean canBeJoinOrUnion) {
        if (DruidRels.isScanOrProject(druidRel, canBeJoinOrUnion)) {
            PartialDruidQuery partialQuery = druidRel.getPartialDruidQuery();
            return partialQuery.getSelectProject() == null || partialQuery.getSelectProject().isMapping();
        }
        return false;
    }

    private static boolean isScanOrProject(DruidRel<?> druidRel, boolean canBeJoinOrUnion) {
        if (druidRel instanceof DruidQueryRel || canBeJoinOrUnion && (druidRel instanceof DruidJoinQueryRel || druidRel instanceof DruidUnionDataSourceRel)) {
            PartialDruidQuery partialQuery = druidRel.getPartialDruidQuery();
            PartialDruidQuery.Stage stage = partialQuery.stage();
            return (stage == PartialDruidQuery.Stage.SCAN || stage == PartialDruidQuery.Stage.SELECT_PROJECT) && partialQuery.getWhereFilter() == null;
        }
        return false;
    }
}

