/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.validate.IdentifierNamespace;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.expression.AuthorizableOperator;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class SqlResourceCollectorShuttle
extends SqlShuttle {
    private final Set<ResourceAction> resourceActions;
    private final PlannerContext plannerContext;
    private final SqlValidator validator;

    public SqlResourceCollectorShuttle(SqlValidator validator, PlannerContext plannerContext) {
        this.validator = validator;
        this.resourceActions = new HashSet<ResourceAction>();
        this.plannerContext = plannerContext;
    }

    public SqlNode visit(SqlCall call) {
        if (call.getOperator() instanceof AuthorizableOperator) {
            this.resourceActions.addAll(((AuthorizableOperator)call.getOperator()).computeResources(call));
        }
        return super.visit(call);
    }

    public SqlNode visit(SqlIdentifier id) {
        SqlValidatorTable validatorTable;
        SqlValidatorNamespace namespace = this.validator.getNamespace((SqlNode)id);
        if (namespace != null && namespace.isWrapperFor(IdentifierNamespace.class) && (validatorTable = namespace.getTable()) != null) {
            List qualifiedNameParts = validatorTable.getQualifiedName();
            if (qualifiedNameParts.size() == 2) {
                String resourceName;
                String schema = (String)qualifiedNameParts.get(0);
                String resourceType = this.plannerContext.getSchemaResourceType(schema, resourceName = (String)qualifiedNameParts.get(1));
                if (resourceType != null) {
                    this.resourceActions.add(new ResourceAction(new Resource(resourceName, resourceType), Action.READ));
                }
            } else if (qualifiedNameParts.size() > 2) {
                throw new ISE("Cannot analyze table idetifier %s", new Object[]{qualifiedNameParts});
            }
        }
        return super.visit(id);
    }

    public Set<ResourceAction> getResourceActions() {
        return this.resourceActions;
    }
}

