/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.util.TimestampString;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class SqlParameterizerShuttle
extends SqlShuttle {
    private final PlannerContext plannerContext;

    public SqlParameterizerShuttle(PlannerContext plannerContext) {
        this.plannerContext = plannerContext;
    }

    public SqlNode visit(SqlDynamicParam param) {
        try {
            if (this.plannerContext.getParameters().size() > param.getIndex()) {
                TypedValue paramBinding = this.plannerContext.getParameters().get(param.getIndex());
                if (paramBinding == null) {
                    throw new IAE("Parameter at position[%s] is not bound", new Object[]{param.getIndex()});
                }
                if (paramBinding.value == null) {
                    return SqlLiteral.createNull((SqlParserPos)param.getParserPosition());
                }
                SqlTypeName typeName = SqlTypeName.getNameForJdbcType((int)paramBinding.type.typeId);
                if (SqlTypeName.APPROX_TYPES.contains(typeName)) {
                    return SqlLiteral.createApproxNumeric((String)paramBinding.value.toString(), (SqlParserPos)param.getParserPosition());
                }
                if (SqlTypeName.TIMESTAMP.equals((Object)typeName) && paramBinding.value instanceof Long) {
                    return SqlLiteral.createTimestamp((TimestampString)TimestampString.fromMillisSinceEpoch((long)((Long)paramBinding.value)), (int)0, (SqlParserPos)param.getParserPosition());
                }
                return typeName.createLiteral(paramBinding.value, param.getParserPosition());
            }
            throw new IAE("Parameter at position[%s] is not bound", new Object[]{param.getIndex()});
        }
        catch (ClassCastException classCastException) {
            return param;
        }
    }
}

