/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.QueryContext;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;

public class PlannerConfig {
    public static final String CTX_KEY_USE_APPROXIMATE_COUNT_DISTINCT = "useApproximateCountDistinct";
    public static final String CTX_KEY_USE_GROUPING_SET_FOR_EXACT_DISTINCT = "useGroupingSetForExactDistinct";
    public static final String CTX_KEY_USE_APPROXIMATE_TOPN = "useApproximateTopN";
    public static final String CTX_COMPUTE_INNER_JOIN_COST_AS_FILTER = "computeInnerJoinCostAsFilter";
    public static final String CTX_KEY_USE_NATIVE_QUERY_EXPLAIN = "useNativeQueryExplain";
    public static final String CTX_MAX_NUMERIC_IN_FILTERS = "maxNumericInFilters";
    public static final int NUM_FILTER_NOT_USED = -1;
    @JsonProperty
    private Period metadataRefreshPeriod = new Period((Object)"PT1M");
    @JsonProperty
    private int maxTopNLimit = 100000;
    @JsonProperty
    private boolean useApproximateCountDistinct = true;
    @JsonProperty
    private boolean useApproximateTopN = true;
    @JsonProperty
    private boolean requireTimeCondition = false;
    @JsonProperty
    private boolean awaitInitializationOnStart = true;
    @JsonProperty
    private DateTimeZone sqlTimeZone = DateTimeZone.UTC;
    @JsonProperty
    private boolean metadataSegmentCacheEnable = false;
    @JsonProperty
    private long metadataSegmentPollPeriod = 60000L;
    @JsonProperty
    private boolean useGroupingSetForExactDistinct = false;
    @JsonProperty
    private boolean computeInnerJoinCostAsFilter = true;
    @JsonProperty
    private boolean authorizeSystemTablesDirectly = false;
    @JsonProperty
    private boolean useNativeQueryExplain = false;
    @JsonProperty
    private int maxNumericInFilters = -1;
    private boolean serializeComplexValues = true;

    public long getMetadataSegmentPollPeriod() {
        return this.metadataSegmentPollPeriod;
    }

    public int getMaxNumericInFilters() {
        return this.maxNumericInFilters;
    }

    public boolean isMetadataSegmentCacheEnable() {
        return this.metadataSegmentCacheEnable;
    }

    public Period getMetadataRefreshPeriod() {
        return this.metadataRefreshPeriod;
    }

    public int getMaxTopNLimit() {
        return this.maxTopNLimit;
    }

    public boolean isUseApproximateCountDistinct() {
        return this.useApproximateCountDistinct;
    }

    public boolean isUseGroupingSetForExactDistinct() {
        return this.useGroupingSetForExactDistinct;
    }

    public boolean isUseApproximateTopN() {
        return this.useApproximateTopN;
    }

    public boolean isRequireTimeCondition() {
        return this.requireTimeCondition;
    }

    public DateTimeZone getSqlTimeZone() {
        return this.sqlTimeZone;
    }

    public boolean isAwaitInitializationOnStart() {
        return this.awaitInitializationOnStart;
    }

    public boolean shouldSerializeComplexValues() {
        return this.serializeComplexValues;
    }

    public boolean isComputeInnerJoinCostAsFilter() {
        return this.computeInnerJoinCostAsFilter;
    }

    public boolean isAuthorizeSystemTablesDirectly() {
        return this.authorizeSystemTablesDirectly;
    }

    public boolean isUseNativeQueryExplain() {
        return this.useNativeQueryExplain;
    }

    public PlannerConfig withOverrides(QueryContext queryContext) {
        if (queryContext.isEmpty()) {
            return this;
        }
        PlannerConfig newConfig = new PlannerConfig();
        newConfig.metadataRefreshPeriod = this.getMetadataRefreshPeriod();
        newConfig.maxTopNLimit = this.getMaxTopNLimit();
        newConfig.useApproximateCountDistinct = queryContext.getAsBoolean(CTX_KEY_USE_APPROXIMATE_COUNT_DISTINCT, this.isUseApproximateCountDistinct());
        newConfig.useGroupingSetForExactDistinct = queryContext.getAsBoolean(CTX_KEY_USE_GROUPING_SET_FOR_EXACT_DISTINCT, this.isUseGroupingSetForExactDistinct());
        newConfig.useApproximateTopN = queryContext.getAsBoolean(CTX_KEY_USE_APPROXIMATE_TOPN, this.isUseApproximateTopN());
        newConfig.computeInnerJoinCostAsFilter = queryContext.getAsBoolean(CTX_COMPUTE_INNER_JOIN_COST_AS_FILTER, this.computeInnerJoinCostAsFilter);
        newConfig.useNativeQueryExplain = queryContext.getAsBoolean(CTX_KEY_USE_NATIVE_QUERY_EXPLAIN, this.isUseNativeQueryExplain());
        int systemConfigMaxNumericInFilters = this.getMaxNumericInFilters();
        int queryContextMaxNumericInFilters = queryContext.getAsInt(CTX_MAX_NUMERIC_IN_FILTERS, this.getMaxNumericInFilters());
        newConfig.maxNumericInFilters = this.validateMaxNumericInFilters(queryContextMaxNumericInFilters, systemConfigMaxNumericInFilters);
        newConfig.requireTimeCondition = this.isRequireTimeCondition();
        newConfig.sqlTimeZone = this.getSqlTimeZone();
        newConfig.awaitInitializationOnStart = this.isAwaitInitializationOnStart();
        newConfig.metadataSegmentCacheEnable = this.isMetadataSegmentCacheEnable();
        newConfig.metadataSegmentPollPeriod = this.getMetadataSegmentPollPeriod();
        newConfig.serializeComplexValues = this.shouldSerializeComplexValues();
        newConfig.authorizeSystemTablesDirectly = this.isAuthorizeSystemTablesDirectly();
        return newConfig;
    }

    private int validateMaxNumericInFilters(int queryContextMaxNumericInFilters, int systemConfigMaxNumericInFilters) {
        if (queryContextMaxNumericInFilters == 0) {
            throw new UOE("[%s] must be greater than 0", new Object[]{CTX_MAX_NUMERIC_IN_FILTERS});
        }
        if (queryContextMaxNumericInFilters > systemConfigMaxNumericInFilters && systemConfigMaxNumericInFilters != -1) {
            throw new UOE("Expected parameter[%s] cannot exceed system set value of [%d]", new Object[]{CTX_MAX_NUMERIC_IN_FILTERS, systemConfigMaxNumericInFilters});
        }
        if (systemConfigMaxNumericInFilters == -1) {
            return systemConfigMaxNumericInFilters;
        }
        return queryContextMaxNumericInFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlannerConfig that = (PlannerConfig)o;
        return this.maxTopNLimit == that.maxTopNLimit && this.useApproximateCountDistinct == that.useApproximateCountDistinct && this.useApproximateTopN == that.useApproximateTopN && this.requireTimeCondition == that.requireTimeCondition && this.awaitInitializationOnStart == that.awaitInitializationOnStart && this.metadataSegmentCacheEnable == that.metadataSegmentCacheEnable && this.metadataSegmentPollPeriod == that.metadataSegmentPollPeriod && this.serializeComplexValues == that.serializeComplexValues && Objects.equals(this.metadataRefreshPeriod, that.metadataRefreshPeriod) && Objects.equals(this.sqlTimeZone, that.sqlTimeZone) && this.useNativeQueryExplain == that.useNativeQueryExplain;
    }

    public int hashCode() {
        return Objects.hash(this.metadataRefreshPeriod, this.maxTopNLimit, this.useApproximateCountDistinct, this.useApproximateTopN, this.requireTimeCondition, this.awaitInitializationOnStart, this.sqlTimeZone, this.metadataSegmentCacheEnable, this.metadataSegmentPollPeriod, this.serializeComplexValues, this.useNativeQueryExplain);
    }

    public String toString() {
        return "PlannerConfig{metadataRefreshPeriod=" + this.metadataRefreshPeriod + ", maxTopNLimit=" + this.maxTopNLimit + ", useApproximateCountDistinct=" + this.useApproximateCountDistinct + ", useApproximateTopN=" + this.useApproximateTopN + ", requireTimeCondition=" + this.requireTimeCondition + ", awaitInitializationOnStart=" + this.awaitInitializationOnStart + ", metadataSegmentCacheEnable=" + this.metadataSegmentCacheEnable + ", metadataSegmentPollPeriod=" + this.metadataSegmentPollPeriod + ", sqlTimeZone=" + this.sqlTimeZone + ", serializeComplexValues=" + this.serializeComplexValues + ", useNativeQueryExplain=" + this.useNativeQueryExplain + '}';
    }
}

