/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;

public class OffsetLimit {
    private final long offset;
    @Nullable
    private final Long limit;

    OffsetLimit(long offset, @Nullable Long limit) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset >= 0");
        Preconditions.checkArgument((limit == null || limit >= 0L ? 1 : 0) != 0, (Object)"limit == null || limit >= 0");
        this.offset = offset;
        this.limit = limit;
    }

    public static OffsetLimit none() {
        return new OffsetLimit(0L, null);
    }

    public static OffsetLimit fromSort(Sort sort) {
        long offset = sort.offset == null ? 0L : (long)RexLiteral.intValue((RexNode)sort.offset);
        Long limit = sort.fetch == null ? null : Long.valueOf(RexLiteral.intValue((RexNode)sort.fetch));
        return new OffsetLimit(offset, limit);
    }

    public boolean hasOffset() {
        return this.offset > 0L;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean hasLimit() {
        return this.limit != null;
    }

    public long getLimit() {
        Preconditions.checkState((this.limit != null ? 1 : 0) != 0, (Object)"limit is not present");
        return this.limit;
    }

    @Nullable
    public RexNode getOffsetAsRexNode(RexBuilder builder) {
        if (this.offset == 0L) {
            return null;
        }
        return builder.makeLiteral((Object)this.offset, (RelDataType)new BasicSqlType((RelDataTypeSystem)DruidTypeSystem.INSTANCE, SqlTypeName.BIGINT), false);
    }

    @Nullable
    public RexNode getLimitAsRexNode(RexBuilder builder) {
        if (this.limit == null) {
            return null;
        }
        return builder.makeLiteral((Object)this.limit, (RelDataType)new BasicSqlType((RelDataTypeSystem)DruidTypeSystem.INSTANCE, SqlTypeName.BIGINT), false);
    }

    public OffsetLimit andThen(OffsetLimit next) {
        Long newLimit = this.limit == null && next.limit == null ? null : (this.limit == null ? next.limit : (next.limit == null ? Long.valueOf(Math.max(0L, this.limit - next.offset)) : Long.valueOf(Math.max(0L, Math.min(this.limit - next.offset, next.limit)))));
        return new OffsetLimit(this.offset + next.offset, newLimit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetLimit that = (OffsetLimit)o;
        return Objects.equals(this.offset, that.offset) && Objects.equals(this.limit, that.limit);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.limit);
    }

    public String toString() {
        return "OffsetLimit{offset=" + this.offset + ", limit=" + this.limit + '}';
    }
}

