/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.Query;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.parser.DruidSqlInsert;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidConformance;
import org.apache.druid.sql.calcite.planner.OffsetLimit;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.planner.PrepareResult;
import org.apache.druid.sql.calcite.planner.RelParameterizerShuttle;
import org.apache.druid.sql.calcite.planner.SqlParameterizerShuttle;
import org.apache.druid.sql.calcite.planner.SqlResourceCollectorShuttle;
import org.apache.druid.sql.calcite.planner.UnsupportedSQLQueryException;
import org.apache.druid.sql.calcite.planner.ValidationResult;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.DruidUnionRel;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.QueryMakerFactory;
import org.apache.druid.utils.Throwables;

public class DruidPlanner
implements Closeable {
    private static final EmittingLogger log = new EmittingLogger(DruidPlanner.class);
    private final FrameworkConfig frameworkConfig;
    private final Planner planner;
    private final PlannerContext plannerContext;
    private final QueryMakerFactory queryMakerFactory;
    private RexBuilder rexBuilder;

    DruidPlanner(FrameworkConfig frameworkConfig, PlannerContext plannerContext, QueryMakerFactory queryMakerFactory) {
        this.frameworkConfig = frameworkConfig;
        this.planner = Frameworks.getPlanner((FrameworkConfig)frameworkConfig);
        this.plannerContext = plannerContext;
        this.queryMakerFactory = queryMakerFactory;
    }

    public ValidationResult validate(boolean authorizeContextParams) throws SqlParseException, ValidationException {
        SqlNode validatedQueryNode;
        this.resetPlanner();
        ParsedNodes parsed = ParsedNodes.create(this.planner.parse(this.plannerContext.getSql()));
        SqlValidator validator = this.getValidator();
        try {
            validatedQueryNode = validator.validate(this.rewriteDynamicParameters(parsed.getQueryNode()));
        }
        catch (RuntimeException e) {
            throw new ValidationException((Throwable)e);
        }
        SqlResourceCollectorShuttle resourceCollectorShuttle = new SqlResourceCollectorShuttle(validator, this.plannerContext);
        validatedQueryNode.accept((SqlVisitor)resourceCollectorShuttle);
        HashSet<ResourceAction> resourceActions = new HashSet<ResourceAction>(resourceCollectorShuttle.getResourceActions());
        if (parsed.getInsertNode() != null) {
            String targetDataSource = this.validateAndGetDataSourceForInsert(parsed.getInsertNode());
            resourceActions.add(new ResourceAction(new Resource(targetDataSource, "DATASOURCE"), Action.WRITE));
        }
        if (authorizeContextParams) {
            this.plannerContext.getQueryContext().getUserParams().keySet().forEach(contextParam -> resourceActions.add(new ResourceAction(new Resource(contextParam, "QUERY_CONTEXT"), Action.WRITE)));
        }
        this.plannerContext.setResourceActions(resourceActions);
        return new ValidationResult(resourceActions);
    }

    public PrepareResult prepare() throws SqlParseException, ValidationException, RelConversionException {
        this.resetPlanner();
        ParsedNodes parsed = ParsedNodes.create(this.planner.parse(this.plannerContext.getSql()));
        SqlNode validatedQueryNode = this.planner.validate(parsed.getQueryNode());
        RelRoot rootQueryRel = this.planner.rel(validatedQueryNode);
        SqlValidator validator = this.getValidator();
        RelDataTypeFactory typeFactory = rootQueryRel.rel.getCluster().getTypeFactory();
        RelDataType parameterTypes = validator.getParameterRowType(validator.validate(validatedQueryNode));
        RelDataType returnedRowType = parsed.getExplainNode() != null ? DruidPlanner.getExplainStructType(typeFactory) : this.buildQueryMaker(rootQueryRel, parsed.getInsertNode()).getResultType();
        return new PrepareResult(returnedRowType, parameterTypes);
    }

    public PlannerResult plan() throws SqlParseException, ValidationException, RelConversionException {
        this.resetPlanner();
        ParsedNodes parsed = ParsedNodes.create(this.planner.parse(this.plannerContext.getSql()));
        try {
            if (parsed.getIngestionGranularity() != null) {
                this.plannerContext.getQueryContext().addSystemParam("sqlInsertSegmentGranularity", (Object)this.plannerContext.getJsonMapper().writeValueAsString((Object)parsed.getIngestionGranularity()));
            }
        }
        catch (JsonProcessingException e) {
            throw new ValidationException("Unable to serialize partition granularity.");
        }
        this.rexBuilder = new RexBuilder(this.planner.getTypeFactory());
        SqlNode parameterizedQueryNode = this.rewriteDynamicParameters(parsed.getQueryNode());
        SqlNode validatedQueryNode = this.planner.validate(parameterizedQueryNode);
        RelRoot rootQueryRel = this.planner.rel(validatedQueryNode);
        try {
            return this.planWithDruidConvention(rootQueryRel, parsed.getExplainNode(), parsed.getInsertNode());
        }
        catch (Exception e) {
            Throwable cannotPlanException = Throwables.getCauseOfType((Throwable)e, RelOptPlanner.CannotPlanException.class);
            if (null == cannotPlanException) {
                throw e;
            }
            if (parsed.getInsertNode() == null) {
                try {
                    return this.planWithBindableConvention(rootQueryRel, parsed.getExplainNode());
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
            }
            EmittingLogger logger = log;
            if (!this.plannerContext.getQueryContext().isDebug()) {
                logger = log.noStackTrace();
            }
            String errorMessage = this.buildSQLPlanningErrorMessage(cannotPlanException);
            logger.warn((Throwable)e, errorMessage, new Object[0]);
            throw new UnsupportedSQLQueryException(errorMessage, new Object[0]);
        }
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    @Override
    public void close() {
        this.planner.close();
    }

    private void resetPlanner() {
        this.planner.close();
        this.planner.reset();
    }

    private PlannerResult planWithDruidConvention(RelRoot root, @Nullable SqlExplain explain, @Nullable SqlInsert insert) throws ValidationException, RelConversionException {
        RelRoot possiblyLimitedRoot = this.possiblyWrapRootWithOuterLimitFromContext(root);
        QueryMaker queryMaker = this.buildQueryMaker(root, insert);
        this.plannerContext.setQueryMaker(queryMaker);
        RelNode parameterized = this.rewriteRelDynamicParameters(possiblyLimitedRoot.rel);
        DruidRel druidRel = (DruidRel)this.planner.transform(0, this.planner.getEmptyTraitSet().replace((RelTrait)DruidConvention.instance()).plus((RelTrait)root.collation), parameterized);
        if (explain != null) {
            return this.planExplanation((RelNode)druidRel, explain, true);
        }
        Supplier resultsSupplier = () -> {
            Set readResourceActions = this.plannerContext.getResourceActions().stream().filter(action -> action.getAction() == Action.READ).collect(Collectors.toSet());
            Preconditions.checkState((readResourceActions.isEmpty() == druidRel.getDataSourceNames().isEmpty() || readResourceActions.size() >= druidRel.getDataSourceNames().size() ? 1 : 0) != 0, (Object)"Authorization sanity check failed");
            return druidRel.runQuery();
        };
        return new PlannerResult((Supplier<Sequence<Object[]>>)resultsSupplier, queryMaker.getResultType());
    }

    private PlannerResult planWithBindableConvention(RelRoot root, @Nullable SqlExplain explain) throws RelConversionException {
        BindableRel bindableRel = (BindableRel)this.planner.transform(1, this.planner.getEmptyTraitSet().replace((RelTrait)BindableConvention.INSTANCE).plus((RelTrait)root.collation), root.rel);
        if (!root.isRefTrivial()) {
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            RexBuilder rexBuilder = bindableRel.getCluster().getRexBuilder();
            Iterator iterator = Pair.left((List)root.fields).iterator();
            while (iterator.hasNext()) {
                int field = (Integer)iterator.next();
                projects.add(rexBuilder.makeInputRef((RelNode)bindableRel, field));
            }
            bindableRel = new Bindables.BindableProject(bindableRel.getCluster(), bindableRel.getTraitSet(), (RelNode)bindableRel, projects, root.validatedRowType);
        }
        if (explain != null) {
            return this.planExplanation((RelNode)bindableRel, explain, false);
        }
        BindableRel theRel = bindableRel;
        DataContext dataContext = this.plannerContext.createDataContext((JavaTypeFactory)this.planner.getTypeFactory(), this.plannerContext.getParameters());
        Supplier resultsSupplier = () -> {
            Enumerable enumerable = theRel.bind(dataContext);
            final Enumerator enumerator = enumerable.enumerator();
            return Sequences.withBaggage((Sequence)new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Object[], EnumeratorIterator<Object[]>>(){

                public EnumeratorIterator<Object[]> make() {
                    return new EnumeratorIterator<Object[]>(new Iterator<Object[]>(){

                        @Override
                        public boolean hasNext() {
                            return enumerator.moveNext();
                        }

                        @Override
                        public Object[] next() {
                            return (Object[])enumerator.current();
                        }
                    });
                }

                public void cleanup(EnumeratorIterator<Object[]> iterFromMake) {
                }
            }), () -> ((Enumerator)enumerator).close());
        };
        return new PlannerResult((Supplier<Sequence<Object[]>>)resultsSupplier, root.validatedRowType);
    }

    private PlannerResult planExplanation(RelNode rel, SqlExplain explain, boolean isDruidConventionExplanation) {
        String resourcesString;
        String explanation = RelOptUtil.dumpPlan((String)"", (RelNode)rel, (SqlExplainFormat)explain.getFormat(), (SqlExplainLevel)explain.getDetailLevel());
        try {
            if (isDruidConventionExplanation && rel instanceof DruidRel && this.plannerContext.getPlannerConfig().isUseNativeQueryExplain()) {
                DruidRel druidRel = (DruidRel)rel;
                try {
                    explanation = this.explainSqlPlanAsNativeQueries(druidRel);
                }
                catch (Exception ex) {
                    log.warn((Throwable)ex, "Unable to translate to a native Druid query. Resorting to legacy Druid explain plan", new Object[0]);
                }
            }
            Set resources = this.plannerContext.getResourceActions().stream().map(ResourceAction::getResource).collect(Collectors.toSet());
            resourcesString = this.plannerContext.getJsonMapper().writeValueAsString(resources);
        }
        catch (JsonProcessingException jpe) {
            log.error((Throwable)jpe, "Encountered exception while serializing Resources for explain output", new Object[0]);
            resourcesString = null;
        }
        Supplier resultsSupplier = Suppliers.ofInstance((Object)Sequences.simple((Iterable)ImmutableList.of((Object)new Object[]{explanation, resourcesString})));
        return new PlannerResult((Supplier<Sequence<Object[]>>)resultsSupplier, DruidPlanner.getExplainStructType(rel.getCluster().getTypeFactory()));
    }

    private String explainSqlPlanAsNativeQueries(DruidRel<?> rel) throws JsonProcessingException {
        ObjectMapper jsonMapper = this.plannerContext.getJsonMapper();
        List druidQueryList = this.flattenOutermostRel(rel).stream().map(druidRel -> druidRel.toDruidQuery(false)).collect(Collectors.toList());
        ArrayNode nativeQueriesArrayNode = jsonMapper.createArrayNode();
        for (DruidQuery druidQuery : druidQueryList) {
            Query nativeQuery = druidQuery.getQuery();
            ObjectNode objectNode = jsonMapper.createObjectNode();
            objectNode.put("query", (JsonNode)jsonMapper.convertValue((Object)nativeQuery, ObjectNode.class));
            objectNode.put("signature", (JsonNode)jsonMapper.convertValue((Object)druidQuery.getOutputRowSignature(), ArrayNode.class));
            nativeQueriesArrayNode.add((JsonNode)objectNode);
        }
        return jsonMapper.writeValueAsString((Object)nativeQueriesArrayNode);
    }

    private List<DruidRel<?>> flattenOutermostRel(DruidRel<?> outermostDruidRel) {
        ArrayList druidRels = new ArrayList();
        this.flattenOutermostRel(outermostDruidRel, druidRels);
        return druidRels;
    }

    private void flattenOutermostRel(DruidRel<?> druidRel, List<DruidRel<?>> flattendListAccumulator) {
        if (druidRel instanceof DruidUnionRel) {
            DruidUnionRel druidUnionRel = (DruidUnionRel)druidRel;
            druidUnionRel.getInputs().forEach(innerRelNode -> {
                DruidRel innerDruidRelNode = (DruidRel)((Object)innerRelNode);
                this.flattenOutermostRel(innerDruidRelNode, flattendListAccumulator);
            });
        } else {
            flattendListAccumulator.add(druidRel);
        }
    }

    @Nullable
    private RelRoot possiblyWrapRootWithOuterLimitFromContext(RelRoot root) {
        LogicalSort newRootRel;
        Object outerLimitObj = this.plannerContext.getQueryContext().get("sqlOuterLimit");
        Long outerLimit = DimensionHandlerUtils.convertObjectToLong((Object)outerLimitObj, (boolean)true);
        if (outerLimit == null) {
            return root;
        }
        if (root.rel instanceof Sort) {
            Sort sort = (Sort)root.rel;
            OffsetLimit originalOffsetLimit = OffsetLimit.fromSort(sort);
            OffsetLimit newOffsetLimit = originalOffsetLimit.andThen(new OffsetLimit(0L, outerLimit));
            if (newOffsetLimit.equals(originalOffsetLimit)) {
                return root;
            }
            newRootRel = LogicalSort.create((RelNode)sort.getInput(), (RelCollation)sort.collation, (RexNode)newOffsetLimit.getOffsetAsRexNode(this.rexBuilder), (RexNode)newOffsetLimit.getLimitAsRexNode(this.rexBuilder));
        } else {
            newRootRel = LogicalSort.create((RelNode)root.rel, (RelCollation)root.collation, null, (RexNode)new OffsetLimit(0L, outerLimit).getLimitAsRexNode(this.rexBuilder));
        }
        return new RelRoot((RelNode)newRootRel, root.validatedRowType, root.kind, (List)root.fields, root.collation);
    }

    private SqlValidator getValidator() {
        CalciteConnectionConfig connectionConfig;
        Preconditions.checkNotNull((Object)this.planner.getTypeFactory());
        if (this.frameworkConfig.getContext() != null) {
            connectionConfig = (CalciteConnectionConfig)this.frameworkConfig.getContext().unwrap(CalciteConnectionConfig.class);
        } else {
            Properties properties = new Properties();
            properties.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(PlannerFactory.PARSER_CONFIG.caseSensitive()));
            connectionConfig = new CalciteConnectionConfigImpl(properties);
        }
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)this.frameworkConfig.getDefaultSchema().getParentSchema()), CalciteSchema.from((SchemaPlus)this.frameworkConfig.getDefaultSchema()).path(null), this.planner.getTypeFactory(), connectionConfig);
        return SqlValidatorUtil.newValidator((SqlOperatorTable)this.frameworkConfig.getOperatorTable(), (SqlValidatorCatalogReader)catalogReader, (RelDataTypeFactory)this.planner.getTypeFactory(), (SqlConformance)DruidConformance.instance());
    }

    private SqlNode rewriteDynamicParameters(SqlNode parsed) {
        if (!this.plannerContext.getParameters().isEmpty()) {
            SqlParameterizerShuttle sshuttle = new SqlParameterizerShuttle(this.plannerContext);
            return (SqlNode)parsed.accept((SqlVisitor)sshuttle);
        }
        return parsed;
    }

    private RelNode rewriteRelDynamicParameters(RelNode rootRel) {
        RelParameterizerShuttle parameterizer = new RelParameterizerShuttle(this.plannerContext);
        return rootRel.accept((RelShuttle)parameterizer);
    }

    private QueryMaker buildQueryMaker(RelRoot rootQueryRel, @Nullable SqlInsert insert) throws ValidationException {
        if (insert != null) {
            String targetDataSource = this.validateAndGetDataSourceForInsert(insert);
            return this.queryMakerFactory.buildForInsert(targetDataSource, rootQueryRel, this.plannerContext);
        }
        return this.queryMakerFactory.buildForSelect(rootQueryRel, this.plannerContext);
    }

    private static RelDataType getExplainStructType(RelDataTypeFactory typeFactory) {
        return typeFactory.createStructType((List)ImmutableList.of((Object)Calcites.createSqlType(typeFactory, SqlTypeName.VARCHAR), (Object)Calcites.createSqlType(typeFactory, SqlTypeName.VARCHAR)), (List)ImmutableList.of((Object)"PLAN", (Object)"RESOURCES"));
    }

    private String validateAndGetDataSourceForInsert(SqlInsert insert) throws ValidationException {
        String dataSource;
        if (insert.isUpsert()) {
            throw new ValidationException("UPSERT is not supported.");
        }
        if (insert.getTargetColumnList() != null) {
            throw new ValidationException("INSERT with target column list is not supported.");
        }
        SqlIdentifier tableIdentifier = (SqlIdentifier)insert.getTargetTable();
        if (tableIdentifier.names.isEmpty()) {
            throw new ValidationException("INSERT requires target table.");
        }
        if (tableIdentifier.names.size() == 1) {
            dataSource = (String)Iterables.getOnlyElement((Iterable)tableIdentifier.names);
        } else {
            String defaultSchemaName = (String)Iterables.getOnlyElement((Iterable)CalciteSchema.from((SchemaPlus)this.frameworkConfig.getDefaultSchema()).path(null));
            if (tableIdentifier.names.size() == 2 && defaultSchemaName.equals(tableIdentifier.names.get(0))) {
                dataSource = (String)tableIdentifier.names.get(1);
            } else {
                throw new ValidationException(StringUtils.format((String)"Cannot INSERT into [%s] because it is not a Druid datasource.", (Object[])new Object[]{tableIdentifier}));
            }
        }
        try {
            IdUtils.validateId((String)"INSERT dataSource", (String)dataSource);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(e.getMessage());
        }
        return dataSource;
    }

    private String buildSQLPlanningErrorMessage(Throwable exception) {
        String errorMessage = this.plannerContext.getPlanningError();
        if (null == errorMessage && exception instanceof UnsupportedSQLQueryException) {
            errorMessage = exception.getMessage();
        }
        errorMessage = null == errorMessage ? "Please check broker logs for more details" : "Possible error: " + errorMessage;
        return StringUtils.format((String)"Cannot build plan for query: %s. %s", (Object[])new Object[]{this.plannerContext.getSql(), errorMessage});
    }

    private static class ParsedNodes {
        @Nullable
        private final SqlExplain explain;
        @Nullable
        private final DruidSqlInsert insert;
        private final SqlNode query;
        @Nullable
        private final Granularity ingestionGranularity;

        private ParsedNodes(@Nullable SqlExplain explain, @Nullable DruidSqlInsert insert, SqlNode query, @Nullable Granularity ingestionGranularity) {
            this.explain = explain;
            this.insert = insert;
            this.query = query;
            this.ingestionGranularity = ingestionGranularity;
        }

        static ParsedNodes create(SqlNode node) throws ValidationException {
            SqlExplain explain = null;
            DruidSqlInsert druidSqlInsert = null;
            SqlNode query = node;
            Granularity ingestionGranularity = null;
            if (query.getKind() == SqlKind.EXPLAIN) {
                explain = (SqlExplain)query;
                query = explain.getExplicandum();
            }
            if (query.getKind() == SqlKind.INSERT) {
                druidSqlInsert = (DruidSqlInsert)query;
                if ((query = druidSqlInsert.getSource()) instanceof SqlOrderBy) {
                    SqlOrderBy sqlOrderBy = (SqlOrderBy)query;
                    SqlNodeList orderByList = sqlOrderBy.orderList;
                    if (orderByList != null && !orderByList.equals(SqlNodeList.EMPTY)) {
                        throw new ValidationException("Cannot have ORDER BY on an INSERT query, use CLUSTERED BY instead.");
                    }
                }
                ingestionGranularity = druidSqlInsert.getPartitionedBy();
                if (druidSqlInsert.getClusteredBy() != null) {
                    SqlNode offset = null;
                    SqlNode fetch = null;
                    if (query instanceof SqlOrderBy) {
                        SqlOrderBy sqlOrderBy = (SqlOrderBy)query;
                        query = sqlOrderBy.query;
                        offset = sqlOrderBy.offset;
                        fetch = sqlOrderBy.fetch;
                    }
                    query = new SqlOrderBy(query.getParserPosition(), query, druidSqlInsert.getClusteredBy(), offset, fetch);
                }
            }
            if (!query.isA((Set)SqlKind.QUERY)) {
                throw new ValidationException(StringUtils.format((String)"Cannot execute [%s].", (Object[])new Object[]{query.getKind()}));
            }
            return new ParsedNodes(explain, druidSqlInsert, query, ingestionGranularity);
        }

        @Nullable
        public SqlExplain getExplainNode() {
            return this.explain;
        }

        @Nullable
        public DruidSqlInsert getInsertNode() {
            return this.insert;
        }

        public SqlNode getQueryNode() {
            return this.query;
        }

        @Nullable
        public Granularity getIngestionGranularity() {
            return this.ingestionGranularity;
        }
    }

    private static class EnumeratorIterator<T>
    implements Iterator<T> {
        private final Iterator<T> it;

        EnumeratorIterator(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next();
        }
    }
}

