/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.parser;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.sql.calcite.expression.TimeUnits;
import org.apache.druid.sql.calcite.parser.ParseException;
import org.joda.time.Period;

public class DruidSqlParserUtils {
    private static final Logger log = new Logger(DruidSqlParserUtils.class);

    public static Granularity convertSqlNodeToGranularityThrowingParseExceptions(SqlNode sqlNode) throws ParseException {
        try {
            return DruidSqlParserUtils.convertSqlNodeToGranularity(sqlNode);
        }
        catch (Exception e) {
            log.debug((Throwable)e, StringUtils.format((String)"Unable to convert %s to a valid granularity.", (Object[])new Object[]{sqlNode.toString()}), new Object[0]);
            throw new ParseException(e.getMessage());
        }
    }

    public static Granularity convertSqlNodeToGranularity(SqlNode sqlNode) throws ParseException {
        String genericParseFailedMessageFormatString = "Encountered %s after PARTITIONED BY. Expected HOUR, DAY, MONTH, YEAR, ALL TIME, FLOOR function or %s function";
        if (!(sqlNode instanceof SqlCall)) {
            throw new ParseException(StringUtils.format((String)"Encountered %s after PARTITIONED BY. Expected HOUR, DAY, MONTH, YEAR, ALL TIME, FLOOR function or %s function", (Object[])new Object[]{sqlNode.toString(), "TIME_FLOOR"}));
        }
        SqlCall sqlCall = (SqlCall)sqlNode;
        String operatorName = sqlCall.getOperator().getName();
        Preconditions.checkArgument(("FLOOR".equalsIgnoreCase(operatorName) || "TIME_FLOOR".equalsIgnoreCase(operatorName) ? 1 : 0) != 0, (Object)StringUtils.format((String)"PARTITIONED BY clause only supports FLOOR(__time TO <unit> and %s(__time, period) functions", (Object[])new Object[]{"TIME_FLOOR"}));
        List operandList = sqlCall.getOperandList();
        Preconditions.checkArgument((operandList.size() == 2 ? 1 : 0) != 0, (Object)StringUtils.format((String)"%s in PARTITIONED BY clause must have two arguments", (Object[])new Object[]{operatorName}));
        SqlNode timeOperandSqlNode = (SqlNode)operandList.get(0);
        Preconditions.checkArgument((boolean)timeOperandSqlNode.getKind().equals((Object)SqlKind.IDENTIFIER), (Object)StringUtils.format((String)"First argument to %s in PARTITIONED BY clause can only be __time", (Object[])new Object[]{operatorName}));
        SqlIdentifier timeOperandSqlIdentifier = (SqlIdentifier)timeOperandSqlNode;
        Preconditions.checkArgument((boolean)timeOperandSqlIdentifier.getSimple().equals("__time"), (Object)StringUtils.format((String)"First argument to %s in PARTITIONED BY clause can only be __time", (Object[])new Object[]{operatorName}));
        if (operatorName.equalsIgnoreCase("TIME_FLOOR")) {
            Period period;
            SqlNode granularitySqlNode = (SqlNode)operandList.get(1);
            Preconditions.checkArgument((boolean)granularitySqlNode.getKind().equals((Object)SqlKind.LITERAL), (Object)"Second argument to TIME_FLOOR in PARTITIONED BY clause must be a period like 'PT1H'");
            String granularityString = SqlLiteral.unchain((SqlNode)granularitySqlNode).toValue();
            try {
                period = new Period((Object)granularityString);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(StringUtils.format((String)"%s is an invalid period string", (Object[])new Object[]{granularitySqlNode.toString()}));
            }
            return new PeriodGranularity(period, null, null);
        }
        if ("FLOOR".equalsIgnoreCase(operatorName)) {
            SqlNode granularitySqlNode = (SqlNode)operandList.get(1);
            Preconditions.checkArgument((boolean)(granularitySqlNode instanceof SqlIntervalQualifier), (Object)"Second argument to the FLOOR function in PARTITIONED BY clause is not a valid granularity. Please refer to the documentation of FLOOR function");
            SqlIntervalQualifier granularityIntervalQualifier = (SqlIntervalQualifier)granularitySqlNode;
            Period period = TimeUnits.toPeriod(granularityIntervalQualifier.timeUnitRange);
            Preconditions.checkNotNull((Object)period, (Object)StringUtils.format((String)"%s is not a valid granularity for ingestion", (Object[])new Object[]{granularityIntervalQualifier.timeUnitRange.toString()}));
            return new PeriodGranularity(period, null, null);
        }
        throw new ParseException(StringUtils.format((String)"Encountered %s after PARTITIONED BY. Expected HOUR, DAY, MONTH, YEAR, ALL TIME, FLOOR function or %s function", (Object[])new Object[]{sqlNode.toString(), "TIME_FLOOR"}));
    }
}

