/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.parser;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.sql.calcite.parser.ParseException;

public class DruidSqlInsert
extends SqlInsert {
    public static final String SQL_INSERT_SEGMENT_GRANULARITY = "sqlInsertSegmentGranularity";
    public static final SqlOperator OPERATOR = SqlInsert.OPERATOR;
    private final Granularity partitionedBy;
    private final String partitionedByStringForUnparse;
    @Nullable
    private final SqlNodeList clusteredBy;

    public DruidSqlInsert(@Nonnull SqlInsert insertNode, @Nullable Granularity partitionedBy, @Nullable String partitionedByStringForUnparse, @Nullable SqlNodeList clusteredBy) throws ParseException {
        super(insertNode.getParserPosition(), (SqlNodeList)insertNode.getOperandList().get(0), insertNode.getTargetTable(), insertNode.getSource(), insertNode.getTargetColumnList());
        if (partitionedBy == null) {
            throw new ParseException("INSERT statements must specify PARTITIONED BY clause explicitly");
        }
        this.partitionedBy = partitionedBy;
        Preconditions.checkNotNull((Object)partitionedByStringForUnparse);
        this.partitionedByStringForUnparse = partitionedByStringForUnparse;
        this.clusteredBy = clusteredBy;
    }

    @Nullable
    public SqlNodeList getClusteredBy() {
        return this.clusteredBy;
    }

    public Granularity getPartitionedBy() {
        return this.partitionedBy;
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("PARTITIONED BY");
        writer.keyword(this.partitionedByStringForUnparse);
        if (this.getClusteredBy() != null) {
            writer.keyword("CLUSTERED BY");
            SqlWriter.Frame frame = writer.startList("", "");
            for (SqlNode clusterByOpts : this.getClusteredBy().getList()) {
                clusterByOpts.unparse(writer, leftPrec, rightPrec);
            }
            writer.endList(frame);
        }
    }
}

