/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.druid.sql.calcite.external.ExternalTableScan;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidQueryRel;
import org.apache.druid.sql.calcite.run.QueryFeature;

public class ExternalTableScanRule
extends RelOptRule {
    private final PlannerContext plannerContext;

    public ExternalTableScanRule(PlannerContext plannerContext) {
        super(ExternalTableScanRule.operand(ExternalTableScan.class, (RelOptRuleOperandChildren)ExternalTableScanRule.any()));
        this.plannerContext = plannerContext;
    }

    public boolean matches(RelOptRuleCall call) {
        if (this.plannerContext.getQueryMaker().feature(QueryFeature.CAN_READ_EXTERNAL_DATA)) {
            return super.matches(call);
        }
        this.plannerContext.setPlanningError("SQL query requires scanning external datasources that is not suported.", new Object[0]);
        return false;
    }

    public void onMatch(RelOptRuleCall call) {
        ExternalTableScan scan = (ExternalTableScan)call.rel(0);
        call.transformTo((RelNode)DruidQueryRel.scanExternal(scan, this.plannerContext));
    }
}

