/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.druid.sql.calcite.table.DruidTable;

public class ExternalTableScan
extends AbstractRelNode {
    private final ObjectMapper jsonMapper;
    private final DruidTable druidTable;

    public ExternalTableScan(RelOptCluster cluster, ObjectMapper jsonMapper, DruidTable druidTable) {
        super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE));
        this.jsonMapper = jsonMapper;
        this.druidTable = druidTable;
    }

    public DruidTable getDruidTable() {
        return this.druidTable;
    }

    protected RelDataType deriveRowType() {
        return this.druidTable.getRowType(this.getCluster().getTypeFactory());
    }

    public RelWriter explainTerms(RelWriter pw) {
        String dataSourceString;
        try {
            dataSourceString = this.jsonMapper.writeValueAsString((Object)this.druidTable.getDataSource());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return pw.item("dataSource", (Object)dataSourceString);
    }
}

