/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.external.ExternalDataSource;
import org.apache.druid.sql.calcite.table.DruidTable;

public class ExternalTableMacro
implements TableMacro {
    private final ObjectMapper jsonMapper;

    @Inject
    public ExternalTableMacro(@Json ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public TranslatableTable apply(List<Object> arguments) {
        try {
            InputSource inputSource = (InputSource)this.jsonMapper.readValue((String)arguments.get(0), InputSource.class);
            InputFormat inputFormat = (InputFormat)this.jsonMapper.readValue((String)arguments.get(1), InputFormat.class);
            RowSignature signature = (RowSignature)this.jsonMapper.readValue((String)arguments.get(2), RowSignature.class);
            return new DruidTable(new ExternalDataSource(inputSource, inputFormat, signature), signature, this.jsonMapper, false, false);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public List<FunctionParameter> getParameters() {
        return ImmutableList.of((Object)new FunctionParameter(){

            public int getOrdinal() {
                return 0;
            }

            public String getName() {
                return "inputSource";
            }

            public RelDataType getType(RelDataTypeFactory typeFactory) {
                return typeFactory.createJavaType(String.class);
            }

            public boolean isOptional() {
                return false;
            }
        }, (Object)new FunctionParameter(){

            public int getOrdinal() {
                return 1;
            }

            public String getName() {
                return "inputFormat";
            }

            public RelDataType getType(RelDataTypeFactory typeFactory) {
                return typeFactory.createJavaType(String.class);
            }

            public boolean isOptional() {
                return false;
            }
        }, (Object)new FunctionParameter(){

            public int getOrdinal() {
                return 2;
            }

            public String getName() {
                return "signature";
            }

            public RelDataType getType(RelDataTypeFactory typeFactory) {
                return typeFactory.createJavaType(String.class);
            }

            public boolean isOptional() {
                return false;
            }
        });
    }
}

