/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.virtual.ListFilteredVirtualColumn;
import org.apache.druid.sql.calcite.expression.AliasedOperatorConversion;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayAppendOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayConcatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayContainsOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayLengthOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOffsetOfOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOffsetOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOrdinalOfOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOrdinalOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOverlapOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayPrependOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArraySliceOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayToStringOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.StringToArrayOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class MultiValueStringOperatorConversions {
    private MultiValueStringOperatorConversions() {
    }

    public static class FilterNone
    extends ListFilter {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_FILTER_NONE").operandTypeChecker(OperandTypes.sequence((String)"(string,array)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY})})).functionCategory(SqlFunctionCategory.STRING).returnTypeCascadeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        boolean isAllowList() {
            return false;
        }
    }

    public static class FilterOnly
    extends ListFilter {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_FILTER_ONLY").operandTypeChecker(OperandTypes.sequence((String)"(string,array)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY})})).functionCategory(SqlFunctionCategory.STRING).returnTypeCascadeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        boolean isAllowList() {
            return true;
        }
    }

    private static abstract class ListFilter
    implements SqlOperatorConversion {
        private ListFilter() {
        }

        abstract boolean isAllowList();

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            RexCall call = (RexCall)rexNode;
            List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands());
            if (druidExpressions == null || druidExpressions.size() != 2) {
                return null;
            }
            Expr expr = Parser.parse((String)druidExpressions.get(1).getExpression(), (ExprMacroTable)plannerContext.getExprMacroTable());
            if (!expr.isLiteral()) {
                return null;
            }
            String[] lit = expr.eval(InputBindings.nilBindings()).asStringArray();
            if (lit == null || lit.length == 0) {
                return null;
            }
            DruidExpression.ExpressionGenerator builder = args -> {
                StringBuilder expressionBuilder = this.isAllowList() ? new StringBuilder("filter((x) -> array_contains(") : new StringBuilder("filter((x) -> !array_contains(");
                expressionBuilder.append(((DruidExpression)args.get(1)).getExpression()).append(", x), ").append(((DruidExpression)args.get(0)).getExpression()).append(")");
                return expressionBuilder.toString();
            };
            if (druidExpressions.get(0).isSimpleExtraction()) {
                DruidExpression druidExpression = DruidExpression.ofVirtualColumn(Calcites.getColumnTypeForRelDataType(rexNode.getType()), builder, druidExpressions, (name, outputType, expression, macroTable) -> new ListFilteredVirtualColumn(name, ((DruidExpression)druidExpressions.get(0)).getSimpleExtraction().toDimensionSpec(((DruidExpression)druidExpressions.get(0)).getDirectColumn(), outputType), (Set)ImmutableSet.copyOf((Object[])lit), Boolean.valueOf(this.isAllowList())));
                if (plannerContext.getJoinExpressionVirtualColumnRegistry() != null) {
                    String virtualColumnName = plannerContext.getJoinExpressionVirtualColumnRegistry().getOrCreateVirtualColumnForExpression(druidExpression, ColumnType.STRING);
                    return DruidExpression.ofColumn(ColumnType.STRING, virtualColumnName);
                }
                return druidExpression;
            }
            return DruidExpression.ofExpression(ColumnType.STRING, builder, druidExpressions);
        }
    }

    public static class Overlap
    extends AliasedOperatorConversion {
        public Overlap() {
            super(new ArrayOverlapOperatorConversion(), "MV_OVERLAP");
        }
    }

    public static class OrdinalOf
    extends AliasedOperatorConversion {
        public OrdinalOf() {
            super(new ArrayOrdinalOfOperatorConversion(), "MV_ORDINAL_OF");
        }
    }

    public static class OffsetOf
    extends AliasedOperatorConversion {
        public OffsetOf() {
            super(new ArrayOffsetOfOperatorConversion(), "MV_OFFSET_OF");
        }
    }

    public static class Length
    extends AliasedOperatorConversion {
        public Length() {
            super(new ArrayLengthOperatorConversion(), "MV_LENGTH");
        }
    }

    public static class MultiStringToString
    extends AliasedOperatorConversion {
        public MultiStringToString() {
            super(new ArrayToStringOperatorConversion(), "MV_TO_STRING");
        }
    }

    public static class StringToMultiString
    extends StringToArrayOperatorConversion {
        public static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("STRING_TO_MV").operandTypeChecker(OperandTypes.sequence((String)"(string,expr)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }

    public static class Slice
    extends ArraySliceOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_SLICE").operandTypeChecker(OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)"(expr,start)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})}), OperandTypes.sequence((String)"(expr,start,end)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }

    public static class Ordinal
    extends ArrayOrdinalOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_ORDINAL").operandTypeChecker(OperandTypes.sequence((String)"(array,expr)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }

    public static class Offset
    extends ArrayOffsetOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_OFFSET").operandTypeChecker(OperandTypes.sequence((String)"(array,expr)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }

    public static class Contains
    extends ArrayContainsOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_CONTAINS").operandTypeChecker(OperandTypes.sequence((String)"(array,array)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})})})).returnTypeInference(ReturnTypes.BOOLEAN).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }

    public static class Concat
    extends ArrayConcatOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_CONCAT").operandTypeChecker(OperandTypes.sequence((String)"(array,array)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }

    public static class Prepend
    extends ArrayPrependOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_PREPEND").operandTypeChecker(OperandTypes.sequence((String)"(expr,array)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }

    public static class Append
    extends ArrayAppendOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_APPEND").operandTypeChecker(OperandTypes.sequence((String)"(array,expr)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }
}

