/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.expression.ExtractionFns;

public class SimpleExtraction {
    private final String column;
    @Nullable
    private final ExtractionFn extractionFn;

    public SimpleExtraction(String column, @Nullable ExtractionFn extractionFn) {
        this.column = (String)Preconditions.checkNotNull((Object)column, (Object)"column");
        this.extractionFn = extractionFn;
    }

    public static SimpleExtraction of(String column, @Nullable ExtractionFn extractionFn) {
        return new SimpleExtraction(column, extractionFn);
    }

    public String getColumn() {
        return this.column;
    }

    @Nullable
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    public SimpleExtraction cascade(ExtractionFn nextExtractionFn) {
        return new SimpleExtraction(this.column, ExtractionFns.cascade(this.extractionFn, (ExtractionFn)Preconditions.checkNotNull((Object)nextExtractionFn, (Object)"nextExtractionFn")));
    }

    public DimensionSpec toDimensionSpec(String outputName, ColumnType outputType) {
        Preconditions.checkNotNull((Object)outputType, (Object)"outputType");
        return this.extractionFn == null ? new DefaultDimensionSpec(this.column, outputName, outputType) : new ExtractionDimensionSpec(this.column, outputName, outputType, this.extractionFn);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleExtraction that = (SimpleExtraction)o;
        return this.column.equals(that.column) && Objects.equals(this.extractionFn, that.extractionFn);
    }

    public int hashCode() {
        return Objects.hash(this.column, this.extractionFn);
    }

    public String toString() {
        if (this.extractionFn != null) {
            return StringUtils.format((String)"%s(%s)", (Object[])new Object[]{this.extractionFn, this.column});
        }
        return this.column;
    }
}

