/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.builtin.SimpleSqlAggregator;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.UnsupportedSQLQueryException;

public class SumSqlAggregator
extends SimpleSqlAggregator {
    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.SUM;
    }

    @Override
    Aggregation getAggregation(String name, AggregateCall aggregateCall, ExprMacroTable macroTable, String fieldName) {
        ColumnType valueType = Calcites.getColumnTypeForRelDataType(aggregateCall.getType());
        if (valueType == null) {
            return null;
        }
        return Aggregation.create(SumSqlAggregator.createSumAggregatorFactory((ValueType)valueType.getType(), name, fieldName, macroTable));
    }

    static AggregatorFactory createSumAggregatorFactory(ValueType aggregationType, String name, String fieldName, ExprMacroTable macroTable) {
        switch (aggregationType) {
            case LONG: {
                return new LongSumAggregatorFactory(name, fieldName, null, macroTable);
            }
            case FLOAT: {
                return new FloatSumAggregatorFactory(name, fieldName, null, macroTable);
            }
            case DOUBLE: {
                return new DoubleSumAggregatorFactory(name, fieldName, null, macroTable);
            }
        }
        throw new UnsupportedSQLQueryException("Sum aggregation is not supported for '%s' type", aggregationType);
    }
}

