/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Optionality;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.UnsupportedSQLQueryException;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class StringSqlAggregator
implements SqlAggregator {
    private static final String NAME = "STRING_AGG";
    private static final SqlAggFunction FUNCTION = new StringAggFunction();

    @Override
    public SqlAggFunction calciteFunction() {
        return FUNCTION;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        List arguments = aggregateCall.getArgList().stream().map(i -> Expressions.fromFieldAccess(rowSignature, project, i)).map(rexNode -> Expressions.toDruidExpression(plannerContext, rowSignature, rexNode)).collect(Collectors.toList());
        if (arguments.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        RexNode separatorNode = Expressions.fromFieldAccess(rowSignature, project, (Integer)aggregateCall.getArgList().get(1));
        if (!separatorNode.isA(SqlKind.LITERAL)) {
            return null;
        }
        String separator = RexLiteral.stringValue((RexNode)separatorNode);
        if (separator == null) {
            return null;
        }
        Integer maxSizeBytes = null;
        if (arguments.size() > 2) {
            RexNode maxBytes = Expressions.fromFieldAccess(rowSignature, project, (Integer)aggregateCall.getArgList().get(2));
            if (!maxBytes.isA(SqlKind.LITERAL)) {
                return null;
            }
            maxSizeBytes = ((Number)((Object)RexLiteral.value((RexNode)maxBytes))).intValue();
        }
        DruidExpression arg = (DruidExpression)arguments.get(0);
        ExprMacroTable macroTable = plannerContext.getExprMacroTable();
        String initialvalue = "[]";
        ColumnType elementType = ColumnType.STRING;
        String fieldName = arg.isDirectColumnAccess() ? arg.getDirectColumn() : virtualColumnRegistry.getOrCreateVirtualColumnForExpression(arg, elementType);
        String finalizer = StringUtils.format((String)"if(array_length(o) == 0, null, array_to_string(o, '%s'))", (Object[])new Object[]{separator});
        NotDimFilter dimFilter = new NotDimFilter((DimFilter)new SelectorDimFilter(fieldName, null, null));
        if (aggregateCall.isDistinct()) {
            return Aggregation.create((AggregatorFactory)new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory(name, (Set)ImmutableSet.of((Object)fieldName), null, "[]", null, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), StringUtils.format((String)"array_set_add(\"__acc\", \"%s\")", (Object[])new Object[]{fieldName}), StringUtils.format((String)"array_set_add_all(\"__acc\", \"%s\")", (Object[])new Object[]{name}), null, finalizer, maxSizeBytes != null ? new HumanReadableBytes((long)maxSizeBytes.intValue()) : null, macroTable), (DimFilter)dimFilter));
        }
        return Aggregation.create((AggregatorFactory)new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory(name, (Set)ImmutableSet.of((Object)fieldName), null, "[]", null, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), StringUtils.format((String)"array_append(\"__acc\", \"%s\")", (Object[])new Object[]{fieldName}), StringUtils.format((String)"array_concat(\"__acc\", \"%s\")", (Object[])new Object[]{name}), null, finalizer, maxSizeBytes != null ? new HumanReadableBytes((long)maxSizeBytes.intValue()) : null, macroTable), (DimFilter)dimFilter));
    }

    private static class StringAggFunction
    extends SqlAggFunction {
        private static final StringAggReturnTypeInference RETURN_TYPE_INFERENCE = new StringAggReturnTypeInference();

        StringAggFunction() {
            super(StringSqlAggregator.NAME, null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)RETURN_TYPE_INFERENCE, InferTypes.ANY_NULLABLE, OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)StringUtils.format((String)"'%s'(expr, separator)", (Object[])new Object[]{StringSqlAggregator.NAME}), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING})}), OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)StringUtils.format((String)"'%s'(expr, separator, maxSizeBytes)", (Object[])new Object[]{StringSqlAggregator.NAME}), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.STRING, OperandTypes.POSITIVE_INTEGER_LITERAL}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC})})}), SqlFunctionCategory.STRING, false, false, Optionality.IGNORED);
        }
    }

    static class StringAggReturnTypeInference
    implements SqlReturnTypeInference {
        StringAggReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding sqlOperatorBinding) {
            RelDataType type = sqlOperatorBinding.getOperandType(0);
            if (type instanceof RowSignatures.ComplexSqlType) {
                throw new UnsupportedSQLQueryException("Cannot use STRING_AGG on complex inputs %s", type);
            }
            return Calcites.createSqlTypeWithNullability(sqlOperatorBinding.getTypeFactory(), SqlTypeName.VARCHAR, true);
        }
    }
}

