/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.builtin.SimpleSqlAggregator;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.UnsupportedSQLQueryException;

public class MinSqlAggregator
extends SimpleSqlAggregator {
    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.MIN;
    }

    @Override
    Aggregation getAggregation(String name, AggregateCall aggregateCall, ExprMacroTable macroTable, String fieldName) {
        ColumnType valueType = Calcites.getColumnTypeForRelDataType(aggregateCall.getType());
        return Aggregation.create(MinSqlAggregator.createMinAggregatorFactory(valueType, name, fieldName, macroTable));
    }

    private static AggregatorFactory createMinAggregatorFactory(ColumnType aggregationType, String name, String fieldName, ExprMacroTable macroTable) {
        switch ((ValueType)aggregationType.getType()) {
            case LONG: {
                return new LongMinAggregatorFactory(name, fieldName, null, macroTable);
            }
            case FLOAT: {
                return new FloatMinAggregatorFactory(name, fieldName, null, macroTable);
            }
            case DOUBLE: {
                return new DoubleMinAggregatorFactory(name, fieldName, null, macroTable);
            }
        }
        throw new UnsupportedSQLQueryException("MIN aggregator is not supported for '%s' type", aggregationType);
    }
}

