/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.sql.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.SqlLifecycle;
import org.apache.druid.sql.avatica.DruidMeta;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PrepareResult;

public class DruidStatement
implements Closeable {
    public static final long START_OFFSET = 0L;
    private final String connectionId;
    private final int statementId;
    private final QueryContext queryContext;
    @GuardedBy(value="lock")
    private final SqlLifecycle sqlLifecycle;
    private final Runnable onClose;
    private final Object lock = new Object();
    private final ExecutorService yielderOpenCloseExecutor;
    private State state = State.NEW;
    private String query;
    private long maxRowCount;
    private Meta.Signature signature;
    private Yielder<Object[]> yielder;
    private int offset = 0;
    private Throwable throwable;
    private AuthenticationResult authenticationResult;

    public DruidStatement(String connectionId, int statementId, QueryContext queryContext, SqlLifecycle sqlLifecycle, Runnable onClose) {
        this.connectionId = (String)Preconditions.checkNotNull((Object)connectionId, (Object)"connectionId");
        this.statementId = statementId;
        this.queryContext = queryContext;
        this.sqlLifecycle = (SqlLifecycle)Preconditions.checkNotNull((Object)sqlLifecycle, (Object)"sqlLifecycle");
        this.onClose = (Runnable)Preconditions.checkNotNull((Object)onClose, (Object)"onClose");
        this.yielderOpenCloseExecutor = Execs.singleThreaded((String)StringUtils.format((String)"JDBCYielderOpenCloseExecutor-connection-%s-statement-%d", (Object[])new Object[]{StringUtils.encodeForFormat((String)connectionId), statementId}));
    }

    public static List<ColumnMetaData> createColumnMetaData(RelDataType rowType) {
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        List fieldList = rowType.getFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            ColumnMetaData.ScalarType columnType;
            RelDataTypeField field = (RelDataTypeField)fieldList.get(i);
            if (field.getType().getSqlTypeName() == SqlTypeName.ARRAY) {
                ColumnMetaData.Rep elementRep = DruidStatement.rep(field.getType().getComponentType().getSqlTypeName());
                ColumnMetaData.ScalarType elementType = ColumnMetaData.scalar((int)field.getType().getComponentType().getSqlTypeName().getJdbcOrdinal(), (String)field.getType().getComponentType().getSqlTypeName().getName(), (ColumnMetaData.Rep)elementRep);
                ColumnMetaData.Rep arrayRep = DruidStatement.rep(field.getType().getSqlTypeName());
                columnType = ColumnMetaData.array((ColumnMetaData.AvaticaType)elementType, (String)field.getType().getSqlTypeName().getName(), (ColumnMetaData.Rep)arrayRep);
            } else {
                ColumnMetaData.Rep rep = DruidStatement.rep(field.getType().getSqlTypeName());
                columnType = ColumnMetaData.scalar((int)field.getType().getSqlTypeName().getJdbcOrdinal(), (String)field.getType().getSqlTypeName().getName(), (ColumnMetaData.Rep)rep);
            }
            columns.add(new ColumnMetaData(i, false, true, false, false, field.getType().isNullable() ? 1 : 0, true, field.getType().getPrecision(), field.getName(), null, null, field.getType().getPrecision(), field.getType().getScale(), null, null, (ColumnMetaData.AvaticaType)columnType, true, false, false, columnType.columnClassName()));
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidStatement prepare(String query, long maxRowCount, AuthenticationResult authenticationResult) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.ensure(State.NEW);
                this.sqlLifecycle.initialize(query, this.queryContext);
                this.sqlLifecycle.validateAndAuthorize(authenticationResult);
                this.authenticationResult = authenticationResult;
                PrepareResult prepareResult = this.sqlLifecycle.prepare();
                this.maxRowCount = maxRowCount;
                this.query = query;
                ArrayList<AvaticaParameter> params = new ArrayList<AvaticaParameter>();
                RelDataType parameterRowType = prepareResult.getParameterRowType();
                for (RelDataTypeField field : parameterRowType.getFieldList()) {
                    RelDataType type = field.getType();
                    params.add(this.createParameter(field, type));
                }
                this.signature = Meta.Signature.create(DruidStatement.createColumnMetaData(prepareResult.getRowType()), (String)query, params, (Meta.CursorFactory)Meta.CursorFactory.ARRAY, (Meta.StatementType)Meta.StatementType.SELECT);
                this.state = State.PREPARED;
            }
            catch (Throwable t) {
                return this.closeAndPropagateThrowable(t);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidStatement execute(List<TypedValue> parameters) {
        Object object = this.lock;
        synchronized (object) {
            this.ensure(State.PREPARED);
            try {
                this.sqlLifecycle.setParameters(parameters);
                this.sqlLifecycle.validateAndAuthorize(this.authenticationResult);
                this.sqlLifecycle.plan();
                Sequence baseSequence = this.yielderOpenCloseExecutor.submit(this.sqlLifecycle::execute).get();
                Sequence retSequence = this.maxRowCount >= 0L && this.maxRowCount <= Integer.MAX_VALUE ? baseSequence.limit((long)((int)this.maxRowCount)) : baseSequence;
                this.yielder = Yielders.each((Sequence)retSequence);
                this.state = State.RUNNING;
            }
            catch (Throwable t) {
                this.closeAndPropagateThrowable(t);
            }
            return this;
        }
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public int getStatementId() {
        return this.statementId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQuery() {
        Object object = this.lock;
        synchronized (object) {
            this.ensure(State.PREPARED, State.RUNNING, State.DONE);
            return this.query;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Meta.Signature getSignature() {
        Object object = this.lock;
        synchronized (object) {
            this.ensure(State.PREPARED, State.RUNNING, State.DONE);
            return this.signature;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentOffset() {
        Object object = this.lock;
        synchronized (object) {
            this.ensure(State.RUNNING, State.DONE);
            return this.offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == State.DONE;
        }
    }

    public Meta.Frame nextFrame(long fetchOffset, int fetchMaxRowCount) {
        Object object = this.lock;
        synchronized (object) {
            this.ensure(State.RUNNING);
            Preconditions.checkState((fetchOffset == (long)this.offset ? 1 : 0) != 0, (String)"fetchOffset[%,d] != offset[%,d]", (Object[])new Object[]{fetchOffset, this.offset});
            try {
                ArrayList<Object> rows = new ArrayList<Object>();
                while (!(this.yielder.isDone() || fetchMaxRowCount >= 0 && (long)this.offset >= fetchOffset + (long)fetchMaxRowCount)) {
                    rows.add(this.yielder.get());
                    this.yielder = this.yielder.next(null);
                    ++this.offset;
                }
                boolean done = this.yielder.isDone();
                if (done) {
                    this.close();
                }
                return new Meta.Frame(fetchOffset, done, rows);
            }
            catch (Throwable t) {
                this.throwable = t;
                try {
                    this.close();
                }
                catch (Throwable t1) {
                    t.addSuppressed(t1);
                }
                throw t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        State oldState = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                oldState = this.state;
                this.state = State.DONE;
                if (this.yielder != null) {
                    Yielder<Object[]> theYielder = this.yielder;
                    this.yielder = null;
                    this.yielderOpenCloseExecutor.submit(() -> {
                        theYielder.close();
                        return null;
                    }).get();
                    this.yielderOpenCloseExecutor.shutdownNow();
                }
            }
        }
        catch (Throwable t) {
            if (oldState != State.DONE) {
                try {
                    this.onClose.run();
                    Object theYielder = this.lock;
                    synchronized (theYielder) {
                        this.sqlLifecycle.finalizeStateAndEmitLogsAndMetrics(t, null, -1L);
                    }
                }
                catch (Throwable t1) {
                    t.addSuppressed(t1);
                }
            }
            throw new RuntimeException(t);
        }
        if (oldState != State.DONE) {
            try {
                if (!(this.throwable instanceof ForbiddenException)) {
                    Object t = this.lock;
                    synchronized (t) {
                        this.sqlLifecycle.finalizeStateAndEmitLogsAndMetrics(this.throwable, null, -1L);
                    }
                } else {
                    DruidMeta.logFailure(this.throwable);
                }
                this.onClose.run();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private AvaticaParameter createParameter(RelDataTypeField field, RelDataType type) {
        return new AvaticaParameter(false, type.getPrecision(), type.getScale(), type.getSqlTypeName().getJdbcOrdinal(), type.getSqlTypeName().getName(), Calcites.sqlTypeNameJdbcToJavaClass(type.getSqlTypeName()).getName(), field.getName());
    }

    private DruidStatement closeAndPropagateThrowable(Throwable t) {
        this.throwable = t;
        DruidMeta.logFailure(t);
        try {
            this.close();
        }
        catch (Throwable t1) {
            t.addSuppressed(t1);
        }
        throw new RuntimeException(t);
    }

    @GuardedBy(value="lock")
    private void ensure(State ... desiredStates) {
        for (State desiredState : desiredStates) {
            if (this.state != desiredState) continue;
            return;
        }
        throw new ISE("Invalid action for state[%s]", new Object[]{this.state});
    }

    private static ColumnMetaData.Rep rep(SqlTypeName sqlType) {
        if (SqlTypeName.CHAR_TYPES.contains(sqlType)) {
            return ColumnMetaData.Rep.of(String.class);
        }
        if (sqlType == SqlTypeName.TIMESTAMP) {
            return ColumnMetaData.Rep.of(Long.class);
        }
        if (sqlType == SqlTypeName.DATE) {
            return ColumnMetaData.Rep.of(Integer.class);
        }
        if (sqlType == SqlTypeName.INTEGER) {
            return ColumnMetaData.Rep.of(Number.class);
        }
        if (sqlType == SqlTypeName.BIGINT) {
            return ColumnMetaData.Rep.of(Number.class);
        }
        if (sqlType == SqlTypeName.FLOAT) {
            return ColumnMetaData.Rep.of(Float.class);
        }
        if (sqlType == SqlTypeName.DOUBLE || sqlType == SqlTypeName.DECIMAL) {
            return ColumnMetaData.Rep.of(Double.class);
        }
        if (sqlType == SqlTypeName.BOOLEAN) {
            return ColumnMetaData.Rep.of(Boolean.class);
        }
        if (sqlType == SqlTypeName.OTHER) {
            return ColumnMetaData.Rep.of(Object.class);
        }
        if (sqlType == SqlTypeName.ARRAY) {
            return ColumnMetaData.Rep.of(Array.class);
        }
        throw new ISE("No rep for SQL type[%s]", new Object[]{sqlType});
    }

    static enum State {
        NEW,
        PREPARED,
        RUNNING,
        DONE;

    }
}

