/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryContext;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.avatica.DruidMeta;
import org.apache.druid.sql.avatica.DruidStatement;

public class DruidConnection {
    private static final Logger LOG = new Logger(DruidConnection.class);
    private final String connectionId;
    private final int maxStatements;
    private final ImmutableMap<String, Object> userSecret;
    private final QueryContext context;
    private final AtomicInteger statementCounter = new AtomicInteger();
    private final AtomicReference<Future<?>> timeoutFuture = new AtomicReference();
    @GuardedBy(value="connectionLock")
    private final ConcurrentMap<Integer, DruidStatement> statements;
    private final Object connectionLock = new Object();
    @GuardedBy(value="connectionLock")
    private boolean open = true;

    public DruidConnection(String connectionId, int maxStatements, Map<String, Object> userSecret, QueryContext context) {
        this.connectionId = (String)Preconditions.checkNotNull((Object)connectionId);
        this.maxStatements = maxStatements;
        this.userSecret = ImmutableMap.copyOf(userSecret);
        this.context = context;
        this.statements = new ConcurrentHashMap<Integer, DruidStatement>();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidStatement createStatement(SqlLifecycleFactory sqlLifecycleFactory) {
        int statementId = this.statementCounter.incrementAndGet();
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.statements.containsKey(statementId)) {
                throw DruidMeta.logFailure(new ISE("Uh oh, too many statements", new Object[0]));
            }
            if (this.statements.size() >= this.maxStatements) {
                throw DruidMeta.logFailure(new ISE("Too many open statements, limit is[%,d]", new Object[]{this.maxStatements}));
            }
            DruidStatement statement = new DruidStatement(this.connectionId, statementId, this.context, sqlLifecycleFactory.factorize(), () -> {
                LOG.debug("Connection[%s] closed statement[%s].", new Object[]{this.connectionId, statementId});
                this.statements.remove(statementId);
            });
            this.statements.put(statementId, statement);
            LOG.debug("Connection[%s] opened statement[%s].", new Object[]{this.connectionId, statementId});
            return statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidStatement getStatement(int statementId) {
        Object object = this.connectionLock;
        synchronized (object) {
            return (DruidStatement)this.statements.get(statementId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeIfEmpty() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.statements.isEmpty()) {
                this.close();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.connectionLock;
        synchronized (object) {
            for (DruidStatement statement : ImmutableList.copyOf(this.statements.values())) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    LOG.warn("Connection[%s] failed to close statement[%s]!", new Object[]{this.connectionId, statement.getStatementId()});
                }
            }
            LOG.debug("Connection[%s] closed.", new Object[]{this.connectionId});
            this.open = false;
        }
    }

    public DruidConnection sync(Future<?> newTimeoutFuture) {
        Future<?> oldFuture = this.timeoutFuture.getAndSet(newTimeoutFuture);
        if (oldFuture != null) {
            oldFuture.cancel(false);
        }
        return this;
    }

    public Map<String, Object> userSecret() {
        return this.userSecret;
    }
}

