/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.inject.Inject;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.metrics.MetricsSystem;
import org.apache.calcite.avatica.remote.LocalService;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AvaticaJsonHandler;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.DruidNode;
import org.apache.druid.sql.avatica.AvaticaMonitor;
import org.apache.druid.sql.avatica.DruidMeta;
import org.eclipse.jetty.server.Request;

public class DruidAvaticaJsonHandler
extends AvaticaJsonHandler {
    public static final String AVATICA_PATH = "/druid/v2/sql/avatica/";
    public static final String AVATICA_PATH_NO_TRAILING_SLASH = "/druid/v2/sql/avatica";

    @Inject
    public DruidAvaticaJsonHandler(DruidMeta druidMeta, @Self DruidNode druidNode, AvaticaMonitor avaticaMonitor) {
        super((Service)new LocalService((Meta)druidMeta), (MetricsSystem)avaticaMonitor);
        this.setServerRpcMetadata(new Service.RpcMetadataResponse(druidNode.getHostAndPortToUse()));
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (AVATICA_PATH_NO_TRAILING_SLASH.equals(StringUtils.maybeRemoveTrailingSlash((String)request.getRequestURI()))) {
            super.handle(target, baseRequest, request, response);
        }
    }
}

