/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.query.BadQueryException;

public class SqlPlanningException
extends BadQueryException {
    public SqlPlanningException(SqlParseException e) {
        this(PlanningError.SQL_PARSE_ERROR, e.getMessage());
    }

    public SqlPlanningException(ValidationException e) {
        this(PlanningError.VALIDATION_ERROR, e.getMessage());
    }

    public SqlPlanningException(PlanningError planningError, String errorMessage) {
        this(planningError.errorCode, errorMessage, planningError.errorClass);
    }

    @JsonCreator
    private SqlPlanningException(@JsonProperty(value="error") String errorCode, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorClass") String errorClass) {
        super(errorCode, errorMessage, errorClass);
    }

    public static enum PlanningError {
        SQL_PARSE_ERROR("SQL parse failed", SqlParseException.class.getName()),
        VALIDATION_ERROR("Plan validation failed", ValidationException.class.getName()),
        UNSUPPORTED_SQL_ERROR("SQL query is unsupported", RelOptPlanner.CannotPlanException.class.getName());

        private final String errorCode;
        private final String errorClass;

        private PlanningError(String errorCode, String errorClass) {
            this.errorCode = errorCode;
            this.errorClass = errorClass;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorClass() {
            return this.errorClass;
        }
    }
}

