/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.inject.Inject;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.sql.SqlLifecycle;
import org.apache.druid.sql.calcite.planner.PlannerFactory;

@LazySingleton
public class SqlLifecycleFactory {
    private final PlannerFactory plannerFactory;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;
    private final QueryScheduler queryScheduler;
    private final AuthConfig authConfig;

    @Inject
    public SqlLifecycleFactory(PlannerFactory plannerFactory, ServiceEmitter emitter, RequestLogger requestLogger, QueryScheduler queryScheduler, AuthConfig authConfig) {
        this.plannerFactory = plannerFactory;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
        this.queryScheduler = queryScheduler;
        this.authConfig = authConfig;
    }

    public SqlLifecycle factorize() {
        return new SqlLifecycle(this.plannerFactory, this.emitter, this.requestLogger, this.queryScheduler, this.authConfig, System.currentTimeMillis(), System.nanoTime());
    }
}

