/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QueryStats;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.SqlPlanningException;
import org.apache.druid.sql.SqlRowTransformer;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.planner.PrepareResult;
import org.apache.druid.sql.calcite.planner.ValidationResult;
import org.apache.druid.sql.http.SqlParameter;
import org.apache.druid.sql.http.SqlQuery;
import org.joda.time.DateTime;

public class SqlLifecycle {
    private static final Logger log = new Logger(SqlLifecycle.class);
    private final PlannerFactory plannerFactory;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;
    private final QueryScheduler queryScheduler;
    private final AuthConfig authConfig;
    private final long startMs;
    private final long startNs;
    private final Object stateLock = new Object();
    @GuardedBy(value="stateLock")
    private State state = State.NEW;
    private String sql;
    private QueryContext queryContext;
    private List<TypedValue> parameters;
    private PlannerContext plannerContext;
    private ValidationResult validationResult;
    private PrepareResult prepareResult;
    private PlannerResult plannerResult;

    public SqlLifecycle(PlannerFactory plannerFactory, ServiceEmitter emitter, RequestLogger requestLogger, QueryScheduler queryScheduler, AuthConfig authConfig, long startMs, long startNs) {
        this.plannerFactory = plannerFactory;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
        this.queryScheduler = queryScheduler;
        this.authConfig = authConfig;
        this.startMs = startMs;
        this.startNs = startNs;
        this.parameters = Collections.emptyList();
    }

    public String initialize(String sql, QueryContext queryContext) {
        this.transition(State.NEW, State.INITIALIZED);
        this.sql = sql;
        this.queryContext = this.contextWithSqlId(queryContext);
        return this.sqlQueryId();
    }

    private QueryContext contextWithSqlId(QueryContext queryContext) {
        if (queryContext.removeUserParam("bySegment") != null) {
            log.warn("'bySegment' results are not supported for SQL queries, ignoring query context parameter", new Object[0]);
        }
        queryContext.addDefaultParam("sqlQueryId", (Object)UUID.randomUUID().toString());
        return queryContext;
    }

    private String sqlQueryId() {
        return this.queryContext.getAsString("sqlQueryId");
    }

    public void setParameters(List<TypedValue> parameters) {
        this.parameters = parameters;
        if (this.plannerContext != null) {
            this.plannerContext.setParameters(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAndAuthorize(AuthenticationResult authenticationResult) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.AUTHORIZED) {
                return;
            }
        }
        this.transition(State.INITIALIZED, State.AUTHORIZING);
        this.validate(authenticationResult);
        Access access = this.doAuthorize(AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)authenticationResult, this.validationResult.getResourceActions(), (AuthorizerMapper)this.plannerFactory.getAuthorizerMapper()));
        this.checkAccess(access);
    }

    public void validateAndAuthorize(HttpServletRequest req) {
        this.transition(State.INITIALIZED, State.AUTHORIZING);
        AuthenticationResult authResult = AuthorizationUtils.authenticationResultFromRequest((HttpServletRequest)req);
        this.validate(authResult);
        Access access = this.doAuthorize(AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)req, this.validationResult.getResourceActions(), (AuthorizerMapper)this.plannerFactory.getAuthorizerMapper()));
        this.checkAccess(access);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ValidationResult validate(AuthenticationResult authenticationResult) {
        try (DruidPlanner planner = this.plannerFactory.createPlanner(this.sql, this.queryContext);){
            this.plannerContext = planner.getPlannerContext();
            this.plannerContext.setAuthenticationResult(authenticationResult);
            this.plannerContext.setParameters(this.parameters);
            ValidationResult validationResult = this.validationResult = planner.validate(this.authConfig.authorizeQueryContextParams());
            return validationResult;
        }
        catch (SqlParseException e) {
            throw new SqlPlanningException(e);
        }
        catch (ValidationException e) {
            throw new SqlPlanningException(e);
        }
    }

    private Access doAuthorize(Access authorizationResult) {
        if (!authorizationResult.isAllowed()) {
            this.transition(State.AUTHORIZING, State.UNAUTHORIZED);
        } else {
            this.transition(State.AUTHORIZING, State.AUTHORIZED);
        }
        return authorizationResult;
    }

    private void checkAccess(Access access) {
        this.plannerContext.setAuthorizationResult(access);
        if (!access.isAllowed()) {
            throw new ForbiddenException(access.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrepareResult prepare() throws RelConversionException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != State.AUTHORIZED) {
                throw new ISE("Cannot prepare because current state[%s] is not [%s].", new Object[]{this.state, State.AUTHORIZED});
            }
        }
        Preconditions.checkNotNull((Object)this.plannerContext, (Object)"Cannot prepare, plannerContext is null");
        try (DruidPlanner planner = this.plannerFactory.createPlannerWithContext(this.plannerContext);){
            PrepareResult prepareResult = this.prepareResult = planner.prepare();
            return prepareResult;
        }
        catch (SqlParseException e) {
            throw new SqlPlanningException(e);
        }
        catch (ValidationException e) {
            throw new SqlPlanningException(e);
        }
    }

    public void plan() throws RelConversionException {
        this.transition(State.AUTHORIZED, State.PLANNED);
        Preconditions.checkNotNull((Object)this.plannerContext, (Object)"Cannot plan, plannerContext is null");
        try (DruidPlanner planner = this.plannerFactory.createPlannerWithContext(this.plannerContext);){
            this.plannerResult = planner.plan();
        }
        catch (SqlParseException e) {
            throw new SqlPlanningException(e);
        }
        catch (ValidationException e) {
            throw new SqlPlanningException(e);
        }
    }

    public SqlRowTransformer createRowTransformer() {
        assert (this.plannerContext != null);
        assert (this.plannerResult != null);
        return new SqlRowTransformer(this.plannerContext.getTimeZone(), this.plannerResult.rowType());
    }

    @VisibleForTesting
    PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    public Sequence<Object[]> execute() {
        this.transition(State.PLANNED, State.EXECUTING);
        return this.plannerResult.run();
    }

    @VisibleForTesting
    public Sequence<Object[]> runSimple(String sql, Map<String, Object> queryContext, List<SqlParameter> parameters, AuthenticationResult authenticationResult) throws RelConversionException {
        Sequence<Object[]> result;
        this.initialize(sql, new QueryContext(queryContext));
        try {
            this.setParameters(SqlQuery.getParameterList(parameters));
            this.validateAndAuthorize(authenticationResult);
            this.plan();
            result = this.execute();
        }
        catch (Throwable e) {
            if (!(e instanceof ForbiddenException)) {
                this.finalizeStateAndEmitLogsAndMetrics(e, null, -1L);
            }
            throw e;
        }
        return Sequences.wrap(result, (SequenceWrapper)new SequenceWrapper(){

            public void after(boolean isDone, Throwable thrown) {
                SqlLifecycle.this.finalizeStateAndEmitLogsAndMetrics(thrown, null, -1L);
            }
        });
    }

    @VisibleForTesting
    public ValidationResult runAnalyzeResources(AuthenticationResult authenticationResult) {
        return this.validate(authenticationResult);
    }

    public Set<ResourceAction> getRequiredResourceActions() {
        return ((ValidationResult)Preconditions.checkNotNull((Object)this.validationResult, (Object)"validationResult")).getResourceActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.CANCELLED) {
                return;
            }
            this.state = State.CANCELLED;
        }
        CopyOnWriteArrayList<String> nativeQueryIds = this.plannerContext.getNativeQueryIds();
        for (String nativeQueryId : nativeQueryIds) {
            log.debug("canceling native query [%s]", new Object[]{nativeQueryId});
            this.queryScheduler.cancelQuery(nativeQueryId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeStateAndEmitLogsAndMetrics(@Nullable Throwable e, @Nullable String remoteAddress, long bytesWritten) {
        if (this.queryContext == null) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            assert (this.state != State.UNAUTHORIZED);
            if (this.state != State.CANCELLED) {
                if (this.state == State.DONE) {
                    log.warn("Tried to emit logs and metrics twice for query[%s]!", new Object[]{this.sqlQueryId()});
                }
                this.state = State.DONE;
            }
        }
        boolean success = e == null;
        long queryTimeNs = System.nanoTime() - this.startNs;
        try {
            ServiceMetricEvent.Builder metricBuilder = ServiceMetricEvent.builder();
            if (this.plannerContext != null) {
                metricBuilder.setDimension("id", (Object)this.plannerContext.getSqlQueryId());
                metricBuilder.setDimension("nativeQueryIds", (Object)this.plannerContext.getNativeQueryIds().toString());
            }
            if (this.validationResult != null) {
                metricBuilder.setDimension("dataSource", (Object)this.validationResult.getResourceActions().stream().map(action -> action.getResource().getName()).collect(Collectors.toList()).toString());
            }
            metricBuilder.setDimension("remoteAddress", (Object)StringUtils.nullToEmptyNonDruidDataString((String)remoteAddress));
            metricBuilder.setDimension("success", (Object)String.valueOf(success));
            this.emitter.emit(metricBuilder.build("sqlQuery/time", (Number)TimeUnit.NANOSECONDS.toMillis(queryTimeNs)));
            if (bytesWritten >= 0L) {
                this.emitter.emit(metricBuilder.build("sqlQuery/bytes", (Number)bytesWritten));
            }
            LinkedHashMap<String, Object> statsMap = new LinkedHashMap<String, Object>();
            statsMap.put("sqlQuery/time", TimeUnit.NANOSECONDS.toMillis(queryTimeNs));
            statsMap.put("sqlQuery/bytes", bytesWritten);
            statsMap.put("success", success);
            if (this.plannerContext != null) {
                statsMap.put("identity", this.plannerContext.getAuthenticationResult().getIdentity());
                this.queryContext.addSystemParam("nativeQueryIds", (Object)this.plannerContext.getNativeQueryIds().toString());
            }
            Map context = this.queryContext.getMergedParams();
            statsMap.put("context", context);
            if (e != null) {
                statsMap.put("exception", e.toString());
                if (e instanceof QueryInterruptedException || e instanceof QueryTimeoutException) {
                    statsMap.put("interrupted", true);
                    statsMap.put("reason", e.toString());
                }
            }
            this.requestLogger.logSqlQuery(RequestLogLine.forSql((String)this.sql, (Map)context, (DateTime)DateTimes.utc((long)this.startMs), (String)remoteAddress, (QueryStats)new QueryStats(statsMap)));
        }
        catch (Exception ex) {
            log.error((Throwable)ex, "Unable to log SQL [%s]!", new Object[]{this.sql});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public State getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    @VisibleForTesting
    QueryContext getQueryContext() {
        return this.queryContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transition(State from, State to) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.CANCELLED) {
                throw new QueryInterruptedException("Query cancelled", StringUtils.format((String)"Query is canceled [%s]", (Object[])new Object[]{this.sqlQueryId()}), null, null);
            }
            if (this.state != from) {
                throw new ISE("Cannot transition from[%s] to[%s] because current state[%s] is not [%s].", new Object[]{from, to, this.state, from});
            }
            this.state = to;
        }
    }

    static enum State {
        NEW,
        INITIALIZED,
        AUTHORIZING,
        AUTHORIZED,
        PLANNED,
        EXECUTING,
        UNAUTHORIZED,
        CANCELLED,
        DONE;

    }
}

