/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.tools.RelConversionException;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.exception.AllowedRegexErrorResponseTransformStrategy;
import org.apache.druid.common.exception.ErrorResponseTransformStrategy;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.server.QueryLaningStrategy;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.TestRequestLogger;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.scheduling.HiLoQueryLaningStrategy;
import org.apache.druid.server.scheduling.ManualQueryPrioritizationStrategy;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.SqlLifecycle;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.SqlLifecycleManager;
import org.apache.druid.sql.SqlPlanningException;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.QueryLogHook;
import org.apache.druid.sql.calcite.util.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlParameter;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.sql.http.SqlResource;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SqlResourceTest
extends CalciteTestBase {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final String DUMMY_SQL_QUERY_ID = "dummy";
    private static final List<String> EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS = Arrays.asList("__time", "cnt", "dim1", "dim2", "dim3", "m1", "m2", "unique_dim1", "EXPR$8");
    private static final List<String> EXPECTED_TYPES_FOR_RESULT_FORMAT_TESTS = Arrays.asList("LONG", "LONG", "STRING", "STRING", "STRING", "FLOAT", "DOUBLE", "COMPLEX<hyperUnique>", "STRING");
    private static final List<String> EXPECTED_SQL_TYPES_FOR_RESULT_FORMAT_TESTS = Arrays.asList("TIMESTAMP", "BIGINT", "VARCHAR", "VARCHAR", "VARCHAR", "FLOAT", "DOUBLE", "OTHER", "VARCHAR");
    private static QueryRunnerFactoryConglomerate conglomerate;
    private static Closer resourceCloser;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public QueryLogHook queryLogHook = QueryLogHook.create();
    private SpecificSegmentsQuerySegmentWalker walker = null;
    private TestRequestLogger testRequestLogger;
    private SqlResource resource;
    private HttpServletRequest req;
    private ListeningExecutorService executorService;
    private SqlLifecycleManager lifecycleManager;
    private SqlLifecycleFactory sqlLifecycleFactory;
    private CountDownLatch lifecycleAddLatch;
    private final SettableSupplier<NonnullPair<CountDownLatch, Boolean>> validateAndAuthorizeLatchSupplier = new SettableSupplier();
    private final SettableSupplier<NonnullPair<CountDownLatch, Boolean>> planLatchSupplier = new SettableSupplier();
    private final SettableSupplier<NonnullPair<CountDownLatch, Boolean>> executeLatchSupplier = new SettableSupplier();
    private final SettableSupplier<Function<Sequence<Object[]>, Sequence<Object[]>>> sequenceMapFnSupplier = new SettableSupplier();
    private boolean sleep = false;

    @BeforeClass
    public static void setUpClass() {
        resourceCloser = Closer.create();
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)resourceCloser);
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        resourceCloser.close();
    }

    @Before
    public void setUp() throws Exception {
        QueryScheduler scheduler = new QueryScheduler(5, ManualQueryPrioritizationStrategy.INSTANCE, (QueryLaningStrategy)new HiLoQueryLaningStrategy(Integer.valueOf(40)), new ServerConfig()){

            public <T> Sequence<T> run(Query<?> query, Sequence<T> resultSequence) {
                return super.run(query, (Sequence)new LazySequence(() -> {
                    if (SqlResourceTest.this.sleep) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    return resultSequence;
                }));
            }
        };
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)8, (String)"test_sql_resource_%s"));
        this.walker = CalciteTests.createMockWalker(conglomerate, this.temporaryFolder.newFolder(), scheduler);
        PlannerConfig plannerConfig = new PlannerConfig(){

            public boolean shouldSerializeComplexValues() {
                return false;
            }
        };
        DruidSchemaCatalog rootSchema = CalciteTests.createMockRootSchema(conglomerate, this.walker, plannerConfig, CalciteTests.TEST_AUTHORIZER_MAPPER);
        DruidOperatorTable operatorTable = CalciteTests.createOperatorTable();
        ExprMacroTable macroTable = CalciteTests.createExprMacroTable();
        this.req = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        EasyMock.expect((Object)this.req.getRemoteAddr()).andReturn(null).once();
        EasyMock.expect((Object)this.req.getAttribute("Druid-Authentication-Result")).andReturn((Object)CalciteTests.REGULAR_USER_AUTH_RESULT).anyTimes();
        EasyMock.expect((Object)this.req.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.req.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.req.getAttribute("Druid-Authentication-Result")).andReturn((Object)CalciteTests.REGULAR_USER_AUTH_RESULT).anyTimes();
        this.req.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.req.getAttribute("Druid-Authentication-Result")).andReturn((Object)CalciteTests.REGULAR_USER_AUTH_RESULT).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.req});
        this.testRequestLogger = new TestRequestLogger();
        final PlannerFactory plannerFactory = new PlannerFactory(rootSchema, CalciteTests.createMockQueryMakerFactory(this.walker, conglomerate), operatorTable, macroTable, plannerConfig, CalciteTests.TEST_AUTHORIZER_MAPPER, CalciteTests.getJsonMapper(), "druid");
        this.lifecycleManager = new SqlLifecycleManager(){

            public void add(String sqlQueryId, SqlLifecycle lifecycle) {
                super.add(sqlQueryId, lifecycle);
                if (SqlResourceTest.this.lifecycleAddLatch != null) {
                    SqlResourceTest.this.lifecycleAddLatch.countDown();
                }
            }
        };
        NoopServiceEmitter emitter = new NoopServiceEmitter();
        AuthConfig authConfig = new AuthConfig();
        this.sqlLifecycleFactory = new SqlLifecycleFactory(plannerFactory, (ServiceEmitter)emitter, (RequestLogger)this.testRequestLogger, scheduler, authConfig, (ServiceEmitter)emitter, scheduler, authConfig){
            final /* synthetic */ ServiceEmitter val$emitter;
            final /* synthetic */ QueryScheduler val$scheduler;
            final /* synthetic */ AuthConfig val$authConfig;
            {
                this.val$emitter = serviceEmitter;
                this.val$scheduler = queryScheduler;
                this.val$authConfig = authConfig;
                super(x0, x1, x2, x3, x4);
            }

            public SqlLifecycle factorize() {
                return new TestSqlLifecycle(plannerFactory, this.val$emitter, (RequestLogger)SqlResourceTest.this.testRequestLogger, this.val$scheduler, this.val$authConfig, System.currentTimeMillis(), System.nanoTime(), SqlResourceTest.this.validateAndAuthorizeLatchSupplier, SqlResourceTest.this.planLatchSupplier, SqlResourceTest.this.executeLatchSupplier, SqlResourceTest.this.sequenceMapFnSupplier);
            }
        };
        this.resource = new SqlResource(JSON_MAPPER, CalciteTests.TEST_AUTHORIZER_MAPPER, this.sqlLifecycleFactory, this.lifecycleManager, new ServerConfig());
    }

    @After
    public void tearDown() throws Exception {
        this.walker.close();
        this.walker = null;
        this.executorService.shutdownNow();
        this.executorService.awaitTermination(2L, TimeUnit.SECONDS);
    }

    @Test
    public void testUnauthorized() throws Exception {
        HttpServletRequest testRequest = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        EasyMock.expect((Object)testRequest.getRemoteAddr()).andReturn(null).once();
        EasyMock.expect((Object)testRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)CalciteTests.REGULAR_USER_AUTH_RESULT).anyTimes();
        EasyMock.expect((Object)testRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)testRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)testRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)CalciteTests.REGULAR_USER_AUTH_RESULT).anyTimes();
        testRequest.setAttribute("Druid-Authorization-Checked", (Object)false);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{testRequest});
        try {
            this.resource.doPost(SqlResourceTest.createSimpleQueryWithId("id", "select count(*) from forbiddenDatasource"), testRequest);
            Assert.fail((String)"doPost did not throw ForbiddenException for an unauthorized query");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testCountStar() throws Exception {
        List rows = (List)this.doPost((SqlQuery)SqlResourceTest.createSimpleQueryWithId((String)"id", (String)"SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.foo")).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6, (Object)"TheFoo", (Object)"foo")), (Object)rows);
        this.checkSqlRequestLog(true);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testCountStarExtendedCharacters() throws Exception {
        List rows = (List)this.doPost((SqlQuery)SqlResourceTest.createSimpleQueryWithId((String)"id", (String)"SELECT COUNT(*) AS cnt FROM druid.lotsocolumns WHERE dimMultivalEnumerated = '\u3151 \u3153 \u3155 \u3157 \u315b \u315c \u3160 \u3161 \u3163'")).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)1)), (Object)rows);
        this.checkSqlRequestLog(true);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testTimestampsInResponse() throws Exception {
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"SELECT __time, CAST(__time AS DATE) AS t2 FROM druid.foo LIMIT 1", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, null, null)).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"__time", (Object)"2000-01-01T00:00:00.000Z", (Object)"t2", (Object)"2000-01-01T00:00:00.000Z")), (Object)rows);
    }

    @Test
    public void testTimestampsInResponseWithParameterizedLimit() throws Exception {
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"SELECT __time, CAST(__time AS DATE) AS t2 FROM druid.foo LIMIT ?", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, null, (List)ImmutableList.of((Object)new SqlParameter((SqlType)SqlType.INTEGER, (Object)Integer.valueOf((int)1))))).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"__time", (Object)"2000-01-01T00:00:00.000Z", (Object)"t2", (Object)"2000-01-01T00:00:00.000Z")), (Object)rows);
    }

    @Test
    public void testTimestampsInResponseLosAngelesTimeZone() throws Exception {
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"SELECT __time, CAST(__time AS DATE) AS t2 FROM druid.foo LIMIT 1", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, (Map)ImmutableMap.of((Object)"sqlTimeZone", (Object)"America/Los_Angeles"), null)).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"__time", (Object)"1999-12-31T16:00:00.000-08:00", (Object)"t2", (Object)"1999-12-31T00:00:00.000-08:00")), (Object)rows);
    }

    @Test
    public void testTimestampsInResponseWithNulls() throws Exception {
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"SELECT MAX(__time) as t1, MAX(__time) FILTER(WHERE dim1 = 'non_existing') as t2 FROM druid.foo", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, null, null)).rhs;
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)ImmutableMap.of((Object)"t1", (Object)"2001-01-03T00:00:00.000Z", (Object)"t2", (Object)"-292275055-05-16T16:47:04.192Z")) : ImmutableList.of((Object)Maps.transformValues((Map)ImmutableMap.of((Object)"t1", (Object)"2001-01-03T00:00:00.000Z", (Object)"t2", (Object)""), val -> "".equals(val) ? null : val))), (Object)rows);
    }

    @Test
    public void testFieldAliasingSelect() throws Exception {
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"SELECT dim2 \"x\", dim2 \"y\" FROM druid.foo LIMIT 1", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, null, null)).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"x", (Object)"a", (Object)"y", (Object)"a")), (Object)rows);
    }

    @Test
    public void testFieldAliasingGroupBy() throws Exception {
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"SELECT dim2 \"x\", dim2 \"y\" FROM druid.foo GROUP BY dim2", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, null, null)).rhs;
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)ImmutableMap.of((Object)"x", (Object)"", (Object)"y", (Object)""), (Object)ImmutableMap.of((Object)"x", (Object)"a", (Object)"y", (Object)"a"), (Object)ImmutableMap.of((Object)"x", (Object)"abc", (Object)"y", (Object)"abc")) : ImmutableList.of((Object)Maps.transformValues((Map)ImmutableMap.of((Object)"x", (Object)"", (Object)"y", (Object)""), val -> null), (Object)ImmutableMap.of((Object)"x", (Object)"", (Object)"y", (Object)""), (Object)ImmutableMap.of((Object)"x", (Object)"a", (Object)"y", (Object)"a"), (Object)ImmutableMap.of((Object)"x", (Object)"abc", (Object)"y", (Object)"abc"))), (Object)rows);
    }

    @Test
    public void testArrayResultFormat() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        String nullStr = NullHandling.replaceWithDefault() ? "" : null;
        Assert.assertEquals((Object)ImmutableList.of(Arrays.asList("2000-01-01T00:00:00.000Z", 1, "", "a", "[\"a\",\"b\"]", 1.0, 1.0, "org.apache.druid.hll.VersionOneHyperLogLogCollector", nullStr), Arrays.asList("2000-01-02T00:00:00.000Z", 1, "10.1", nullStr, "[\"b\",\"c\"]", 2.0, 2.0, "org.apache.druid.hll.VersionOneHyperLogLogCollector", nullStr)), (Object)this.doPost((SqlQuery)new SqlQuery((String)"SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", (ResultFormat)ResultFormat.ARRAY, (boolean)false, (boolean)false, (boolean)false, null, null), new TypeReference<List<List<Object>>>(){}).rhs);
    }

    @Test
    public void testArrayResultFormatWithErrorAfterFirstRow() throws Exception {
        this.sequenceMapFnSupplier.set(SqlResourceTest.errorAfterSecondRowMapFn());
        String query = "SELECT cnt FROM foo";
        Pair<QueryException, String> response = this.doPostRaw(new SqlQuery("SELECT cnt FROM foo", ResultFormat.ARRAY, false, false, false, null, null), this.req);
        Assert.assertNull((Object)response.lhs);
        Assert.assertEquals((Object)"[[1],[1]", (Object)response.rhs);
    }

    @Test
    public void testObjectResultFormatWithErrorAfterFirstRow() throws Exception {
        this.sequenceMapFnSupplier.set(SqlResourceTest.errorAfterSecondRowMapFn());
        String query = "SELECT cnt FROM foo";
        Pair<QueryException, String> response = this.doPostRaw(new SqlQuery("SELECT cnt FROM foo", ResultFormat.OBJECT, false, false, false, null, null), this.req);
        Assert.assertNull((Object)response.lhs);
        Assert.assertEquals((Object)"[{\"cnt\":1},{\"cnt\":1}", (Object)response.rhs);
    }

    @Test
    public void testArrayLinesResultFormatWithErrorAfterFirstRow() throws Exception {
        this.sequenceMapFnSupplier.set(SqlResourceTest.errorAfterSecondRowMapFn());
        String query = "SELECT cnt FROM foo";
        Pair<QueryException, String> response = this.doPostRaw(new SqlQuery("SELECT cnt FROM foo", ResultFormat.ARRAYLINES, false, false, false, null, null), this.req);
        Assert.assertNull((Object)response.lhs);
        Assert.assertEquals((Object)"[1]\n[1]", (Object)response.rhs);
    }

    @Test
    public void testObjectLinesResultFormatWithErrorAfterFirstRow() throws Exception {
        this.sequenceMapFnSupplier.set(SqlResourceTest.errorAfterSecondRowMapFn());
        String query = "SELECT cnt FROM foo";
        Pair<QueryException, String> response = this.doPostRaw(new SqlQuery("SELECT cnt FROM foo", ResultFormat.OBJECTLINES, false, false, false, null, null), this.req);
        Assert.assertNull((Object)response.lhs);
        Assert.assertEquals((Object)"{\"cnt\":1}\n{\"cnt\":1}", (Object)response.rhs);
    }

    @Test
    public void testCsvResultFormatWithErrorAfterFirstRow() throws Exception {
        this.sequenceMapFnSupplier.set(SqlResourceTest.errorAfterSecondRowMapFn());
        String query = "SELECT cnt FROM foo";
        Pair<QueryException, String> response = this.doPostRaw(new SqlQuery("SELECT cnt FROM foo", ResultFormat.CSV, false, false, false, null, null), this.req);
        Assert.assertNull((Object)response.lhs);
        Assert.assertEquals((Object)"1\n1\n", (Object)response.rhs);
    }

    @Test
    public void testArrayResultFormatWithHeader() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        String nullStr = NullHandling.replaceWithDefault() ? "" : null;
        Assert.assertEquals((Object)ImmutableList.of(EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS, EXPECTED_TYPES_FOR_RESULT_FORMAT_TESTS, EXPECTED_SQL_TYPES_FOR_RESULT_FORMAT_TESTS, Arrays.asList("2000-01-01T00:00:00.000Z", 1, "", "a", "[\"a\",\"b\"]", 1.0, 1.0, "org.apache.druid.hll.VersionOneHyperLogLogCollector", nullStr), Arrays.asList("2000-01-02T00:00:00.000Z", 1, "10.1", nullStr, "[\"b\",\"c\"]", 2.0, 2.0, "org.apache.druid.hll.VersionOneHyperLogLogCollector", nullStr)), (Object)this.doPost((SqlQuery)new SqlQuery((String)"SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", (ResultFormat)ResultFormat.ARRAY, (boolean)true, (boolean)true, (boolean)true, null, null), new TypeReference<List<List<Object>>>(){}).rhs);
    }

    @Test
    public void testArrayResultFormatWithHeader_nullColumnType() throws Exception {
        String query = "SELECT (1, 2)";
        Assert.assertEquals((Object)ImmutableList.of(Collections.singletonList("EXPR$0"), Collections.singletonList(null), Collections.singletonList("ROW"), Collections.singletonList(Arrays.asList(1, 2))), (Object)this.doPost((SqlQuery)new SqlQuery((String)"SELECT (1, 2)", (ResultFormat)ResultFormat.ARRAY, (boolean)true, (boolean)true, (boolean)true, null, null), new TypeReference<List<List<Object>>>(){}).rhs);
    }

    @Test
    public void testArrayLinesResultFormat() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<QueryException, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.ARRAYLINES, false, false, false, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        String nullStr = NullHandling.replaceWithDefault() ? "" : null;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((long)4L, (long)lines.size());
        Assert.assertEquals(Arrays.asList("2000-01-01T00:00:00.000Z", 1, "", "a", "[\"a\",\"b\"]", 1.0, 1.0, "org.apache.druid.hll.VersionOneHyperLogLogCollector", nullStr), (Object)JSON_MAPPER.readValue((String)lines.get(0), List.class));
        Assert.assertEquals(Arrays.asList("2000-01-02T00:00:00.000Z", 1, "10.1", nullStr, "[\"b\",\"c\"]", 2.0, 2.0, "org.apache.druid.hll.VersionOneHyperLogLogCollector", nullStr), (Object)JSON_MAPPER.readValue((String)lines.get(1), List.class));
        Assert.assertEquals((Object)"", lines.get(2));
        Assert.assertEquals((Object)"", lines.get(3));
    }

    @Test
    public void testArrayLinesResultFormatWithHeader() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<QueryException, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.ARRAYLINES, true, true, true, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        String nullStr = NullHandling.replaceWithDefault() ? "" : null;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((long)7L, (long)lines.size());
        Assert.assertEquals(EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS, (Object)JSON_MAPPER.readValue((String)lines.get(0), List.class));
        Assert.assertEquals(EXPECTED_TYPES_FOR_RESULT_FORMAT_TESTS, (Object)JSON_MAPPER.readValue((String)lines.get(1), List.class));
        Assert.assertEquals(EXPECTED_SQL_TYPES_FOR_RESULT_FORMAT_TESTS, (Object)JSON_MAPPER.readValue((String)lines.get(2), List.class));
        Assert.assertEquals(Arrays.asList("2000-01-01T00:00:00.000Z", 1, "", "a", "[\"a\",\"b\"]", 1.0, 1.0, "org.apache.druid.hll.VersionOneHyperLogLogCollector", nullStr), (Object)JSON_MAPPER.readValue((String)lines.get(3), List.class));
        Assert.assertEquals(Arrays.asList("2000-01-02T00:00:00.000Z", 1, "10.1", nullStr, "[\"b\",\"c\"]", 2.0, 2.0, "org.apache.druid.hll.VersionOneHyperLogLogCollector", nullStr), (Object)JSON_MAPPER.readValue((String)lines.get(4), List.class));
        Assert.assertEquals((Object)"", lines.get(5));
        Assert.assertEquals((Object)"", lines.get(6));
    }

    @Test
    public void testArrayLinesResultFormatWithHeader_nullColumnType() throws Exception {
        String query = "SELECT (1, 2)";
        Pair<QueryException, String> pair = this.doPostRaw(new SqlQuery("SELECT (1, 2)", ResultFormat.ARRAYLINES, true, true, true, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((long)6L, (long)lines.size());
        Assert.assertEquals(Collections.singletonList("EXPR$0"), (Object)JSON_MAPPER.readValue((String)lines.get(0), List.class));
        Assert.assertEquals(Collections.singletonList(null), (Object)JSON_MAPPER.readValue((String)lines.get(1), List.class));
        Assert.assertEquals(Collections.singletonList("ROW"), (Object)JSON_MAPPER.readValue((String)lines.get(2), List.class));
        Assert.assertEquals(Collections.singletonList(Arrays.asList(1, 2)), (Object)JSON_MAPPER.readValue((String)lines.get(3), List.class));
        Assert.assertEquals((Object)"", lines.get(4));
        Assert.assertEquals((Object)"", lines.get(5));
    }

    @Test
    public void testObjectResultFormat() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo  LIMIT 2";
        String nullStr = NullHandling.replaceWithDefault() ? "" : null;
        Function<Map, Map> transformer = m -> Maps.transformEntries((Map)m, (k, v) -> "EXPR$8".equals(k) || "dim2".equals(k) && v.toString().isEmpty() ? nullStr : v);
        Assert.assertEquals(ImmutableList.of((Object)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-01T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"").put((Object)"dim2", (Object)"a").put((Object)"dim3", (Object)"[\"a\",\"b\"]").put((Object)"m1", (Object)1.0).put((Object)"m2", (Object)1.0).put((Object)"unique_dim1", (Object)"org.apache.druid.hll.VersionOneHyperLogLogCollector").put((Object)"EXPR$8", (Object)"").build(), (Object)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-02T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"10.1").put((Object)"dim2", (Object)"").put((Object)"dim3", (Object)"[\"b\",\"c\"]").put((Object)"m1", (Object)2.0).put((Object)"m2", (Object)2.0).put((Object)"unique_dim1", (Object)"org.apache.druid.hll.VersionOneHyperLogLogCollector").put((Object)"EXPR$8", (Object)"").build()).stream().map(transformer).collect(Collectors.toList()), (Object)this.doPost((SqlQuery)new SqlQuery((String)"SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo  LIMIT 2", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, null, null), new TypeReference<List<Map<String, Object>>>(){}).rhs);
    }

    @Test
    public void testObjectLinesResultFormat() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<QueryException, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.OBJECTLINES, false, false, false, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        String nullStr = NullHandling.replaceWithDefault() ? "" : null;
        Function<Map, Map> transformer = m -> Maps.transformEntries((Map)m, (k, v) -> "EXPR$8".equals(k) || "dim2".equals(k) && v.toString().isEmpty() ? nullStr : v);
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((long)4L, (long)lines.size());
        Assert.assertEquals((Object)transformer.apply((Map)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-01T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"").put((Object)"dim2", (Object)"a").put((Object)"dim3", (Object)"[\"a\",\"b\"]").put((Object)"m1", (Object)1.0).put((Object)"m2", (Object)1.0).put((Object)"unique_dim1", (Object)"org.apache.druid.hll.VersionOneHyperLogLogCollector").put((Object)"EXPR$8", (Object)"").build()), (Object)JSON_MAPPER.readValue((String)lines.get(0), Object.class));
        Assert.assertEquals((Object)transformer.apply((Map)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-02T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"10.1").put((Object)"dim2", (Object)"").put((Object)"dim3", (Object)"[\"b\",\"c\"]").put((Object)"m1", (Object)2.0).put((Object)"m2", (Object)2.0).put((Object)"unique_dim1", (Object)"org.apache.druid.hll.VersionOneHyperLogLogCollector").put((Object)"EXPR$8", (Object)"").build()), (Object)JSON_MAPPER.readValue((String)lines.get(1), Object.class));
        Assert.assertEquals((Object)"", lines.get(2));
        Assert.assertEquals((Object)"", lines.get(3));
    }

    @Test
    public void testObjectLinesResultFormatWithMinimalHeader() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<QueryException, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.OBJECTLINES, true, false, false, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        String nullStr = NullHandling.replaceWithDefault() ? "" : null;
        Function<Map, Map> transformer = m -> Maps.transformEntries((Map)m, (k, v) -> "EXPR$8".equals(k) || "dim2".equals(k) && v.toString().isEmpty() ? nullStr : v);
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        HashMap<String, Object> expectedHeader = new HashMap<String, Object>();
        for (String column : EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS) {
            expectedHeader.put(column, null);
        }
        Assert.assertEquals((long)5L, (long)lines.size());
        Assert.assertEquals(expectedHeader, (Object)JSON_MAPPER.readValue((String)lines.get(0), Object.class));
        Assert.assertEquals((Object)transformer.apply((Map)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-01T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"").put((Object)"dim2", (Object)"a").put((Object)"dim3", (Object)"[\"a\",\"b\"]").put((Object)"m1", (Object)1.0).put((Object)"m2", (Object)1.0).put((Object)"unique_dim1", (Object)"org.apache.druid.hll.VersionOneHyperLogLogCollector").put((Object)"EXPR$8", (Object)"").build()), (Object)JSON_MAPPER.readValue((String)lines.get(1), Object.class));
        Assert.assertEquals((Object)transformer.apply((Map)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-02T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"10.1").put((Object)"dim2", (Object)"").put((Object)"dim3", (Object)"[\"b\",\"c\"]").put((Object)"m1", (Object)2.0).put((Object)"m2", (Object)2.0).put((Object)"unique_dim1", (Object)"org.apache.druid.hll.VersionOneHyperLogLogCollector").put((Object)"EXPR$8", (Object)"").build()), (Object)JSON_MAPPER.readValue((String)lines.get(2), Object.class));
        Assert.assertEquals((Object)"", lines.get(3));
        Assert.assertEquals((Object)"", lines.get(4));
    }

    @Test
    public void testObjectLinesResultFormatWithFullHeader() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<QueryException, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.OBJECTLINES, true, true, true, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        String nullStr = NullHandling.replaceWithDefault() ? "" : null;
        Function<Map, Map> transformer = m -> Maps.transformEntries((Map)m, (k, v) -> "EXPR$8".equals(k) || "dim2".equals(k) && v.toString().isEmpty() ? nullStr : v);
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        HashMap<String, ImmutableMap> expectedHeader = new HashMap<String, ImmutableMap>();
        for (int i = 0; i < EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS.size(); ++i) {
            expectedHeader.put(EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS.get(i), ImmutableMap.of((Object)"type", (Object)EXPECTED_TYPES_FOR_RESULT_FORMAT_TESTS.get(i), (Object)"sqlType", (Object)EXPECTED_SQL_TYPES_FOR_RESULT_FORMAT_TESTS.get(i)));
        }
        Assert.assertEquals((long)5L, (long)lines.size());
        Assert.assertEquals(expectedHeader, (Object)JSON_MAPPER.readValue((String)lines.get(0), Object.class));
        Assert.assertEquals((Object)transformer.apply((Map)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-01T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"").put((Object)"dim2", (Object)"a").put((Object)"dim3", (Object)"[\"a\",\"b\"]").put((Object)"m1", (Object)1.0).put((Object)"m2", (Object)1.0).put((Object)"unique_dim1", (Object)"org.apache.druid.hll.VersionOneHyperLogLogCollector").put((Object)"EXPR$8", (Object)"").build()), (Object)JSON_MAPPER.readValue((String)lines.get(1), Object.class));
        Assert.assertEquals((Object)transformer.apply((Map)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-02T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"10.1").put((Object)"dim2", (Object)"").put((Object)"dim3", (Object)"[\"b\",\"c\"]").put((Object)"m1", (Object)2.0).put((Object)"m2", (Object)2.0).put((Object)"unique_dim1", (Object)"org.apache.druid.hll.VersionOneHyperLogLogCollector").put((Object)"EXPR$8", (Object)"").build()), (Object)JSON_MAPPER.readValue((String)lines.get(2), Object.class));
        Assert.assertEquals((Object)"", lines.get(3));
        Assert.assertEquals((Object)"", lines.get(4));
    }

    @Test
    public void testObjectLinesResultFormatWithFullHeader_nullColumnType() throws Exception {
        String query = "SELECT (1, 2)";
        Pair<QueryException, String> pair = this.doPostRaw(new SqlQuery("SELECT (1, 2)", ResultFormat.OBJECTLINES, true, true, true, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("type", null);
        typeMap.put("sqlType", "ROW");
        ImmutableMap expectedHeader = ImmutableMap.of((Object)"EXPR$0", typeMap);
        Assert.assertEquals((long)4L, (long)lines.size());
        Assert.assertEquals((Object)expectedHeader, (Object)JSON_MAPPER.readValue((String)lines.get(0), Object.class));
        Assert.assertEquals((Object)ImmutableMap.builder().put((Object)"EXPR$0", Arrays.asList(1, 2)).build(), (Object)JSON_MAPPER.readValue((String)lines.get(1), Object.class));
        Assert.assertEquals((Object)"", lines.get(2));
        Assert.assertEquals((Object)"", lines.get(3));
    }

    @Test
    public void testCsvResultFormat() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<QueryException, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.CSV, false, false, false, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((Object)ImmutableList.of((Object)"2000-01-01T00:00:00.000Z,1,,a,\"[\"\"a\"\",\"\"b\"\"]\",1.0,1.0,org.apache.druid.hll.VersionOneHyperLogLogCollector,", (Object)"2000-01-02T00:00:00.000Z,1,10.1,,\"[\"\"b\"\",\"\"c\"\"]\",2.0,2.0,org.apache.druid.hll.VersionOneHyperLogLogCollector,", (Object)"", (Object)""), (Object)lines);
    }

    @Test
    public void testCsvResultFormatWithHeaders() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<QueryException, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.CSV, true, true, true, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((Object)ImmutableList.of((Object)String.join((CharSequence)",", EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS), (Object)String.join((CharSequence)",", EXPECTED_TYPES_FOR_RESULT_FORMAT_TESTS), (Object)String.join((CharSequence)",", EXPECTED_SQL_TYPES_FOR_RESULT_FORMAT_TESTS), (Object)"2000-01-01T00:00:00.000Z,1,,a,\"[\"\"a\"\",\"\"b\"\"]\",1.0,1.0,org.apache.druid.hll.VersionOneHyperLogLogCollector,", (Object)"2000-01-02T00:00:00.000Z,1,10.1,,\"[\"\"b\"\",\"\"c\"\"]\",2.0,2.0,org.apache.druid.hll.VersionOneHyperLogLogCollector,", (Object)"", (Object)""), (Object)lines);
    }

    @Test
    public void testCsvResultFormatWithHeaders_nullColumnType() throws Exception {
        String query = "SELECT (1, 2)";
        Pair<QueryException, String> pair = this.doPostRaw(new SqlQuery("SELECT (1, 2)", ResultFormat.CSV, true, true, true, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((Object)ImmutableList.of((Object)"EXPR$0", (Object)"", (Object)"ROW"), lines.subList(0, 3));
    }

    @Test
    public void testExplainCountStar() throws Exception {
        ImmutableMap queryContext = ImmutableMap.of((Object)"sqlQueryId", (Object)DUMMY_SQL_QUERY_ID);
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"EXPLAIN PLAN FOR SELECT COUNT(*) AS cnt FROM druid.foo", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, (Map)queryContext, null)).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"PLAN", (Object)StringUtils.format((String)"DruidQueryRel(query=[{\"queryType\":\"timeseries\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"descending\":false,\"virtualColumns\":[],\"filter\":null,\"granularity\":{\"type\":\"all\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"postAggregations\":[],\"limit\":2147483647,\"context\":{\"sqlQueryId\":\"%s\"}}], signature=[{a0:LONG}])\n", (Object[])new Object[]{DUMMY_SQL_QUERY_ID}), (Object)"RESOURCES", (Object)"[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]")), (Object)rows);
    }

    @Test
    public void testCannotParse() throws Exception {
        QueryException exception = (QueryException)this.doPost((SqlQuery)SqlResourceTest.createSimpleQueryWithId((String)"id", (String)"FROM druid.foo")).lhs;
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)SqlPlanningException.PlanningError.SQL_PARSE_ERROR.getErrorCode(), (Object)exception.getErrorCode());
        Assert.assertEquals((Object)SqlPlanningException.PlanningError.SQL_PARSE_ERROR.getErrorClass(), (Object)exception.getErrorClass());
        Assert.assertTrue((boolean)exception.getMessage().contains("Encountered \"FROM\" at line 1, column 1."));
        this.checkSqlRequestLog(false);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testCannotValidate() throws Exception {
        QueryException exception = (QueryException)this.doPost((SqlQuery)SqlResourceTest.createSimpleQueryWithId((String)"id", (String)"SELECT dim4 FROM druid.foo")).lhs;
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorCode(), (Object)exception.getErrorCode());
        Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorClass(), (Object)exception.getErrorClass());
        Assert.assertTrue((boolean)exception.getMessage().contains("Column 'dim4' not found in any table"));
        this.checkSqlRequestLog(false);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testCannotConvert() throws Exception {
        QueryException exception = (QueryException)this.doPost((SqlQuery)SqlResourceTest.createSimpleQueryWithId((String)"id", (String)"SELECT dim1 FROM druid.foo ORDER BY dim1")).lhs;
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)SqlPlanningException.PlanningError.UNSUPPORTED_SQL_ERROR.getErrorCode(), (Object)exception.getErrorCode());
        Assert.assertEquals((Object)SqlPlanningException.PlanningError.UNSUPPORTED_SQL_ERROR.getErrorClass(), (Object)exception.getErrorClass());
        Assert.assertTrue((boolean)exception.getMessage().contains("Cannot build plan for query: SELECT dim1 FROM druid.foo ORDER BY dim1. Possible error: SQL query requires order by non-time column [dim1 ASC] that is not supported."));
        this.checkSqlRequestLog(false);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testCannotConvert_UnsupportedSQLQueryException() throws Exception {
        QueryException exception = (QueryException)this.doPost((SqlQuery)SqlResourceTest.createSimpleQueryWithId((String)"id", (String)"SELECT max(dim1) FROM druid.foo")).lhs;
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)SqlPlanningException.PlanningError.UNSUPPORTED_SQL_ERROR.getErrorCode(), (Object)exception.getErrorCode());
        Assert.assertEquals((Object)SqlPlanningException.PlanningError.UNSUPPORTED_SQL_ERROR.getErrorClass(), (Object)exception.getErrorClass());
        Assert.assertTrue((boolean)exception.getMessage().contains("Cannot build plan for query: SELECT max(dim1) FROM druid.foo. Possible error: Max aggregation is not supported for 'STRING' type"));
        this.checkSqlRequestLog(false);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testResourceLimitExceeded() throws Exception {
        QueryException exception = (QueryException)this.doPost((SqlQuery)new SqlQuery((String)"SELECT DISTINCT dim1 FROM foo", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, (Map)ImmutableMap.of((Object)"maxMergingDictionarySize", (Object)Integer.valueOf((int)1), (Object)"sqlQueryId", (Object)"id"), null)).lhs;
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)exception.getErrorCode(), (Object)"Resource limit exceeded");
        Assert.assertEquals((Object)exception.getErrorClass(), (Object)ResourceLimitExceededException.class.getName());
        this.checkSqlRequestLog(false);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testUnsupportedQueryThrowsException() throws Exception {
        String errorMessage = "This will be support in Druid 9999";
        SqlQuery badQuery = (SqlQuery)EasyMock.createMock(SqlQuery.class);
        EasyMock.expect((Object)badQuery.getQuery()).andReturn((Object)"SELECT ANSWER TO LIFE");
        EasyMock.expect((Object)badQuery.getContext()).andReturn((Object)ImmutableMap.of((Object)"sqlQueryId", (Object)"id"));
        EasyMock.expect((Object)badQuery.getParameterList()).andThrow((Throwable)new QueryUnsupportedException(errorMessage));
        EasyMock.replay((Object[])new Object[]{badQuery});
        QueryException exception = (QueryException)this.doPost((SqlQuery)badQuery).lhs;
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)"Unsupported query", (Object)exception.getErrorCode());
        Assert.assertEquals((Object)QueryUnsupportedException.class.getName(), (Object)exception.getErrorClass());
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testErrorResponseReturnSameQueryIdWhenSetInContext() throws Exception {
        String queryId = "id123";
        String errorMessage = "This will be support in Druid 9999";
        SqlQuery badQuery = (SqlQuery)EasyMock.createMock(SqlQuery.class);
        EasyMock.expect((Object)badQuery.getQuery()).andReturn((Object)"SELECT ANSWER TO LIFE");
        EasyMock.expect((Object)badQuery.getContext()).andReturn((Object)ImmutableMap.of((Object)"sqlQueryId", (Object)queryId));
        EasyMock.expect((Object)badQuery.getParameterList()).andThrow((Throwable)new QueryUnsupportedException(errorMessage));
        EasyMock.replay((Object[])new Object[]{badQuery});
        Response response = this.resource.doPost(badQuery, this.req);
        Assert.assertNotEquals((long)200L, (long)response.getStatus());
        MultivaluedMap headers = response.getMetadata();
        Assert.assertTrue((boolean)headers.containsKey((Object)"X-Druid-SQL-Query-Id"));
        Assert.assertEquals((long)1L, (long)((List)headers.get((Object)"X-Druid-SQL-Query-Id")).size());
        Assert.assertEquals((Object)queryId, ((List)headers.get((Object)"X-Druid-SQL-Query-Id")).get(0));
    }

    @Test
    public void testErrorResponseReturnNewQueryIdWhenNotSetInContext() throws Exception {
        String errorMessage = "This will be support in Druid 9999";
        SqlQuery badQuery = (SqlQuery)EasyMock.createMock(SqlQuery.class);
        EasyMock.expect((Object)badQuery.getQuery()).andReturn((Object)"SELECT ANSWER TO LIFE");
        EasyMock.expect((Object)badQuery.getContext()).andReturn((Object)ImmutableMap.of());
        EasyMock.expect((Object)badQuery.getParameterList()).andThrow((Throwable)new QueryUnsupportedException(errorMessage));
        EasyMock.replay((Object[])new Object[]{badQuery});
        Response response = this.resource.doPost(badQuery, this.req);
        Assert.assertNotEquals((long)200L, (long)response.getStatus());
        MultivaluedMap headers = response.getMetadata();
        Assert.assertTrue((boolean)headers.containsKey((Object)"X-Druid-SQL-Query-Id"));
        Assert.assertEquals((long)1L, (long)((List)headers.get((Object)"X-Druid-SQL-Query-Id")).size());
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)((List)headers.get((Object)"X-Druid-SQL-Query-Id")).get(0).toString()));
    }

    @Test
    public void testUnsupportedQueryThrowsExceptionWithFilterResponse() throws Exception {
        this.resource = new SqlResource(JSON_MAPPER, CalciteTests.TEST_AUTHORIZER_MAPPER, this.sqlLifecycleFactory, this.lifecycleManager, new ServerConfig(){

            public boolean isShowDetailedJettyErrors() {
                return true;
            }

            public ErrorResponseTransformStrategy getErrorResponseTransformStrategy() {
                return new AllowedRegexErrorResponseTransformStrategy((List)ImmutableList.of());
            }
        });
        String errorMessage = "This will be support in Druid 9999";
        SqlQuery badQuery = (SqlQuery)EasyMock.createMock(SqlQuery.class);
        EasyMock.expect((Object)badQuery.getQuery()).andReturn((Object)"SELECT ANSWER TO LIFE");
        EasyMock.expect((Object)badQuery.getContext()).andReturn((Object)ImmutableMap.of((Object)"sqlQueryId", (Object)"id"));
        EasyMock.expect((Object)badQuery.getParameterList()).andThrow((Throwable)new QueryUnsupportedException(errorMessage));
        EasyMock.replay((Object[])new Object[]{badQuery});
        QueryException exception = (QueryException)this.doPost((SqlQuery)badQuery).lhs;
        Assert.assertNotNull((Object)exception);
        Assert.assertNull((Object)exception.getMessage());
        Assert.assertNull((Object)exception.getHost());
        Assert.assertEquals((Object)exception.getErrorCode(), (Object)"Unsupported query");
        Assert.assertNull((Object)exception.getErrorClass());
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testAssertionErrorThrowsErrorWithFilterResponse() throws Exception {
        this.resource = new SqlResource(JSON_MAPPER, CalciteTests.TEST_AUTHORIZER_MAPPER, this.sqlLifecycleFactory, this.lifecycleManager, new ServerConfig(){

            public boolean isShowDetailedJettyErrors() {
                return true;
            }

            public ErrorResponseTransformStrategy getErrorResponseTransformStrategy() {
                return new AllowedRegexErrorResponseTransformStrategy((List)ImmutableList.of());
            }
        });
        String errorMessage = "could not assert";
        SqlQuery badQuery = (SqlQuery)EasyMock.createMock(SqlQuery.class);
        EasyMock.expect((Object)badQuery.getQuery()).andReturn((Object)"SELECT ANSWER TO LIFE");
        EasyMock.expect((Object)badQuery.getContext()).andReturn((Object)ImmutableMap.of((Object)"sqlQueryId", (Object)"id"));
        EasyMock.expect((Object)badQuery.getParameterList()).andThrow((Throwable)new Error(errorMessage));
        EasyMock.replay((Object[])new Object[]{badQuery});
        QueryException exception = (QueryException)this.doPost((SqlQuery)badQuery).lhs;
        Assert.assertNotNull((Object)exception);
        Assert.assertNull((Object)exception.getMessage());
        Assert.assertNull((Object)exception.getHost());
        Assert.assertEquals((Object)exception.getErrorCode(), (Object)"Unknown exception");
        Assert.assertNull((Object)exception.getErrorClass());
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testTooManyRequests() throws Exception {
        this.sleep = true;
        int numQueries = 3;
        String sqlQueryId = "tooManyRequestsTest";
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(3);
        for (int i = 0; i < 3; ++i) {
            futures.add(this.executorService.submit(() -> {
                try {
                    return this.doPost(new SqlQuery("SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.foo", null, false, false, false, (Map)ImmutableMap.of((Object)"priority", (Object)-5, (Object)"sqlQueryId", (Object)"tooManyRequestsTest"), null), this.makeRegularUserReq());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        int success = 0;
        int limited = 0;
        for (int i = 0; i < 3; ++i) {
            Pair result = (Pair)((Future)futures.get(i)).get();
            List rows = (List)result.rhs;
            if (rows != null) {
                Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6, (Object)"TheFoo", (Object)"foo")), (Object)rows);
                ++success;
                continue;
            }
            QueryException interruped = (QueryException)result.lhs;
            Assert.assertEquals((Object)"Query capacity exceeded", (Object)interruped.getErrorCode());
            Assert.assertEquals((Object)QueryCapacityExceededException.makeLaneErrorMessage((String)"low", (int)2), (Object)interruped.getMessage());
            ++limited;
        }
        Assert.assertEquals((long)2L, (long)success);
        Assert.assertEquals((long)1L, (long)limited);
        Assert.assertEquals((long)3L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("tooManyRequestsTest").isEmpty());
    }

    @Test
    public void testQueryTimeoutException() throws Exception {
        String sqlQueryId = "timeoutTest";
        ImmutableMap queryContext = ImmutableMap.of((Object)"timeout", (Object)1, (Object)"sqlQueryId", (Object)"timeoutTest");
        QueryException timeoutException = (QueryException)this.doPost((SqlQuery)new SqlQuery((String)"SELECT CAST(__time AS DATE), dim1, dim2, dim3 FROM druid.foo GROUP by __time, dim1, dim2, dim3 ORDER BY dim2 DESC", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, (Map)queryContext, null)).lhs;
        Assert.assertNotNull((Object)timeoutException);
        Assert.assertEquals((Object)timeoutException.getErrorCode(), (Object)"Query timeout");
        Assert.assertEquals((Object)timeoutException.getErrorClass(), (Object)QueryTimeoutException.class.getName());
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("timeoutTest").isEmpty());
    }

    @Test
    public void testCancelBetweenValidateAndPlan() throws Exception {
        String sqlQueryId = "toCancel";
        this.lifecycleAddLatch = new CountDownLatch(1);
        CountDownLatch validateAndAuthorizeLatch = new CountDownLatch(1);
        this.validateAndAuthorizeLatchSupplier.set((Object)new NonnullPair((Object)validateAndAuthorizeLatch, (Object)true));
        CountDownLatch planLatch = new CountDownLatch(1);
        this.planLatchSupplier.set((Object)new NonnullPair((Object)planLatch, (Object)false));
        ListenableFuture future = this.executorService.submit(() -> this.resource.doPost(SqlResourceTest.createSimpleQueryWithId("toCancel", "SELECT DISTINCT dim1 FROM foo"), this.makeRegularUserReq()));
        Assert.assertTrue((boolean)validateAndAuthorizeLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.lifecycleAddLatch.await(1L, TimeUnit.SECONDS));
        Response response = this.resource.cancelQuery("toCancel", this.mockRequestForCancel());
        planLatch.countDown();
        Assert.assertEquals((long)Response.Status.ACCEPTED.getStatusCode(), (long)response.getStatus());
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("toCancel").isEmpty());
        response = (Response)future.get();
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
        QueryException exception = (QueryException)JSON_MAPPER.readValue((byte[])response.getEntity(), QueryException.class);
        Assert.assertEquals((Object)"Query cancelled", (Object)exception.getErrorCode());
    }

    @Test
    public void testCancelBetweenPlanAndExecute() throws Exception {
        String sqlQueryId = "toCancel";
        CountDownLatch planLatch = new CountDownLatch(1);
        this.planLatchSupplier.set((Object)new NonnullPair((Object)planLatch, (Object)true));
        CountDownLatch execLatch = new CountDownLatch(1);
        this.executeLatchSupplier.set((Object)new NonnullPair((Object)execLatch, (Object)false));
        ListenableFuture future = this.executorService.submit(() -> this.resource.doPost(SqlResourceTest.createSimpleQueryWithId("toCancel", "SELECT DISTINCT dim1 FROM foo"), this.makeRegularUserReq()));
        Assert.assertTrue((boolean)planLatch.await(1L, TimeUnit.SECONDS));
        Response response = this.resource.cancelQuery("toCancel", this.mockRequestForCancel());
        execLatch.countDown();
        Assert.assertEquals((long)Response.Status.ACCEPTED.getStatusCode(), (long)response.getStatus());
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("toCancel").isEmpty());
        response = (Response)future.get();
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
        QueryException exception = (QueryException)JSON_MAPPER.readValue((byte[])response.getEntity(), QueryException.class);
        Assert.assertEquals((Object)"Query cancelled", (Object)exception.getErrorCode());
    }

    @Test
    public void testCancelInvalidQuery() throws Exception {
        String sqlQueryId = "validQuery";
        CountDownLatch planLatch = new CountDownLatch(1);
        this.planLatchSupplier.set((Object)new NonnullPair((Object)planLatch, (Object)true));
        CountDownLatch execLatch = new CountDownLatch(1);
        this.executeLatchSupplier.set((Object)new NonnullPair((Object)execLatch, (Object)false));
        ListenableFuture future = this.executorService.submit(() -> this.resource.doPost(SqlResourceTest.createSimpleQueryWithId("validQuery", "SELECT DISTINCT dim1 FROM foo"), this.makeRegularUserReq()));
        Assert.assertTrue((boolean)planLatch.await(1L, TimeUnit.SECONDS));
        Response response = this.resource.cancelQuery("invalidQuery", this.mockRequestForCancel());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        Assert.assertFalse((boolean)this.lifecycleManager.getAll("validQuery").isEmpty());
        execLatch.countDown();
        response = (Response)future.get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testCancelForbidden() throws Exception {
        String sqlQueryId = "toCancel";
        CountDownLatch planLatch = new CountDownLatch(1);
        this.planLatchSupplier.set((Object)new NonnullPair((Object)planLatch, (Object)true));
        CountDownLatch execLatch = new CountDownLatch(1);
        this.executeLatchSupplier.set((Object)new NonnullPair((Object)execLatch, (Object)false));
        ListenableFuture future = this.executorService.submit(() -> this.resource.doPost(SqlResourceTest.createSimpleQueryWithId("toCancel", "SELECT DISTINCT dim1 FROM forbiddenDatasource"), this.makeSuperUserReq()));
        Assert.assertTrue((boolean)planLatch.await(1L, TimeUnit.SECONDS));
        Response response = this.resource.cancelQuery("toCancel", this.mockRequestForCancel());
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.getStatus());
        Assert.assertFalse((boolean)this.lifecycleManager.getAll("toCancel").isEmpty());
        execLatch.countDown();
        response = (Response)future.get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    private void checkSqlRequestLog(boolean success) {
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        Map stats = ((RequestLogLine)this.testRequestLogger.getSqlQueryLogs().get(0)).getQueryStats().getStats();
        Map queryContext = (Map)stats.get("context");
        Assert.assertEquals((Object)success, stats.get("success"));
        Assert.assertEquals((Object)CalciteTests.REGULAR_USER_AUTH_RESULT.getIdentity(), stats.get("identity"));
        Assert.assertTrue((boolean)stats.containsKey("sqlQuery/time"));
        Assert.assertTrue((boolean)queryContext.containsKey("sqlQueryId"));
        if (success) {
            Assert.assertTrue((boolean)stats.containsKey("sqlQuery/bytes"));
        } else {
            Assert.assertTrue((boolean)stats.containsKey("exception"));
        }
    }

    private static SqlQuery createSimpleQueryWithId(String sqlQueryId, String sql) {
        return new SqlQuery(sql, null, false, false, false, (Map)ImmutableMap.of((Object)"sqlQueryId", (Object)sqlQueryId), null);
    }

    private Pair<QueryException, List<Map<String, Object>>> doPost(SqlQuery query) throws Exception {
        return this.doPost(query, new TypeReference<List<Map<String, Object>>>(){});
    }

    private <T> Pair<QueryException, T> doPost(SqlQuery query, TypeReference<T> typeReference) throws Exception {
        return this.doPost(query, this.req, typeReference);
    }

    private Pair<QueryException, String> doPostRaw(SqlQuery query) throws Exception {
        return this.doPostRaw(query, this.req);
    }

    private Pair<QueryException, List<Map<String, Object>>> doPost(SqlQuery query, HttpServletRequest req) throws Exception {
        return this.doPost(query, req, new TypeReference<List<Map<String, Object>>>(){});
    }

    private <T> Pair<QueryException, T> doPost(SqlQuery query, HttpServletRequest req, TypeReference<T> typeReference) throws Exception {
        Pair<QueryException, String> pair = this.doPostRaw(query, req);
        if (pair.rhs == null) {
            return pair;
        }
        return Pair.of((Object)pair.lhs, (Object)JSON_MAPPER.readValue((String)pair.rhs, typeReference));
    }

    private Pair<QueryException, String> doPostRaw(SqlQuery query, HttpServletRequest req) throws Exception {
        Response response = this.resource.doPost(query, req);
        if (response.getStatus() == 200) {
            StreamingOutput output = (StreamingOutput)response.getEntity();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                output.write((OutputStream)baos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Pair.of(null, (Object)new String(baos.toByteArray(), StandardCharsets.UTF_8));
        }
        return Pair.of((Object)JSON_MAPPER.readValue((byte[])response.getEntity(), QueryException.class), null);
    }

    private HttpServletRequest makeSuperUserReq() {
        return this.makeExpectedReq(CalciteTests.SUPER_USER_AUTH_RESULT);
    }

    private HttpServletRequest makeRegularUserReq() {
        return this.makeExpectedReq(CalciteTests.REGULAR_USER_AUTH_RESULT);
    }

    private HttpServletRequest makeExpectedReq(AuthenticationResult authenticationResult) {
        HttpServletRequest req = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getRemoteAddr()).andReturn(null).once();
        EasyMock.expect((Object)req.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).anyTimes();
        EasyMock.expect((Object)req.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)req.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)req.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).anyTimes();
        req.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)req.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).anyTimes();
        EasyMock.replay((Object[])new Object[]{req});
        return req;
    }

    private HttpServletRequest mockRequestForCancel() {
        HttpServletRequest req = (HttpServletRequest)EasyMock.createNiceMock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getAttribute("Druid-Authentication-Result")).andReturn((Object)CalciteTests.REGULAR_USER_AUTH_RESULT).anyTimes();
        EasyMock.expect((Object)req.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)req.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        req.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{req});
        return req;
    }

    private static Function<Sequence<Object[]>, Sequence<Object[]>> errorAfterSecondRowMapFn() {
        return results -> {
            AtomicLong rows = new AtomicLong();
            return results.map(row -> {
                if (rows.incrementAndGet() == 3L) {
                    throw new ISE("Oh no!", new Object[0]);
                }
                return row;
            });
        };
    }

    private static class TestSqlLifecycle
    extends SqlLifecycle {
        private final SettableSupplier<NonnullPair<CountDownLatch, Boolean>> validateAndAuthorizeLatchSupplier;
        private final SettableSupplier<NonnullPair<CountDownLatch, Boolean>> planLatchSupplier;
        private final SettableSupplier<NonnullPair<CountDownLatch, Boolean>> executeLatchSupplier;
        private final SettableSupplier<Function<Sequence<Object[]>, Sequence<Object[]>>> sequenceMapFnSupplier;

        private TestSqlLifecycle(PlannerFactory plannerFactory, ServiceEmitter emitter, RequestLogger requestLogger, QueryScheduler queryScheduler, AuthConfig authConfig, long startMs, long startNs, SettableSupplier<NonnullPair<CountDownLatch, Boolean>> validateAndAuthorizeLatchSupplier, SettableSupplier<NonnullPair<CountDownLatch, Boolean>> planLatchSupplier, SettableSupplier<NonnullPair<CountDownLatch, Boolean>> executeLatchSupplier, SettableSupplier<Function<Sequence<Object[]>, Sequence<Object[]>>> sequenceMapFnSupplier) {
            super(plannerFactory, emitter, requestLogger, queryScheduler, authConfig, startMs, startNs);
            this.validateAndAuthorizeLatchSupplier = validateAndAuthorizeLatchSupplier;
            this.planLatchSupplier = planLatchSupplier;
            this.executeLatchSupplier = executeLatchSupplier;
            this.sequenceMapFnSupplier = sequenceMapFnSupplier;
        }

        public void validateAndAuthorize(HttpServletRequest req) {
            if (this.validateAndAuthorizeLatchSupplier.get() != null) {
                if (((Boolean)((NonnullPair)this.validateAndAuthorizeLatchSupplier.get()).rhs).booleanValue()) {
                    super.validateAndAuthorize(req);
                    ((CountDownLatch)((NonnullPair)this.validateAndAuthorizeLatchSupplier.get()).lhs).countDown();
                } else {
                    try {
                        if (!((CountDownLatch)((NonnullPair)this.validateAndAuthorizeLatchSupplier.get()).lhs).await(1L, TimeUnit.SECONDS)) {
                            throw new RuntimeException("Latch timed out");
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    super.validateAndAuthorize(req);
                }
            } else {
                super.validateAndAuthorize(req);
            }
        }

        public void plan() throws RelConversionException {
            if (this.planLatchSupplier.get() != null) {
                if (((Boolean)((NonnullPair)this.planLatchSupplier.get()).rhs).booleanValue()) {
                    super.plan();
                    ((CountDownLatch)((NonnullPair)this.planLatchSupplier.get()).lhs).countDown();
                } else {
                    try {
                        if (!((CountDownLatch)((NonnullPair)this.planLatchSupplier.get()).lhs).await(1L, TimeUnit.SECONDS)) {
                            throw new RuntimeException("Latch timed out");
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    super.plan();
                }
            } else {
                super.plan();
            }
        }

        public Sequence<Object[]> execute() {
            Function<Sequence, Sequence> sequenceMapFn = Optional.ofNullable(this.sequenceMapFnSupplier.get()).orElse(Function.identity());
            if (this.executeLatchSupplier.get() != null) {
                if (((Boolean)((NonnullPair)this.executeLatchSupplier.get()).rhs).booleanValue()) {
                    Sequence sequence = (Sequence)sequenceMapFn.apply(super.execute());
                    ((CountDownLatch)((NonnullPair)this.executeLatchSupplier.get()).lhs).countDown();
                    return sequence;
                }
                try {
                    if (!((CountDownLatch)((NonnullPair)this.executeLatchSupplier.get()).lhs).await(1L, TimeUnit.SECONDS)) {
                        throw new RuntimeException("Latch timed out");
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return (Sequence)sequenceMapFn.apply(super.execute());
            }
            return (Sequence)sequenceMapFn.apply(super.execute());
        }
    }
}

