/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.segment.InlineSegmentWrangler;
import org.apache.druid.segment.LookupSegmentWrangler;
import org.apache.druid.segment.MapSegmentWrangler;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;

public class SpecificSegmentsQuerySegmentWalker
implements QuerySegmentWalker,
Closeable {
    private final QuerySegmentWalker walker;
    private final Map<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>> timelines = new HashMap<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>>();
    private final List<Closeable> closeables = new ArrayList<Closeable>();
    private final List<DataSegment> segments = new ArrayList<DataSegment>();

    public SpecificSegmentsQuerySegmentWalker(QueryRunnerFactoryConglomerate conglomerate, LookupExtractorFactoryContainerProvider lookupProvider, @Nullable JoinableFactory joinableFactory, QueryScheduler scheduler) {
        JoinableFactory joinableFactoryToUse = joinableFactory == null ? QueryStackTests.makeJoinableFactoryForLookup((LookupExtractorFactoryContainerProvider)lookupProvider) : joinableFactory;
        this.walker = QueryStackTests.createClientQuerySegmentWalker((QuerySegmentWalker)QueryStackTests.createClusterQuerySegmentWalker(this.timelines, (JoinableFactory)joinableFactoryToUse, (QueryRunnerFactoryConglomerate)conglomerate, (QueryScheduler)scheduler), (QuerySegmentWalker)QueryStackTests.createLocalQuerySegmentWalker((QueryRunnerFactoryConglomerate)conglomerate, (SegmentWrangler)new MapSegmentWrangler((Map)ImmutableMap.builder().put(InlineDataSource.class, (Object)new InlineSegmentWrangler()).put(LookupDataSource.class, (Object)new LookupSegmentWrangler(lookupProvider)).build()), (JoinableFactory)joinableFactoryToUse, (QueryScheduler)scheduler), (QueryRunnerFactoryConglomerate)conglomerate, (JoinableFactory)joinableFactoryToUse, (ServerConfig)new ServerConfig());
    }

    public SpecificSegmentsQuerySegmentWalker(QueryRunnerFactoryConglomerate conglomerate) {
        this(conglomerate, new LookupExtractorFactoryContainerProvider(){

            public Set<String> getAllLookupNames() {
                return Collections.emptySet();
            }

            public Optional<LookupExtractorFactoryContainer> get(String lookupName) {
                return Optional.empty();
            }
        }, null, QueryStackTests.DEFAULT_NOOP_SCHEDULER);
    }

    public SpecificSegmentsQuerySegmentWalker add(DataSegment descriptor, QueryableIndex index) {
        ReferenceCountingSegment segment = ReferenceCountingSegment.wrapSegment((Segment)new QueryableIndexSegment(index, descriptor.getId()), (ShardSpec)descriptor.getShardSpec());
        VersionedIntervalTimeline timeline = this.timelines.computeIfAbsent(descriptor.getDataSource(), datasource -> new VersionedIntervalTimeline((Comparator)Ordering.natural()));
        timeline.add(descriptor.getInterval(), (Object)descriptor.getVersion(), descriptor.getShardSpec().createChunk((Object)segment));
        this.segments.add(descriptor);
        this.closeables.add((Closeable)segment);
        return this;
    }

    public List<DataSegment> getSegments() {
        return this.segments;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return this.walker.getQueryRunnerForIntervals(query, intervals);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        return this.walker.getQueryRunnerForSegments(query, specs);
    }

    @Override
    public void close() throws IOException {
        for (Closeable closeable : this.closeables) {
            Closeables.close((Closeable)closeable, (boolean)true);
        }
    }
}

