/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import org.apache.calcite.runtime.Hook;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Query;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class QueryLogHook
implements TestRule {
    private static final Logger log = new Logger(QueryLogHook.class);
    private final ObjectMapper objectMapper;
    private final List<Query> recordedQueries = Lists.newCopyOnWriteArrayList();

    public QueryLogHook(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static QueryLogHook create() {
        return new QueryLogHook((ObjectMapper)new DefaultObjectMapper());
    }

    public static QueryLogHook create(ObjectMapper objectMapper) {
        return new QueryLogHook(objectMapper);
    }

    public void clearRecordedQueries() {
        this.recordedQueries.clear();
    }

    public List<Query> getRecordedQueries() {
        return ImmutableList.copyOf(this.recordedQueries);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                QueryLogHook.this.clearRecordedQueries();
                Consumer<Object> function = query -> {
                    try {
                        QueryLogHook.this.recordedQueries.add((Query)query);
                        log.info("Issued query: %s", new Object[]{QueryLogHook.this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(query)});
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e, "Failed to serialize query: %s", new Object[]{query});
                    }
                };
                try (Hook.Closeable unhook = Hook.QUERY_PLAN.add(function);){
                    base.evaluate();
                }
            }
        };
    }
}

