/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.druid.client.BrokerInternalQueryConfig;
import org.apache.druid.client.BrokerSegmentWatcherConfig;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.FilteredServerInventoryView;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.ExpressionModule;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.NoopEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.expression.LookupExprMacro;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.table.RowBasedIndexedTable;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.log.NoopRequestLogger;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.run.NativeQueryMakerFactory;
import org.apache.druid.sql.calcite.run.QueryMakerFactory;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.DruidSchemaManager;
import org.apache.druid.sql.calcite.schema.InformationSchema;
import org.apache.druid.sql.calcite.schema.LookupSchema;
import org.apache.druid.sql.calcite.schema.MetadataSegmentView;
import org.apache.druid.sql.calcite.schema.NamedDruidSchema;
import org.apache.druid.sql.calcite.schema.NamedLookupSchema;
import org.apache.druid.sql.calcite.schema.NamedSchema;
import org.apache.druid.sql.calcite.schema.NamedSystemSchema;
import org.apache.druid.sql.calcite.schema.NamedViewSchema;
import org.apache.druid.sql.calcite.schema.NoopDruidSchemaManager;
import org.apache.druid.sql.calcite.schema.SystemSchema;
import org.apache.druid.sql.calcite.schema.ViewSchema;
import org.apache.druid.sql.calcite.util.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.calcite.util.TestServerInventoryView;
import org.apache.druid.sql.calcite.view.DruidViewMacroFactory;
import org.apache.druid.sql.calcite.view.ViewManager;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.chrono.ISOChronology;

public class CalciteTests {
    public static final String DATASOURCE1 = "foo";
    public static final String DATASOURCE2 = "foo2";
    public static final String DATASOURCE3 = "numfoo";
    public static final String DATASOURCE4 = "foo4";
    public static final String DATASOURCE5 = "lotsocolumns";
    public static final String BROADCAST_DATASOURCE = "broadcast";
    public static final String FORBIDDEN_DATASOURCE = "forbiddenDatasource";
    public static final String SOME_DATASOURCE = "some_datasource";
    public static final String SOME_DATSOURCE_ESCAPED = "some\\_datasource";
    public static final String SOMEXDATASOURCE = "somexdatasource";
    public static final String USERVISITDATASOURCE = "visits";
    public static final String DRUID_SCHEMA_NAME = "druid";
    public static final String INFORMATION_SCHEMA_NAME = "INFORMATION_SCHEMA";
    public static final String TEST_SUPERUSER_NAME = "testSuperuser";
    public static final AuthorizerMapper TEST_AUTHORIZER_MAPPER;
    public static final AuthenticatorMapper TEST_AUTHENTICATOR_MAPPER;
    public static final Escalator TEST_AUTHENTICATOR_ESCALATOR;
    public static final AuthenticationResult REGULAR_USER_AUTH_RESULT;
    public static final AuthenticationResult SUPER_USER_AUTH_RESULT;
    private static final String TIMESTAMP_COLUMN = "t";
    public static final Injector INJECTOR;
    private static final InputRowParser<Map<String, Object>> PARSER;
    private static final InputRowParser<Map<String, Object>> PARSER_NUMERIC_DIMS;
    private static final InputRowParser<Map<String, Object>> PARSER_LOTS_OF_COLUMNS;
    private static final IncrementalIndexSchema INDEX_SCHEMA;
    private static final IncrementalIndexSchema INDEX_SCHEMA_DIFFERENT_DIM3_M1_TYPES;
    private static final IncrementalIndexSchema INDEX_SCHEMA_WITH_X_COLUMNS;
    private static final IncrementalIndexSchema INDEX_SCHEMA_NUMERIC_DIMS;
    private static final IncrementalIndexSchema INDEX_SCHEMA_LOTS_O_COLUMNS;
    private static final List<String> USER_VISIT_DIMS;
    private static final IncrementalIndexSchema INDEX_SCHEMA_USER_VISIT;
    public static final List<ImmutableMap<String, Object>> RAW_ROWS1;
    public static final List<InputRow> RAW_ROWS1_X;
    public static final List<InputRow> ROWS1;
    public static final List<ImmutableMap<String, Object>> RAW_ROWS1_WITH_NUMERIC_DIMS;
    public static final List<InputRow> ROWS1_WITH_NUMERIC_DIMS;
    public static final List<ImmutableMap<String, Object>> RAW_ROWS2;
    public static final List<InputRow> ROWS2;
    public static final List<ImmutableMap<String, Object>> RAW_ROWS1_WITH_FULL_TIMESTAMP;
    public static final List<InputRow> ROWS1_WITH_FULL_TIMESTAMP;
    public static final List<InputRow> FORBIDDEN_ROWS;
    public static final List<InputRow> ROWS_LOTS_OF_COLUMNS;
    private static List<InputRow> USER_VISIT_ROWS;
    private static final InlineDataSource JOINABLE_BACKING_DATA;
    private static final Set<String> KEY_COLUMNS;
    private static final RowBasedIndexedTable JOINABLE_TABLE;
    public static GlobalTableDataSource CUSTOM_TABLE;
    public static JoinableFactory CUSTOM_ROW_TABLE_JOINABLE;
    public static final DruidViewMacroFactory DRUID_VIEW_MACRO_FACTORY;

    private CalciteTests() {
    }

    public static QueryMakerFactory createMockQueryMakerFactory(QuerySegmentWalker walker, QueryRunnerFactoryConglomerate conglomerate) {
        return new NativeQueryMakerFactory(CalciteTests.createMockQueryLifecycleFactory(walker, conglomerate), CalciteTests.getJsonMapper());
    }

    public static QueryLifecycleFactory createMockQueryLifecycleFactory(QuerySegmentWalker walker, final QueryRunnerFactoryConglomerate conglomerate) {
        return new QueryLifecycleFactory(new QueryToolChestWarehouse(){

            public <T, QueryType extends Query<T>> QueryToolChest<T, QueryType> getToolChest(QueryType query) {
                return conglomerate.findFactory(query).getToolchest();
            }
        }, walker, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), new ServiceEmitter("dummy", "dummy", (Emitter)new NoopEmitter()), (RequestLogger)new NoopRequestLogger(), new AuthConfig(), TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of())));
    }

    public static SqlLifecycleFactory createSqlLifecycleFactory(PlannerFactory plannerFactory) {
        return CalciteTests.createSqlLifecycleFactory(plannerFactory, new AuthConfig());
    }

    public static SqlLifecycleFactory createSqlLifecycleFactory(PlannerFactory plannerFactory, AuthConfig authConfig) {
        return new SqlLifecycleFactory(plannerFactory, new ServiceEmitter("dummy", "dummy", (Emitter)new NoopEmitter()), (RequestLogger)new NoopRequestLogger(), QueryStackTests.DEFAULT_NOOP_SCHEDULER, authConfig);
    }

    public static ObjectMapper getJsonMapper() {
        return (ObjectMapper)INJECTOR.getInstance(Key.get(ObjectMapper.class, Json.class));
    }

    public static JoinableFactory createDefaultJoinableFactory() {
        return QueryStackTests.makeJoinableFactoryFromDefault((LookupExtractorFactoryContainerProvider)((LookupExtractorFactoryContainerProvider)INJECTOR.getInstance(LookupExtractorFactoryContainerProvider.class)), (Set)ImmutableSet.of((Object)CUSTOM_ROW_TABLE_JOINABLE), (Map)ImmutableMap.of(CUSTOM_ROW_TABLE_JOINABLE.getClass(), GlobalTableDataSource.class));
    }

    public static SpecificSegmentsQuerySegmentWalker createMockWalker(QueryRunnerFactoryConglomerate conglomerate, File tmpDir) {
        return CalciteTests.createMockWalker(conglomerate, tmpDir, QueryStackTests.DEFAULT_NOOP_SCHEDULER, CalciteTests.createDefaultJoinableFactory());
    }

    public static SpecificSegmentsQuerySegmentWalker createMockWalker(QueryRunnerFactoryConglomerate conglomerate, File tmpDir, QueryScheduler scheduler) {
        return CalciteTests.createMockWalker(conglomerate, tmpDir, scheduler, null);
    }

    public static SpecificSegmentsQuerySegmentWalker createMockWalker(QueryRunnerFactoryConglomerate conglomerate, File tmpDir, QueryScheduler scheduler, JoinableFactory joinableFactory) {
        QueryableIndex index1 = IndexBuilder.create().tmpDir(new File(tmpDir, "1")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA).rows(ROWS1).buildMMappedIndex();
        QueryableIndex index2 = IndexBuilder.create().tmpDir(new File(tmpDir, "2")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA_DIFFERENT_DIM3_M1_TYPES).rows(ROWS2).buildMMappedIndex();
        QueryableIndex forbiddenIndex = IndexBuilder.create().tmpDir(new File(tmpDir, "forbidden")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA).rows(FORBIDDEN_ROWS).buildMMappedIndex();
        QueryableIndex indexNumericDims = IndexBuilder.create().tmpDir(new File(tmpDir, "3")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA_NUMERIC_DIMS).rows(ROWS1_WITH_NUMERIC_DIMS).buildMMappedIndex();
        QueryableIndex index4 = IndexBuilder.create().tmpDir(new File(tmpDir, "4")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA).rows(ROWS1_WITH_FULL_TIMESTAMP).buildMMappedIndex();
        QueryableIndex indexLotsOfColumns = IndexBuilder.create().tmpDir(new File(tmpDir, "5")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA_LOTS_O_COLUMNS).rows(ROWS_LOTS_OF_COLUMNS).buildMMappedIndex();
        QueryableIndex someDatasourceIndex = IndexBuilder.create().tmpDir(new File(tmpDir, "6")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA).rows(ROWS1).buildMMappedIndex();
        QueryableIndex someXDatasourceIndex = IndexBuilder.create().tmpDir(new File(tmpDir, "7")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA_WITH_X_COLUMNS).rows(RAW_ROWS1_X).buildMMappedIndex();
        QueryableIndex userVisitIndex = IndexBuilder.create().tmpDir(new File(tmpDir, "8")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA).rows(USER_VISIT_ROWS).buildMMappedIndex();
        return new SpecificSegmentsQuerySegmentWalker(conglomerate, (LookupExtractorFactoryContainerProvider)INJECTOR.getInstance(LookupExtractorFactoryContainerProvider.class), joinableFactory, scheduler).add(DataSegment.builder().dataSource(DATASOURCE1).interval(index1.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index1).add(DataSegment.builder().dataSource(DATASOURCE2).interval(index2.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index2).add(DataSegment.builder().dataSource(FORBIDDEN_DATASOURCE).interval(forbiddenIndex.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), forbiddenIndex).add(DataSegment.builder().dataSource(DATASOURCE3).interval(indexNumericDims.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), indexNumericDims).add(DataSegment.builder().dataSource(DATASOURCE4).interval(index4.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index4).add(DataSegment.builder().dataSource(DATASOURCE5).interval(indexLotsOfColumns.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), indexLotsOfColumns).add(DataSegment.builder().dataSource(SOME_DATASOURCE).interval(indexLotsOfColumns.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), someDatasourceIndex).add(DataSegment.builder().dataSource(SOMEXDATASOURCE).interval(indexLotsOfColumns.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), someXDatasourceIndex).add(DataSegment.builder().dataSource(BROADCAST_DATASOURCE).interval(indexNumericDims.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), indexNumericDims).add(DataSegment.builder().dataSource(USERVISITDATASOURCE).interval(userVisitIndex.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), userVisitIndex);
    }

    private static MapBasedInputRow toRow(String time, List<String> dimensions, Map<String, Object> event) {
        return new MapBasedInputRow(DateTimes.ISO_DATE_OPTIONAL_TIME.parse(time), dimensions, event);
    }

    public static ExprMacroTable createExprMacroTable() {
        ArrayList<Object> exprMacros = new ArrayList<Object>();
        for (Class clazz : ExpressionModule.EXPR_MACROS) {
            exprMacros.add(INJECTOR.getInstance(clazz));
        }
        exprMacros.add(INJECTOR.getInstance(LookupExprMacro.class));
        return new ExprMacroTable(exprMacros);
    }

    public static DruidOperatorTable createOperatorTable() {
        try {
            return (DruidOperatorTable)INJECTOR.getInstance(DruidOperatorTable.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InputRow createRow(ImmutableMap<String, ?> map) {
        return (InputRow)PARSER.parseBatch(map).get(0);
    }

    public static InputRow createRow(ImmutableMap<String, ?> map, InputRowParser<Map<String, Object>> parser) {
        return (InputRow)parser.parseBatch(map).get(0);
    }

    public static InputRow createRow(Object t, String dim1, String dim2, double m1) {
        return (InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)TIMESTAMP_COLUMN, (Object)new DateTime(t, (Chronology)ISOChronology.getInstanceUTC()).getMillis(), (Object)"dim1", (Object)dim1, (Object)"dim2", (Object)dim2, (Object)"m1", (Object)m1)).get(0);
    }

    public static LookupSchema createMockLookupSchema() {
        return new LookupSchema((LookupExtractorFactoryContainerProvider)INJECTOR.getInstance(LookupExtractorFactoryContainerProvider.class));
    }

    public static SystemSchema createMockSystemSchema(DruidSchema druidSchema, SpecificSegmentsQuerySegmentWalker walker, PlannerConfig plannerConfig, AuthorizerMapper authorizerMapper) {
        final DruidNode coordinatorNode = new DruidNode("test-coordinator", "dummy", false, Integer.valueOf(8081), null, true, false);
        FakeDruidNodeDiscoveryProvider provider = new FakeDruidNodeDiscoveryProvider((Map<NodeRole, FakeDruidNodeDiscovery>)ImmutableMap.of((Object)NodeRole.COORDINATOR, (Object)new FakeDruidNodeDiscovery((Map<NodeRole, DruidNode>)ImmutableMap.of((Object)NodeRole.COORDINATOR, (Object)coordinatorNode))));
        final DruidNode overlordNode = new DruidNode("test-overlord", "dummy", false, Integer.valueOf(8090), null, true, false);
        FakeDruidNodeDiscoveryProvider overlordProvider = new FakeDruidNodeDiscoveryProvider((Map<NodeRole, FakeDruidNodeDiscovery>)ImmutableMap.of((Object)NodeRole.OVERLORD, (Object)new FakeDruidNodeDiscovery((Map<NodeRole, DruidNode>)ImmutableMap.of((Object)NodeRole.OVERLORD, (Object)coordinatorNode))));
        DruidLeaderClient druidLeaderClient = new DruidLeaderClient(new FakeHttpClient(), provider, NodeRole.COORDINATOR, "/simple/leader"){

            public String findCurrentLeader() {
                return coordinatorNode.getHostAndPortToUse();
            }
        };
        DruidLeaderClient overlordLeaderClient = new DruidLeaderClient(new FakeHttpClient(), overlordProvider, NodeRole.OVERLORD, "/simple/leader"){

            public String findCurrentLeader() {
                return overlordNode.getHostAndPortToUse();
            }
        };
        return new SystemSchema(druidSchema, new MetadataSegmentView(druidLeaderClient, CalciteTests.getJsonMapper(), new BrokerSegmentWatcherConfig(), plannerConfig), (TimelineServerView)new TestServerInventoryView(walker.getSegments()), (FilteredServerInventoryView)new FakeServerInventoryView(), authorizerMapper, druidLeaderClient, overlordLeaderClient, (DruidNodeDiscoveryProvider)provider, CalciteTests.getJsonMapper());
    }

    public static DruidSchemaCatalog createMockRootSchema(QueryRunnerFactoryConglomerate conglomerate, SpecificSegmentsQuerySegmentWalker walker, PlannerConfig plannerConfig, AuthorizerMapper authorizerMapper) {
        return CalciteTests.createMockRootSchema(conglomerate, walker, plannerConfig, null, (DruidSchemaManager)new NoopDruidSchemaManager(), authorizerMapper);
    }

    public static DruidSchemaCatalog createMockRootSchema(QueryRunnerFactoryConglomerate conglomerate, SpecificSegmentsQuerySegmentWalker walker, PlannerConfig plannerConfig, @Nullable ViewManager viewManager, DruidSchemaManager druidSchemaManager, AuthorizerMapper authorizerMapper) {
        DruidSchema druidSchema = CalciteTests.createMockSchema(conglomerate, walker, plannerConfig, druidSchemaManager);
        SystemSchema systemSchema = CalciteTests.createMockSystemSchema(druidSchema, walker, plannerConfig, authorizerMapper);
        LookupSchema lookupSchema = CalciteTests.createMockLookupSchema();
        ViewSchema viewSchema = viewManager != null ? new ViewSchema(viewManager) : null;
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)false, (boolean)false).plus();
        HashSet<Object> namedSchemas = new HashSet<Object>();
        namedSchemas.add(new NamedDruidSchema(druidSchema, DRUID_SCHEMA_NAME));
        namedSchemas.add(new NamedSystemSchema(plannerConfig, systemSchema));
        namedSchemas.add(new NamedLookupSchema(lookupSchema));
        if (viewSchema != null) {
            namedSchemas.add(new NamedViewSchema(viewSchema));
        }
        DruidSchemaCatalog catalog = new DruidSchemaCatalog(rootSchema, namedSchemas.stream().collect(Collectors.toMap(NamedSchema::getSchemaName, x -> x)));
        InformationSchema informationSchema = new InformationSchema(catalog, authorizerMapper);
        rootSchema.add(DRUID_SCHEMA_NAME, (Schema)druidSchema);
        rootSchema.add(INFORMATION_SCHEMA_NAME, (Schema)informationSchema);
        rootSchema.add("sys", (Schema)systemSchema);
        rootSchema.add("lookup", (Schema)lookupSchema);
        if (viewSchema != null) {
            rootSchema.add("view", (Schema)viewSchema);
        }
        return catalog;
    }

    private static DruidSchema createMockSchema(QueryRunnerFactoryConglomerate conglomerate, SpecificSegmentsQuerySegmentWalker walker, PlannerConfig plannerConfig, DruidSchemaManager druidSchemaManager) {
        DruidSchema schema = new DruidSchema(CalciteTests.createMockQueryLifecycleFactory(walker, conglomerate), (TimelineServerView)new TestServerInventoryView(walker.getSegments()), new SegmentManager((SegmentLoader)EasyMock.createMock(SegmentLoader.class)){

            public Set<String> getDataSourceNames() {
                return ImmutableSet.of((Object)CalciteTests.BROADCAST_DATASOURCE);
            }
        }, CalciteTests.createDefaultJoinableFactory(), plannerConfig, TEST_AUTHENTICATOR_ESCALATOR, new BrokerInternalQueryConfig(), druidSchemaManager);
        try {
            schema.start();
            schema.awaitInitialization();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        schema.stop();
        return schema;
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class FakeServerInventoryView
    implements FilteredServerInventoryView {
        private FakeServerInventoryView() {
        }

        @Nullable
        public DruidServer getInventoryValue(String serverKey) {
            throw new UnsupportedOperationException();
        }

        public Collection<DruidServer> getInventory() {
            throw new UnsupportedOperationException();
        }

        public boolean isStarted() {
            throw new UnsupportedOperationException();
        }

        public boolean isSegmentLoadedByServer(String serverKey, DataSegment segment) {
            throw new UnsupportedOperationException();
        }

        public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback, Predicate<Pair<DruidServerMetadata, DataSegment>> filter) {
            throw new UnsupportedOperationException();
        }

        public void registerServerRemovedCallback(Executor exec, ServerView.ServerRemovedCallback callback) {
            throw new UnsupportedOperationException();
        }
    }

    private static class FakeDruidNodeDiscovery
    implements DruidNodeDiscovery {
        private final Set<DiscoveryDruidNode> nodes;

        FakeDruidNodeDiscovery() {
            this.nodes = new HashSet<DiscoveryDruidNode>();
        }

        FakeDruidNodeDiscovery(Map<NodeRole, DruidNode> nodes) {
            this.nodes = Sets.newHashSetWithExpectedSize((int)nodes.size());
            nodes.forEach((k, v) -> this.addNode((DruidNode)v, (NodeRole)k));
        }

        public Collection<DiscoveryDruidNode> getAllNodes() {
            return this.nodes;
        }

        void addNode(DruidNode node, NodeRole role) {
            DiscoveryDruidNode discoveryNode = new DiscoveryDruidNode(node, role, (Map)ImmutableMap.of());
            this.nodes.add(discoveryNode);
        }

        public void registerListener(DruidNodeDiscovery.Listener listener) {
        }
    }

    private static class FakeDruidNodeDiscoveryProvider
    extends DruidNodeDiscoveryProvider {
        private final Map<NodeRole, FakeDruidNodeDiscovery> nodeDiscoveries;

        public FakeDruidNodeDiscoveryProvider(Map<NodeRole, FakeDruidNodeDiscovery> nodeDiscoveries) {
            this.nodeDiscoveries = nodeDiscoveries;
        }

        public BooleanSupplier getForNode(DruidNode node, NodeRole nodeRole) {
            boolean get = this.nodeDiscoveries.getOrDefault(nodeRole, new FakeDruidNodeDiscovery()).getAllNodes().stream().anyMatch(x -> x.getDruidNode().equals((Object)node));
            return () -> get;
        }

        public DruidNodeDiscovery getForNodeRole(NodeRole nodeRole) {
            return this.nodeDiscoveries.getOrDefault(nodeRole, new FakeDruidNodeDiscovery());
        }
    }

    private static class FakeHttpClient
    implements HttpClient {
        private FakeHttpClient() {
        }

        public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> handler) {
            throw new UnsupportedOperationException();
        }

        public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> handler, Duration readTimeout) {
            throw new UnsupportedOperationException();
        }
    }
}

