/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.calcite.schema.Schema;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.NamedSchema;
import org.apache.druid.sql.calcite.schema.RootSchemaProvider;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class RootSchemaProviderTest
extends CalciteTestBase {
    private static final String SCHEMA_1 = "SCHEMA_1";
    private static final String SCHEMA_2 = "SCHEMA_2";
    @Mock
    private NamedSchema druidSchema1;
    @Mock
    private NamedSchema druidSchema2;
    @Mock
    private NamedSchema duplicateSchema1;
    @Mock
    private Schema schema1;
    @Mock
    private Schema schema2;
    @Mock
    private Schema schema3;
    private Set<NamedSchema> druidSchemas;
    private RootSchemaProvider target;

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.druidSchema1.getSchema()).andStubReturn((Object)this.schema1);
        EasyMock.expect((Object)this.druidSchema2.getSchema()).andStubReturn((Object)this.schema2);
        EasyMock.expect((Object)this.duplicateSchema1.getSchema()).andStubReturn((Object)this.schema3);
        EasyMock.expect((Object)this.druidSchema1.getSchemaName()).andStubReturn((Object)SCHEMA_1);
        EasyMock.expect((Object)this.druidSchema2.getSchemaName()).andStubReturn((Object)SCHEMA_2);
        EasyMock.expect((Object)this.duplicateSchema1.getSchemaName()).andStubReturn((Object)SCHEMA_1);
        EasyMock.replay((Object[])new Object[]{this.druidSchema1, this.druidSchema2, this.duplicateSchema1});
        this.druidSchemas = ImmutableSet.of((Object)this.druidSchema1, (Object)this.druidSchema2);
        this.target = new RootSchemaProvider(this.druidSchemas);
    }

    @Test
    public void testGetShouldReturnRootSchemaWithProvidedSchemasRegistered() {
        DruidSchemaCatalog rootSchema = this.target.get();
        Assert.assertEquals((Object)"", (Object)rootSchema.getRootSchema().getName());
        Assert.assertFalse((boolean)rootSchema.getRootSchema().isCacheEnabled());
        Assert.assertEquals((long)this.druidSchemas.size(), (long)rootSchema.getSubSchemaNames().size());
        Assert.assertEquals((Object)this.schema1, (Object)rootSchema.getSubSchema(SCHEMA_1).unwrap(this.schema1.getClass()));
        Assert.assertEquals((Object)this.schema2, (Object)rootSchema.getSubSchema(SCHEMA_2).unwrap(this.schema2.getClass()));
    }

    @Test(expected=ISE.class)
    public void testGetWithDuplicateSchemasShouldThrowISE() {
        this.target = new RootSchemaProvider((Set)ImmutableSet.of((Object)this.druidSchema1, (Object)this.druidSchema2, (Object)this.duplicateSchema1));
        this.target.get();
    }
}

