/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.easymock.EasyMock;
import org.joda.time.Period;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public abstract class DruidSchemaTestCommon
extends CalciteTestBase {
    static final PlannerConfig PLANNER_CONFIG_DEFAULT = new PlannerConfig(){

        public Period getMetadataRefreshPeriod() {
            return new Period((Object)"PT1S");
        }
    };
    static final List<InputRow> ROWS1 = ImmutableList.of((Object)CalciteTests.createRow(ImmutableMap.of((Object)"t", (Object)"2000-01-01", (Object)"m1", (Object)"1.0", (Object)"dim1", (Object)"")), (Object)CalciteTests.createRow(ImmutableMap.of((Object)"t", (Object)"2000-01-02", (Object)"m1", (Object)"2.0", (Object)"dim1", (Object)"10.1")), (Object)CalciteTests.createRow(ImmutableMap.of((Object)"t", (Object)"2000-01-03", (Object)"m1", (Object)"3.0", (Object)"dim1", (Object)"2")));
    static final List<InputRow> ROWS2 = ImmutableList.of((Object)CalciteTests.createRow(ImmutableMap.of((Object)"t", (Object)"2001-01-01", (Object)"m1", (Object)"4.0", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))), (Object)CalciteTests.createRow(ImmutableMap.of((Object)"t", (Object)"2001-01-02", (Object)"m1", (Object)"5.0", (Object)"dim2", (Object)ImmutableList.of((Object)"abc"))), (Object)CalciteTests.createRow(ImmutableMap.of((Object)"t", (Object)"2001-01-03", (Object)"m1", (Object)"6.0")));
    static QueryRunnerFactoryConglomerate conglomerate;
    static Closer resourceCloser;
    CountDownLatch getDatasourcesLatch = new CountDownLatch(1);
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    SegmentManager segmentManager;
    Set<String> segmentDataSourceNames;
    Set<String> joinableDataSourceNames;
    JoinableFactory globalTableJoinable;

    @BeforeClass
    public static void setUpClass() {
        resourceCloser = Closer.create();
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)resourceCloser);
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        resourceCloser.close();
    }

    @Before
    public void setUpCommon() {
        this.segmentDataSourceNames = Sets.newConcurrentHashSet();
        this.joinableDataSourceNames = Sets.newConcurrentHashSet();
        this.segmentManager = new SegmentManager((SegmentLoader)EasyMock.createMock(SegmentLoader.class)){

            public Set<String> getDataSourceNames() {
                DruidSchemaTestCommon.this.getDatasourcesLatch.countDown();
                return DruidSchemaTestCommon.this.segmentDataSourceNames;
            }
        };
        this.globalTableJoinable = new JoinableFactory(){

            public boolean isDirectlyJoinable(DataSource dataSource) {
                return dataSource instanceof GlobalTableDataSource && DruidSchemaTestCommon.this.joinableDataSourceNames.contains(((GlobalTableDataSource)dataSource).getName());
            }

            public Optional<Joinable> build(DataSource dataSource, JoinConditionAnalysis condition) {
                return Optional.empty();
            }
        };
    }
}

