/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.client.BrokerInternalQueryConfig;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.metadata.metadata.AllColumnIncluderator;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.MapJoinableFactory;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AllowAllAuthenticator;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.server.security.NoopEscalator;
import org.apache.druid.sql.calcite.schema.AvailableSegmentMetadata;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.DruidSchemaTestCommon;
import org.apache.druid.sql.calcite.table.DruidTable;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.calcite.util.TestServerInventoryView;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidSchemaTest
extends DruidSchemaTestCommon {
    private SpecificSegmentsQuerySegmentWalker walker = null;
    private TestServerInventoryView serverView;
    private List<ImmutableDruidServer> druidServers;
    private DruidSchema schema = null;
    private DruidSchema schema2 = null;
    private CountDownLatch buildTableLatch = new CountDownLatch(1);
    private CountDownLatch markDataSourceLatch = new CountDownLatch(1);
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    @Before
    public void setUp() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        QueryableIndex index1 = IndexBuilder.create().tmpDir(new File(tmpDir, "1")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new DoubleSumAggregatorFactory("m1", "m1"), new HyperUniquesAggregatorFactory("unique_dim1", "dim1")}).withRollup(false).build()).rows((Iterable)ROWS1).buildMMappedIndex();
        QueryableIndex index2 = IndexBuilder.create().tmpDir(new File(tmpDir, "2")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new LongSumAggregatorFactory("m1", "m1")}).withRollup(false).build()).rows((Iterable)ROWS2).buildMMappedIndex();
        this.walker = new SpecificSegmentsQuerySegmentWalker(conglomerate).add(DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2000/P1Y")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index1).add(DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2001/P1Y")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index2).add(DataSegment.builder().dataSource("foo2").interval(index2.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index2);
        DataSegment segment1 = new DataSegment("foo3", Intervals.of((String)"2012/2013"), "version3", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), (ShardSpec)new NumberedShardSpec(2, 3), null, Integer.valueOf(1), 100L, DataSegment.PruneSpecsHolder.DEFAULT);
        ImmutableList realtimeSegments = ImmutableList.of((Object)segment1);
        this.serverView = new TestServerInventoryView(this.walker.getSegments(), (List<DataSegment>)realtimeSegments);
        this.druidServers = this.serverView.getDruidServers();
        this.schema = new DruidSchema(CalciteTests.createMockQueryLifecycleFactory(this.walker, conglomerate), this.serverView, this.segmentManager, (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of((Object)this.globalTableJoinable), (Map)ImmutableMap.of(this.globalTableJoinable.getClass(), GlobalTableDataSource.class)), PLANNER_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new BrokerInternalQueryConfig(), null){

            protected DruidTable buildDruidTable(String dataSource) {
                DruidTable table = super.buildDruidTable(dataSource);
                DruidSchemaTest.this.buildTableLatch.countDown();
                return table;
            }

            void markDataSourceAsNeedRebuild(String datasource) {
                super.markDataSourceAsNeedRebuild(datasource);
                DruidSchemaTest.this.markDataSourceLatch.countDown();
            }
        };
        this.schema2 = new DruidSchema(CalciteTests.createMockQueryLifecycleFactory(this.walker, conglomerate), this.serverView, this.segmentManager, (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of((Object)this.globalTableJoinable), (Map)ImmutableMap.of(this.globalTableJoinable.getClass(), GlobalTableDataSource.class)), PLANNER_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new BrokerInternalQueryConfig(), null){
            boolean throwException;
            {
                this.throwException = true;
            }

            protected DruidTable buildDruidTable(String dataSource) {
                DruidTable table = super.buildDruidTable(dataSource);
                DruidSchemaTest.this.buildTableLatch.countDown();
                return table;
            }

            protected Set<SegmentId> refreshSegments(Set<SegmentId> segments) throws IOException {
                if (this.throwException) {
                    this.throwException = false;
                    throw new RuntimeException("Query[xxxx] url[http://xxxx:8083/druid/v2/] timed out.");
                }
                return super.refreshSegments(segments);
            }

            void markDataSourceAsNeedRebuild(String datasource) {
                super.markDataSourceAsNeedRebuild(datasource);
                DruidSchemaTest.this.markDataSourceLatch.countDown();
            }
        };
        this.schema.start();
        this.schema.awaitInitialization();
    }

    @After
    public void tearDown() throws Exception {
        this.schema.stop();
        this.walker.close();
    }

    @Test
    public void testGetTableMap() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"foo2"), (Object)this.schema.getTableNames());
        Map tableMap = this.schema.getTableMap();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"foo2"), tableMap.keySet());
    }

    @Test
    public void testSchemaInit() throws InterruptedException {
        this.schema2.start();
        this.schema2.awaitInitialization();
        Map tableMap = this.schema2.getTableMap();
        Assert.assertEquals((long)2L, (long)tableMap.size());
        Assert.assertTrue((boolean)tableMap.containsKey("foo"));
        Assert.assertTrue((boolean)tableMap.containsKey("foo2"));
        this.schema2.stop();
    }

    @Test
    public void testGetTableMapFoo() {
        DruidTable fooTable = (DruidTable)this.schema.getTableMap().get("foo");
        RelDataType rowType = fooTable.getRowType((RelDataTypeFactory)new JavaTypeFactoryImpl());
        List fields = rowType.getFieldList();
        Assert.assertEquals((long)6L, (long)fields.size());
        Assert.assertEquals((Object)"__time", (Object)((RelDataTypeField)fields.get(0)).getName());
        Assert.assertEquals((Object)SqlTypeName.TIMESTAMP, (Object)((RelDataTypeField)fields.get(0)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"cnt", (Object)((RelDataTypeField)fields.get(1)).getName());
        Assert.assertEquals((Object)SqlTypeName.BIGINT, (Object)((RelDataTypeField)fields.get(1)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"dim1", (Object)((RelDataTypeField)fields.get(2)).getName());
        Assert.assertEquals((Object)SqlTypeName.VARCHAR, (Object)((RelDataTypeField)fields.get(2)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"dim2", (Object)((RelDataTypeField)fields.get(3)).getName());
        Assert.assertEquals((Object)SqlTypeName.VARCHAR, (Object)((RelDataTypeField)fields.get(3)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"m1", (Object)((RelDataTypeField)fields.get(4)).getName());
        Assert.assertEquals((Object)SqlTypeName.BIGINT, (Object)((RelDataTypeField)fields.get(4)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"unique_dim1", (Object)((RelDataTypeField)fields.get(5)).getName());
        Assert.assertEquals((Object)SqlTypeName.OTHER, (Object)((RelDataTypeField)fields.get(5)).getType().getSqlTypeName());
    }

    @Test
    public void testGetTableMapFoo2() {
        DruidTable fooTable = (DruidTable)this.schema.getTableMap().get("foo2");
        RelDataType rowType = fooTable.getRowType((RelDataTypeFactory)new JavaTypeFactoryImpl());
        List fields = rowType.getFieldList();
        Assert.assertEquals((long)3L, (long)fields.size());
        Assert.assertEquals((Object)"__time", (Object)((RelDataTypeField)fields.get(0)).getName());
        Assert.assertEquals((Object)SqlTypeName.TIMESTAMP, (Object)((RelDataTypeField)fields.get(0)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"dim2", (Object)((RelDataTypeField)fields.get(1)).getName());
        Assert.assertEquals((Object)SqlTypeName.VARCHAR, (Object)((RelDataTypeField)fields.get(1)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"m1", (Object)((RelDataTypeField)fields.get(2)).getName());
        Assert.assertEquals((Object)SqlTypeName.BIGINT, (Object)((RelDataTypeField)fields.get(2)).getType().getSqlTypeName());
    }

    @Test
    public void testAvailableSegmentMetadataNumRows() {
        Map segmentsMetadata = this.schema.getSegmentMetadataSnapshot();
        List segments = segmentsMetadata.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)4L, (long)segments.size());
        DataSegment existingSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        Assert.assertNotNull((Object)existingSegment);
        AvailableSegmentMetadata existingMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(existingSegment.getId());
        AvailableSegmentMetadata updatedMetadata = AvailableSegmentMetadata.from((AvailableSegmentMetadata)existingMetadata).withNumRows(5L).build();
        this.schema.setAvailableSegmentMetadata(existingSegment.getId(), updatedMetadata);
        Pair pair = this.druidServers.stream().flatMap(druidServer -> druidServer.iterateAllSegments().stream().filter(segment -> segment.getId().equals((Object)existingSegment.getId())).map(segment -> Pair.of((Object)druidServer, (Object)segment))).findAny().orElse(null);
        Assert.assertNotNull((Object)pair);
        ImmutableDruidServer server = (ImmutableDruidServer)pair.lhs;
        Assert.assertNotNull((Object)server);
        DruidServerMetadata druidServerMetadata = server.getMetadata();
        this.schema.addSegment(druidServerMetadata, existingSegment);
        segmentsMetadata = this.schema.getSegmentMetadataSnapshot();
        DataSegment currentSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        AvailableSegmentMetadata currentMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(currentSegment.getId());
        Assert.assertEquals((Object)updatedMetadata.getSegment().getId(), (Object)currentMetadata.getSegment().getId());
        Assert.assertEquals((long)updatedMetadata.getNumRows(), (long)currentMetadata.getNumRows());
        Assert.assertEquals((long)updatedMetadata.getNumReplicas(), (long)currentMetadata.getNumReplicas());
    }

    @Test
    public void testNullDatasource() throws IOException {
        Map segmentMetadatas = this.schema.getSegmentMetadataSnapshot();
        List segments = segmentMetadatas.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)4L, (long)segments.size());
        DataSegment segmentToRemove = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        Assert.assertNotNull((Object)segmentToRemove);
        this.schema.removeSegment(segmentToRemove);
        this.schema.refreshSegments(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()));
        Assert.assertEquals((long)3L, (long)this.schema.getSegmentMetadataSnapshot().size());
    }

    @Test
    public void testNullAvailableSegmentMetadata() throws IOException {
        Map segmentMetadatas = this.schema.getSegmentMetadataSnapshot();
        List segments = segmentMetadatas.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)4L, (long)segments.size());
        DataSegment segmentToRemove = segments.stream().filter(segment -> segment.getDataSource().equals("foo")).findFirst().orElse(null);
        Assert.assertNotNull((Object)segmentToRemove);
        this.schema.removeSegment(segmentToRemove);
        this.schema.refreshSegments(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()));
        Assert.assertEquals((long)3L, (long)this.schema.getSegmentMetadataSnapshot().size());
    }

    @Test
    public void testAvailableSegmentMetadataIsRealtime() {
        Map segmentsMetadata = this.schema.getSegmentMetadataSnapshot();
        List segments = segmentsMetadata.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        DataSegment existingSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo3")).findFirst().orElse(null);
        Assert.assertNotNull((Object)existingSegment);
        AvailableSegmentMetadata metadata = (AvailableSegmentMetadata)segmentsMetadata.get(existingSegment.getId());
        Assert.assertEquals((long)1L, (long)metadata.isRealtime());
        ImmutableDruidServer historicalServer = this.druidServers.stream().filter(s -> s.getType().equals((Object)ServerType.HISTORICAL)).findAny().orElse(null);
        Assert.assertNotNull((Object)historicalServer);
        DruidServerMetadata historicalServerMetadata = historicalServer.getMetadata();
        this.schema.addSegment(historicalServerMetadata, existingSegment);
        segmentsMetadata = this.schema.getSegmentMetadataSnapshot();
        DataSegment currentSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo3")).findFirst().orElse(null);
        Assert.assertNotNull((Object)currentSegment);
        AvailableSegmentMetadata currentMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(currentSegment.getId());
        Assert.assertEquals((long)0L, (long)currentMetadata.isRealtime());
        ImmutableDruidServer realtimeServer = this.druidServers.stream().filter(s -> s.getType().equals((Object)ServerType.REALTIME)).findAny().orElse(null);
        Assert.assertNotNull((Object)realtimeServer);
        this.schema.removeServerSegment(realtimeServer.getMetadata(), existingSegment);
        segmentsMetadata = this.schema.getSegmentMetadataSnapshot();
        currentSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo3")).findFirst().orElse(null);
        Assert.assertNotNull((Object)currentSegment);
        currentMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(currentSegment.getId());
        Assert.assertEquals((long)0L, (long)currentMetadata.isRealtime());
    }

    @Test
    public void testSegmentAddedCallbackAddNewHistoricalSegment() throws InterruptedException {
        final String datasource = "newSegmentAddTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        DruidSchema schema = new DruidSchema(CalciteTests.createMockQueryLifecycleFactory(this.walker, conglomerate), this.serverView, this.segmentManager, (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()), PLANNER_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new BrokerInternalQueryConfig(), null){

            protected void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }
        };
        this.serverView.addSegment(DruidSchemaTest.newSegment(datasource, 1), ServerType.HISTORICAL);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)5L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        AvailableSegmentMetadata metadata2 = (AvailableSegmentMetadata)metadatas.get(0);
        Assert.assertEquals((long)0L, (long)metadata2.isRealtime());
        Assert.assertEquals((long)0L, (long)metadata2.getNumRows());
        Assert.assertTrue((boolean)schema.getSegmentsNeedingRefresh().contains(metadata2.getSegment().getId()));
    }

    @Test
    public void testSegmentAddedCallbackAddExistingSegment() throws InterruptedException {
        final String datasource = "newSegmentAddTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(2);
        DruidSchema schema = new DruidSchema(CalciteTests.createMockQueryLifecycleFactory(this.walker, conglomerate), this.serverView, this.segmentManager, (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()), PLANNER_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new BrokerInternalQueryConfig(), null){

            protected void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }
        };
        DataSegment segment = DruidSchemaTest.newSegment(datasource, 1);
        this.serverView.addSegment(segment, ServerType.REALTIME);
        this.serverView.addSegment(segment, ServerType.HISTORICAL);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)5L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        AvailableSegmentMetadata metadata2 = (AvailableSegmentMetadata)metadatas.get(0);
        Assert.assertEquals((long)0L, (long)metadata2.isRealtime());
        Assert.assertEquals((long)0L, (long)metadata2.getNumRows());
        Assert.assertEquals((long)2L, (long)metadata2.getNumReplicas());
        Assert.assertTrue((boolean)schema.getSegmentsNeedingRefresh().contains(metadata2.getSegment().getId()));
        Assert.assertFalse((boolean)schema.getMutableSegments().contains(metadata2.getSegment().getId()));
    }

    @Test
    public void testSegmentAddedCallbackAddNewRealtimeSegment() throws InterruptedException {
        final String datasource = "newSegmentAddTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        DruidSchema schema = new DruidSchema(CalciteTests.createMockQueryLifecycleFactory(this.walker, conglomerate), this.serverView, this.segmentManager, (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()), PLANNER_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new BrokerInternalQueryConfig(), null){

            protected void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }
        };
        this.serverView.addSegment(DruidSchemaTest.newSegment(datasource, 1), ServerType.REALTIME);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)5L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        AvailableSegmentMetadata metadata2 = (AvailableSegmentMetadata)metadatas.get(0);
        Assert.assertEquals((long)1L, (long)metadata2.isRealtime());
        Assert.assertEquals((long)0L, (long)metadata2.getNumRows());
        Assert.assertTrue((boolean)schema.getSegmentsNeedingRefresh().contains(metadata2.getSegment().getId()));
        Assert.assertTrue((boolean)schema.getMutableSegments().contains(metadata2.getSegment().getId()));
    }

    @Test
    public void testSegmentAddedCallbackAddNewBroadcastSegment() throws InterruptedException {
        final String datasource = "newSegmentAddTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        DruidSchema schema = new DruidSchema(CalciteTests.createMockQueryLifecycleFactory(this.walker, conglomerate), this.serverView, this.segmentManager, (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()), PLANNER_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new BrokerInternalQueryConfig(), null){

            protected void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }
        };
        this.serverView.addSegment(DruidSchemaTest.newSegment(datasource, 1), ServerType.BROKER);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)4L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)0L, (long)metadatas.size());
        Assert.assertTrue((boolean)schema.getDataSourcesNeedingRebuild().contains(datasource));
    }

    @Test
    public void testSegmentRemovedCallbackEmptyDataSourceAfterRemove() throws InterruptedException, IOException {
        final String datasource = "segmentRemoveTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        final CountDownLatch removeSegmentLatch = new CountDownLatch(1);
        DruidSchema schema = new DruidSchema(CalciteTests.createMockQueryLifecycleFactory(this.walker, conglomerate), this.serverView, this.segmentManager, (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()), PLANNER_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new BrokerInternalQueryConfig(), null){

            protected void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            void removeSegment(DataSegment segment) {
                super.removeSegment(segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeSegmentLatch.countDown();
                }
            }
        };
        DataSegment segment = DruidSchemaTest.newSegment(datasource, 1);
        this.serverView.addSegment(segment, ServerType.REALTIME);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        schema.refresh((Set)Sets.newHashSet((Object[])new SegmentId[]{segment.getId()}), (Set)Sets.newHashSet((Object[])new String[]{datasource}));
        this.serverView.removeSegment(segment, ServerType.REALTIME);
        Assert.assertTrue((boolean)removeSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)4L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)0L, (long)metadatas.size());
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(segment.getId()));
        Assert.assertFalse((boolean)schema.getMutableSegments().contains(segment.getId()));
        Assert.assertFalse((boolean)schema.getDataSourcesNeedingRebuild().contains(datasource));
        Assert.assertFalse((boolean)schema.getTableNames().contains(datasource));
    }

    @Test
    public void testSegmentRemovedCallbackNonEmptyDataSourceAfterRemove() throws InterruptedException, IOException {
        final String datasource = "segmentRemoveTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(2);
        final CountDownLatch removeSegmentLatch = new CountDownLatch(1);
        DruidSchema schema = new DruidSchema(CalciteTests.createMockQueryLifecycleFactory(this.walker, conglomerate), this.serverView, this.segmentManager, (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()), PLANNER_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new BrokerInternalQueryConfig(), null){

            protected void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            void removeSegment(DataSegment segment) {
                super.removeSegment(segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeSegmentLatch.countDown();
                }
            }
        };
        ImmutableList segments = ImmutableList.of((Object)DruidSchemaTest.newSegment(datasource, 1), (Object)DruidSchemaTest.newSegment(datasource, 2));
        this.serverView.addSegment((DataSegment)segments.get(0), ServerType.REALTIME);
        this.serverView.addSegment((DataSegment)segments.get(1), ServerType.HISTORICAL);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        schema.refresh(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()), (Set)Sets.newHashSet((Object[])new String[]{datasource}));
        this.serverView.removeSegment((DataSegment)segments.get(0), ServerType.REALTIME);
        Assert.assertTrue((boolean)removeSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)5L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(((DataSegment)segments.get(0)).getId()));
        Assert.assertFalse((boolean)schema.getMutableSegments().contains(((DataSegment)segments.get(0)).getId()));
        Assert.assertTrue((boolean)schema.getDataSourcesNeedingRebuild().contains(datasource));
        Assert.assertTrue((boolean)schema.getTableNames().contains(datasource));
    }

    @Test
    public void testServerSegmentRemovedCallbackRemoveUnknownSegment() throws InterruptedException {
        final String datasource = "serverSegmentRemoveTest";
        final CountDownLatch removeServerSegmentLatch = new CountDownLatch(1);
        DruidSchema schema = new DruidSchema(CalciteTests.createMockQueryLifecycleFactory(this.walker, conglomerate), this.serverView, this.segmentManager, (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()), PLANNER_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new BrokerInternalQueryConfig(), null){

            void removeServerSegment(DruidServerMetadata server, DataSegment segment) {
                super.removeServerSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeServerSegmentLatch.countDown();
                }
            }
        };
        this.serverView.addSegment(DruidSchemaTest.newSegment(datasource, 1), ServerType.BROKER);
        this.serverView.removeSegment(DruidSchemaTest.newSegment(datasource, 1), ServerType.HISTORICAL);
        Assert.assertTrue((boolean)removeServerSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)4L, (long)schema.getTotalSegments());
    }

    @Test
    public void testServerSegmentRemovedCallbackRemoveBrokerSegment() throws InterruptedException {
        final String datasource = "serverSegmentRemoveTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        final CountDownLatch removeServerSegmentLatch = new CountDownLatch(1);
        DruidSchema schema = new DruidSchema(CalciteTests.createMockQueryLifecycleFactory(this.walker, conglomerate), this.serverView, this.segmentManager, (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()), PLANNER_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new BrokerInternalQueryConfig(), null){

            protected void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            void removeServerSegment(DruidServerMetadata server, DataSegment segment) {
                super.removeServerSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeServerSegmentLatch.countDown();
                }
            }
        };
        DataSegment segment = DruidSchemaTest.newSegment(datasource, 1);
        this.serverView.addSegment(segment, ServerType.HISTORICAL);
        this.serverView.addSegment(segment, ServerType.BROKER);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        this.serverView.removeSegment(segment, ServerType.BROKER);
        Assert.assertTrue((boolean)removeServerSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)5L, (long)schema.getTotalSegments());
        Assert.assertTrue((boolean)schema.getDataSourcesNeedingRebuild().contains(datasource));
    }

    @Test
    public void testServerSegmentRemovedCallbackRemoveHistoricalSegment() throws InterruptedException {
        final String datasource = "serverSegmentRemoveTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        final CountDownLatch removeServerSegmentLatch = new CountDownLatch(1);
        DruidSchema schema = new DruidSchema(CalciteTests.createMockQueryLifecycleFactory(this.walker, conglomerate), this.serverView, this.segmentManager, (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()), PLANNER_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new BrokerInternalQueryConfig(), null){

            protected void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            void removeServerSegment(DruidServerMetadata server, DataSegment segment) {
                super.removeServerSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeServerSegmentLatch.countDown();
                }
            }
        };
        DataSegment segment = DruidSchemaTest.newSegment(datasource, 1);
        this.serverView.addSegment(segment, ServerType.HISTORICAL);
        this.serverView.addSegment(segment, ServerType.BROKER);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        this.serverView.removeSegment(segment, ServerType.HISTORICAL);
        Assert.assertTrue((boolean)removeServerSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)5L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        AvailableSegmentMetadata metadata2 = (AvailableSegmentMetadata)metadatas.get(0);
        Assert.assertEquals((long)0L, (long)metadata2.isRealtime());
        Assert.assertEquals((long)0L, (long)metadata2.getNumRows());
        Assert.assertEquals((long)0L, (long)metadata2.getNumReplicas());
    }

    @Test
    public void testLocalSegmentCacheSetsDataSourceAsGlobalAndJoinable() throws InterruptedException {
        DruidTable fooTable = (DruidTable)this.schema.getTableMap().get("foo");
        Assert.assertNotNull((Object)fooTable);
        Assert.assertTrue((boolean)(fooTable.getDataSource() instanceof TableDataSource));
        Assert.assertFalse((boolean)(fooTable.getDataSource() instanceof GlobalTableDataSource));
        Assert.assertFalse((boolean)fooTable.isJoinable());
        Assert.assertFalse((boolean)fooTable.isBroadcast());
        Assert.assertTrue((boolean)this.buildTableLatch.await(1L, TimeUnit.SECONDS));
        this.buildTableLatch = new CountDownLatch(1);
        DataSegment someNewBrokerSegment = new DataSegment("foo", Intervals.of((String)"2012/2013"), "version1", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), (ShardSpec)new NumberedShardSpec(2, 3), null, Integer.valueOf(1), 100L, DataSegment.PruneSpecsHolder.DEFAULT);
        this.segmentDataSourceNames.add("foo");
        this.joinableDataSourceNames.add("foo");
        this.serverView.addSegment(someNewBrokerSegment, ServerType.BROKER);
        Assert.assertTrue((boolean)this.markDataSourceLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.buildTableLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.getDatasourcesLatch.await(2L, TimeUnit.SECONDS));
        fooTable = (DruidTable)this.schema.getTableMap().get("foo");
        Assert.assertNotNull((Object)fooTable);
        Assert.assertTrue((boolean)(fooTable.getDataSource() instanceof TableDataSource));
        Assert.assertTrue((boolean)(fooTable.getDataSource() instanceof GlobalTableDataSource));
        Assert.assertTrue((boolean)fooTable.isJoinable());
        Assert.assertTrue((boolean)fooTable.isBroadcast());
        this.markDataSourceLatch = new CountDownLatch(1);
        this.buildTableLatch = new CountDownLatch(1);
        this.getDatasourcesLatch = new CountDownLatch(1);
        this.joinableDataSourceNames.remove("foo");
        this.segmentDataSourceNames.remove("foo");
        this.serverView.removeSegment(someNewBrokerSegment, ServerType.BROKER);
        Assert.assertTrue((boolean)this.markDataSourceLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.buildTableLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.getDatasourcesLatch.await(2L, TimeUnit.SECONDS));
        fooTable = (DruidTable)this.schema.getTableMap().get("foo");
        Assert.assertNotNull((Object)fooTable);
        Assert.assertTrue((boolean)(fooTable.getDataSource() instanceof TableDataSource));
        Assert.assertFalse((boolean)(fooTable.getDataSource() instanceof GlobalTableDataSource));
        Assert.assertFalse((boolean)fooTable.isJoinable());
        Assert.assertFalse((boolean)fooTable.isBroadcast());
    }

    @Test
    public void testLocalSegmentCacheSetsDataSourceAsBroadcastButNotJoinable() throws InterruptedException {
        DruidTable fooTable = (DruidTable)this.schema.getTableMap().get("foo");
        Assert.assertNotNull((Object)fooTable);
        Assert.assertTrue((boolean)(fooTable.getDataSource() instanceof TableDataSource));
        Assert.assertFalse((boolean)(fooTable.getDataSource() instanceof GlobalTableDataSource));
        Assert.assertFalse((boolean)fooTable.isJoinable());
        Assert.assertFalse((boolean)fooTable.isBroadcast());
        Assert.assertTrue((boolean)this.buildTableLatch.await(1L, TimeUnit.SECONDS));
        this.buildTableLatch = new CountDownLatch(1);
        DataSegment someNewBrokerSegment = new DataSegment("foo", Intervals.of((String)"2012/2013"), "version1", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), (ShardSpec)new NumberedShardSpec(2, 3), null, Integer.valueOf(1), 100L, DataSegment.PruneSpecsHolder.DEFAULT);
        this.segmentDataSourceNames.add("foo");
        this.serverView.addSegment(someNewBrokerSegment, ServerType.BROKER);
        Assert.assertTrue((boolean)this.markDataSourceLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.buildTableLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.getDatasourcesLatch.await(2L, TimeUnit.SECONDS));
        fooTable = (DruidTable)this.schema.getTableMap().get("foo");
        Assert.assertNotNull((Object)fooTable);
        Assert.assertTrue((boolean)(fooTable.getDataSource() instanceof TableDataSource));
        Assert.assertFalse((boolean)(fooTable.getDataSource() instanceof GlobalTableDataSource));
        Assert.assertTrue((boolean)fooTable.isBroadcast());
        Assert.assertFalse((boolean)fooTable.isJoinable());
        this.markDataSourceLatch = new CountDownLatch(1);
        this.buildTableLatch = new CountDownLatch(1);
        this.getDatasourcesLatch = new CountDownLatch(1);
        this.segmentDataSourceNames.remove("foo");
        this.serverView.removeSegment(someNewBrokerSegment, ServerType.BROKER);
        Assert.assertTrue((boolean)this.markDataSourceLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.buildTableLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.getDatasourcesLatch.await(2L, TimeUnit.SECONDS));
        fooTable = (DruidTable)this.schema.getTableMap().get("foo");
        Assert.assertNotNull((Object)fooTable);
        Assert.assertTrue((boolean)(fooTable.getDataSource() instanceof TableDataSource));
        Assert.assertFalse((boolean)(fooTable.getDataSource() instanceof GlobalTableDataSource));
        Assert.assertFalse((boolean)fooTable.isBroadcast());
        Assert.assertFalse((boolean)fooTable.isJoinable());
    }

    @Test
    public void testRunSegmentMetadataQueryWithContext() throws Exception {
        ImmutableMap queryContext = ImmutableMap.of((Object)"priority", (Object)5);
        String brokerInternalQueryConfigJson = "{\"context\": { \"priority\": 5} }";
        TestHelper.makeJsonMapper();
        BrokerInternalQueryConfig brokerInternalQueryConfig = (BrokerInternalQueryConfig)MAPPER.readValue(MAPPER.writeValueAsString(MAPPER.readValue(brokerInternalQueryConfigJson, BrokerInternalQueryConfig.class)), BrokerInternalQueryConfig.class);
        DataSegment segment = DruidSchemaTest.newSegment("test", 0);
        ImmutableList segmentIterable = ImmutableList.of((Object)segment.getId());
        SegmentMetadataQuery expectedMetadataQuery = new SegmentMetadataQuery((DataSource)new TableDataSource(segment.getDataSource()), (QuerySegmentSpec)new MultipleSpecificSegmentSpec(segmentIterable.stream().map(SegmentId::toDescriptor).collect(Collectors.toList())), (ColumnIncluderator)new AllColumnIncluderator(), Boolean.valueOf(false), (Map)queryContext, EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class), Boolean.valueOf(false), Boolean.valueOf(false));
        QueryLifecycleFactory factoryMock = (QueryLifecycleFactory)EasyMock.createMock(QueryLifecycleFactory.class);
        QueryLifecycle lifecycleMock = (QueryLifecycle)EasyMock.createMock(QueryLifecycle.class);
        DruidSchema mySchema = new DruidSchema(factoryMock, (TimelineServerView)this.serverView, this.segmentManager, (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of((Object)this.globalTableJoinable), (Map)ImmutableMap.of(this.globalTableJoinable.getClass(), GlobalTableDataSource.class)), PLANNER_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), brokerInternalQueryConfig, null);
        EasyMock.expect((Object)factoryMock.factorize()).andReturn((Object)lifecycleMock).once();
        EasyMock.expect((Object)lifecycleMock.runSimple((Query)expectedMetadataQuery, AllowAllAuthenticator.ALLOW_ALL_RESULT, Access.OK)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{factoryMock, lifecycleMock});
        mySchema.runSegmentMetadataQuery((Iterable)segmentIterable);
        EasyMock.verify((Object[])new Object[]{factoryMock, lifecycleMock});
    }

    @Test
    public void testSegmentMetadataColumnType() {
        RowSignature signature = DruidSchema.analysisToRowSignature((SegmentAnalysis)new SegmentAnalysis("id", (List)ImmutableList.of((Object)Intervals.utc((long)1L, (long)2L)), (Map)ImmutableMap.of((Object)"a", (Object)new ColumnAnalysis(ColumnType.STRING, ColumnType.STRING.asTypeString(), false, true, 1234L, Integer.valueOf(26), (Comparable)((Object)"a"), (Comparable)((Object)"z"), null), (Object)"count", (Object)new ColumnAnalysis(ColumnType.LONG, ColumnType.LONG.asTypeString(), false, true, 1234L, Integer.valueOf(26), (Comparable)((Object)"a"), (Comparable)((Object)"z"), null)), 1234L, 100L, null, null, null, null));
        Assert.assertEquals((Object)RowSignature.builder().add("a", ColumnType.STRING).add("count", ColumnType.LONG).build(), (Object)signature);
    }

    @Test
    public void testSegmentMetadataFallbackType() {
        RowSignature signature = DruidSchema.analysisToRowSignature((SegmentAnalysis)new SegmentAnalysis("id", (List)ImmutableList.of((Object)Intervals.utc((long)1L, (long)2L)), (Map)ImmutableMap.of((Object)"a", (Object)new ColumnAnalysis(null, ColumnType.STRING.asTypeString(), false, true, 1234L, Integer.valueOf(26), (Comparable)((Object)"a"), (Comparable)((Object)"z"), null), (Object)"count", (Object)new ColumnAnalysis(null, ColumnType.LONG.asTypeString(), false, true, 1234L, Integer.valueOf(26), (Comparable)((Object)"a"), (Comparable)((Object)"z"), null)), 1234L, 100L, null, null, null, null));
        Assert.assertEquals((Object)RowSignature.builder().add("a", ColumnType.STRING).add("count", ColumnType.LONG).build(), (Object)signature);
    }

    private static DataSegment newSegment(String datasource, int partitionId) {
        return new DataSegment(datasource, Intervals.of((String)"2012/2013"), "version1", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), (ShardSpec)new NumberedShardSpec(partitionId, 0), null, Integer.valueOf(1), 100L, DataSegment.PruneSpecsHolder.DEFAULT);
    }
}

