/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.druid.client.BrokerInternalQueryConfig;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.MapJoinableFactory;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.server.security.NoopEscalator;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.calcite.util.TestServerInventoryView;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DruidSchemaNoDataInitTest
extends CalciteTestBase {
    private static final PlannerConfig PLANNER_CONFIG_DEFAULT = new PlannerConfig();

    @Test
    public void testInitializationWithNoData() throws Exception {
        try (Closer closer = Closer.create();){
            QueryRunnerFactoryConglomerate conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)closer);
            DruidSchema druidSchema = new DruidSchema(CalciteTests.createMockQueryLifecycleFactory(new SpecificSegmentsQuerySegmentWalker(conglomerate), conglomerate), (TimelineServerView)new TestServerInventoryView(Collections.emptyList()), new SegmentManager((SegmentLoader)EasyMock.createMock(SegmentLoader.class)), (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()), PLANNER_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new BrokerInternalQueryConfig(), null);
            druidSchema.start();
            druidSchema.awaitInitialization();
            Assert.assertEquals((Object)ImmutableMap.of(), (Object)druidSchema.getTableMap());
        }
    }
}

