/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.rule.FilterJoinExcludePushToChildRule;
import org.junit.Assert;
import org.junit.Test;

public class FilterJoinExcludePushToChildRuleTest {
    private final RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl());
    private final RelDataTypeFactory typeFactory = new SqlTypeFactoryImpl((RelDataTypeSystem)DruidTypeSystem.INSTANCE);

    @Test
    public void testRemoveRedundantIsNotNullFiltersWithSQLCompatibility() {
        RexNode equalityFilter = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), 0), this.rexBuilder.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), 1)});
        RexNode isNotNullFilterOnJoinColumn = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, (List)ImmutableList.of((Object)this.rexBuilder.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), 1)));
        RexNode isNotNullFilterOnNonJoinColumn = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, (List)ImmutableList.of((Object)this.rexBuilder.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), 2)));
        ArrayList<RexNode> joinFilters = new ArrayList<RexNode>();
        joinFilters.add(equalityFilter);
        FilterJoinExcludePushToChildRule.removeRedundantIsNotNullFilters(joinFilters, (JoinRelType)JoinRelType.INNER, (boolean)true);
        Assert.assertEquals((long)joinFilters.size(), (long)1L);
        Assert.assertEquals((String)"Equality Filter changed", joinFilters.get(0), (Object)equalityFilter);
        joinFilters.add(isNotNullFilterOnNonJoinColumn);
        joinFilters.add(isNotNullFilterOnJoinColumn);
        Assert.assertEquals((long)joinFilters.size(), (long)3L);
        FilterJoinExcludePushToChildRule.removeRedundantIsNotNullFilters(joinFilters, (JoinRelType)JoinRelType.INNER, (boolean)true);
        Assert.assertEquals((long)joinFilters.size(), (long)2L);
        Assert.assertEquals((String)"Equality Filter changed", joinFilters.get(0), (Object)equalityFilter);
        Assert.assertEquals((String)"IS NOT NULL filter on non-join column changed", joinFilters.get(1), (Object)isNotNullFilterOnNonJoinColumn);
    }
}

